package org.simantics.db.layer0.variable;

import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;

public class VariableBean extends Bean {

	final public long context;
	final public String rvi;
	final transient public Variable variable;
	
	public VariableBean(ReadGraph graph, Variable variable) throws DatabaseException {
		
		Variable context = Variables.getPossibleContext(graph, variable);
		if(context != null) {
			RVI rvi = variable.getRVI(graph);
			Resource contextResource = context.getRepresents(graph);
			this.context = contextResource.getResourceId();
			this.rvi = rvi.toString();
		} else {
			this.context = 0;
			this.rvi = variable.getURI(graph);
		}

		this.variable = variable;

	}
	
	public Variable getVariable(ReadGraph graph) throws DatabaseException {
		if(context != 0) {
			Resource contextResource = graph.getService(SerialisationSupport.class).getResource(context);
			Variable context = Variables.getVariable(graph, contextResource);
			RVI rvi = RVI.fromResourceFormat(graph, this.rvi);
			return rvi.resolve(graph, context);
		} else {
			return Variables.getVariable(graph, rvi);
		}
	}
	
	public Variable getVariable() {
		return variable;
	}
	
}
