package org.simantics.db.layer0.variable;

import java.util.concurrent.TimeUnit;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.layer0.variable.Variables.NodeStructure;
import org.simantics.simulator.variable.NodeManager;

/**
 * @author Antti Villberg
 *
 * @param <Node>
 * @since 1.23
 */
public class NodeSupport<Node> {

	public final NodeManager<Node> manager;
	public final NodeCache<Node,Variant> valueCache;
	public final NodeCache<Node,NodeStructure> structureCache;

	public NodeSupport(NodeManager<Node> manager) {
		this(manager, 1, TimeUnit.SECONDS);
	}

	public NodeSupport(NodeManager<Node> manager, long defaultExpirationTime, TimeUnit expirationTimeUnit) {
		if (manager == null)
			throw new NullPointerException("null NodeManager");
		long ns = expirationTimeUnit.toNanos(defaultExpirationTime);
		this.manager = manager;
		this.valueCache = new NodeCache<>(ns);
		this.structureCache = new NodeCache<>(ns);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + valueCache.hashCode();
		result = prime * result + structureCache.hashCode();
		result = prime * result + manager.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		NodeSupport<?> other = (NodeSupport<?>) obj;
		return valueCache.equals(other.valueCache)
				&& structureCache.equals(other.structureCache)
				&& manager.equals(other.manager);
	}

	public void dispose() {
		valueCache.dispose();
		structureCache.dispose();
	}

}
