/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;

import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

import org.apache.commons.io.output.DeferredFileOutputStream;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.SubgraphExtent.ExtentStatus;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.ClusterControl.ClusterState;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

/**
 * @deprecated in favor of {@link ModelTransferableGraphSourceRequest}
 */
@Deprecated
public class TransferableGraphRequest2 implements Read<TransferableGraph1> {

	public static String LOG_FILE = "transferableGraph.log";
	final static private boolean LOG = false;
	final static private boolean DEBUG = false;
	final static private boolean PROFILE = false;
	
	private TransferableGraphConfiguration configuration;
	
	static DataOutput log;

	static {

		if (LOG) {
			try {
				FileOutputStream stream = new FileOutputStream(LOG_FILE);
				log = new DataOutputStream(stream);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}

	}
	
	private static void log(String line) {
		if (LOG) {
			try {
				log.writeUTF(line + "\n");
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	
	
	public TransferableGraphRequest2(Collection<Pair<Resource, String>> roots, Resource model) {
		
		configuration = new TransferableGraphConfiguration();
		configuration.roots = roots;
		configuration.model = model;
		
	}

	
	public TransferableGraphRequest2(Collection<Pair<Resource, String>> roots) {
		this(roots, null);
	}

	public TransferableGraphRequest2(TransferableGraphConfiguration conf) {
		this.configuration = conf;
	}

	Layer0 L0;
	
	TIntArrayList inverses = new TIntArrayList();
	int statements[];
	int statementIndex = 0;
	TIntIntHashMap ids;
	TIntObjectMap<Variant> values;
	TIntArrayList externalParents = new TIntArrayList();
	ArrayList<String> externalNames = new ArrayList<String>(); 
	int id = 0;
	int internalCount;
	
	int indent = 0;

	private SerialisationSupport support;

	private boolean validateExternal(Resource r) {
		if(configuration.disallowedExternals != null) {
			System.err.println("validateExternal agains " + configuration.disallowedExternals);
			return !configuration.disallowedExternals.contains(r);
		}
		return true;
	}
	
	private Resource getResource(int r) throws DatabaseException {
		return support.getResource(r);
	}
	
	public int getInternalId(int r) {
		return ids.get(r);
	}
	
	public int getId(ReadGraph graph, int r, int predicate) throws DatabaseException {
		if(ids.containsKey(r)) {
		    int ret = ids.get(r);
		    if(ret == -1) {
		        for(int i=0;i<=indent;++i)
		            System.out.print("  ");
		        System.out.println("Cycle!!!"); // with " + GraphUtils.getReadableName(g, r));
		    }
			return ret;
		}
		else {
			Collection<Resource> parents = graph.getObjects(getResource(r), L0.PartOf);			
			if(parents.size() != 1) {
				throw new ValidationException("Reference to external resource " 
						+ NameUtils.getSafeName(graph, getResource(r), true) + " without unique uri (" + parents.size() + " parents).");
			}
			for(Resource p : parents) {
			    ++indent;
	            if(!validateExternal(p)) throw new ValidationException("References to '" + graph.getURI(p) + "' are not allowed.");
				externalParents.add(getId(graph, support.getTransientId(p), 0));
				--indent;
			}
            externalNames.add((String)graph.getRelatedValue(getResource(r), L0.HasName));
			ids.put(r, id);
			return id++;
		}
	}
	
	public void addId(ReadGraph graph, int r, int predicate) throws DatabaseException {
		statements[statementIndex++] = getId(graph, r, predicate); 
	}
	
	public void setExternals(Collection<Resource> rs) {
		configuration.externals = rs;
	}
	
	@Override
	public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {

		support = graph.getService(SerialisationSupport.class);

		this.L0 = Layer0.getInstance(graph);	

		long total = System.nanoTime();

    	long startupTime = System.nanoTime();

    	ClusterControl cc = graph.getService(ClusterControl.class);
    	
    	ids = new TIntIntHashMap();
    	values = new TIntObjectHashMap<Variant>();
    	
		ArrayList<Resource> rootResources = new ArrayList<Resource>();
		for(Pair<Resource, String> p : configuration.roots) rootResources.add(p.first);

		Map<Resource, ExtentStatus> preStatus = new HashMap<Resource, ExtentStatus>();
		
		for(Resource root : rootResources) {
			Resource name = graph.getPossibleObject(root, L0.HasName);
			if(name != null) {
				preStatus.put(name, ExtentStatus.EXCLUDED);
			}
		}
		
		for(Resource r : configuration.externals) preStatus.put(r, ExtentStatus.EXTERNAL); 

    	long startupTimeEnd = System.nanoTime();

		long domainTime = System.nanoTime();
		
		String otherStatements = "other" + UUID.randomUUID().toString();
		String valueFileName = "value" + UUID.randomUUID().toString();
		
        File otherStatementsFile = new File(otherStatements);
        File valueFile = new File(valueFileName);
        
        try {
        
        	DeferredFileOutputStream otherStatementsStream = new DeferredFileOutputStream(1024*1024, otherStatementsFile);
        	DeferredFileOutputStream valueStream = new DeferredFileOutputStream(1024*1024, valueFile);
        	
        	ObjectOutputStream otherStatementsOutput = new ObjectOutputStream(otherStatementsStream);
        	ObjectOutputStream valueOutput = new ObjectOutputStream(valueStream);

        	ClusterState clusterState = cc.getClusterState();

        	TIntHashSet excludedShared = new TIntHashSet();
        	
        	TreeMap<String, Variant> extensions = new TreeMap<String, Variant>();
        	
        	Subgraphs.getDomain2(graph, ids, rootResources, preStatus, configuration.specials, otherStatementsOutput, valueOutput, extensions, excludedShared);
        	
        	id = ids.size();

        	cc.restoreClusterState(clusterState);

//    		dumpHeap("domain.hprof");

        	otherStatementsOutput.flush();
        	valueOutput.flush();
        	otherStatementsStream.close();
        	valueStream.close();
		
        	long domainDuration = System.nanoTime() - domainTime;
        	System.err.println("Analysed graph in " + 1e-9*domainDuration + "s.");

        	internalCount = id;

        	ids.put(support.getTransientId(graph.getResource("http:/")), id++);
        	externalNames.add("http:/");
        	externalParents.add(-1);

        	InputStream otherStatementsInputStream = null;
        	InputStream valueInputStream = null;
        	
        	if(otherStatementsStream.isInMemory()) {
        		otherStatementsInputStream = new ByteArrayInputStream(otherStatementsStream.getData());
        	} else {
        		otherStatementsInputStream = new FileInputStream(otherStatementsFile);
        	}

        	if(valueStream.isInMemory()) {
        		valueInputStream = new ByteArrayInputStream(valueStream.getData());
        	} else {
        		valueInputStream = new FileInputStream(valueFile);
        	}

        	otherStatementsStream = null;
        	valueStream = null;
        	
        	ObjectInputStream otherStatementsInput = new ObjectInputStream(otherStatementsInputStream);
        	ObjectInputStream valueInput = new ObjectInputStream(valueInputStream);

        	long statementTime = System.nanoTime();
    		
        	TIntArrayList statementSet = new TIntArrayList();
        	
    		while(otherStatementsInput.available() > 0) {
    			
    			int s = otherStatementsInput.readInt();
    			
    			boolean exclude = !ids.contains(s);
    			
    			int size = otherStatementsInput.readInt();
    			for(int i=0;i<size;i++) {
    				int p = otherStatementsInput.readInt();
    				int o = otherStatementsInput.readInt();
    				if(!exclude) {
    					if(excludedShared.contains(o)) {
//    						System.err.println("excluding shared " + s + " " + p + " " + o);
    					} else {
		    				statementSet.add(s);
		    				statementSet.add(p);
		    				statementSet.add(o);
    					}
    				} else {
//						System.err.println("excluding shared " + s);
    				}
    			}
    			
    		}

    		TIntIntHashMap inverses = new TIntIntHashMap();
    		TIntHashSet predicateSet = new TIntHashSet();
    		for(int i=0;i<statementSet.size();i+=3) {
    			int p = statementSet.getQuick(i+1);
    			if(predicateSet.add(p)) {
					Resource inverse = graph.getPossibleInverse(getResource(p));
					if(inverse != null) inverses.put(p, support.getTransientId(inverse));
    			}
    		}
    			
    		predicateSet = null;
    		
    		TIntArrayList tgStatements = new TIntArrayList();
    		
//    		dumpHeap("export.hprof");

    		// 25%
    		int trim = Math.max(65536,statementSet.size()/12);
    		
    		for(int i=statementSet.size();i>0;i-=3) {

    			if(trim-- == 0) {
    				statementSet.remove(i, statementSet.size()-i);
    				statementSet.trimToSize();
    				trim = Math.max(65536,statementSet.size()/12);
    			}

    			int s = statementSet.getQuick(i-3);
    			int p = statementSet.getQuick(i-2);
    			int o = statementSet.getQuick(i-1);
    		
    			int subjectId = ids.get(s);
    			if(subjectId >= internalCount) System.err.println("Statement for external: " + s + " " + p + " " + o);
    			
    			int objectId = getId(graph, o, p);
    			// The statement can be denied still
    			if(objectId != -2) {
    				tgStatements.add(subjectId);
    				tgStatements.add(getId(graph, p, 0));
    				int inverse = inverses.get(p);
    				if(inverse != 0) {
    					tgStatements.add(getId(graph, inverse, 0));
    				} else {
    					tgStatements.add(-1);
    				}
    				tgStatements.add(objectId);
    			} else {
    				System.out.println("denied");
    			}
    			
    		}
    		
    		statements = tgStatements.toArray();

        	long statementDuration = System.nanoTime() - statementTime;
        	System.err.println("Built transferable statements in " + 1e-9*statementDuration + "s.");
    		
    		inverses = null;
    		
    		while(valueInput.available() > 0) {

    			int s = valueInput.readInt();
//    			Resource subject = support.getResource(s);
    			int valueSize = valueInput.readInt();
    			byte[] value = new byte[valueSize];
    			valueInput.readFully(value);
    			Variant variant = (Variant)Bindings.VARIANT.serializer().deserialize(value);
    			values.put(s, variant);
    			
    		}

        	int resourceCount = ids.size();

        	Identity[] identityArray;
        	{ // Identities
        		ArrayList<Identity> identities = new ArrayList<Identity>();

        		for(Pair<Resource, String> r : configuration.roots) {
        			Resource type = graph.getPossibleType(r.first, L0.Entity);
        			if(type == null) type = L0.Entity;
        			identities.add(new Identity(
        					ids.get(support.getTransientId(r.first)),
        					new Root(r.second, graph.getURI(type))
        			));
        		}

        		int internalsPlusExternals = ids.size();		
        		for(int i = internalCount; i < internalsPlusExternals ; i++) {
        			int parent = externalParents.get(i - internalCount);
        			String name = externalNames.get(i - internalCount);
        			identities.add(new Identity(
        					i, 
        					new External(parent, name)
        			));
        		}
        		identityArray = identities.toArray(new Identity[identities.size()]);
        	}	
            
            final Value[] valueArray = new Value[values.size()];
        	{ // Values
        		values.forEachEntry(new TIntObjectProcedure<Variant>() {

            		int index = 0;

					@Override
					public boolean execute(int subject, Variant bytes) {
	        			//if(LOG) log("[VALUE] " + entry.getKey().getResourceId());
	        			int r = getInternalId(subject);
	        			if(r==-1) System.err.println("No id for value resource " + subject);
	        			else valueArray[index++] = new Value(r, bytes);
	        			return true;
					}
					
				});
        	}
            ids = null;
        	values = null;

            TransferableGraph1 result = 
                new TransferableGraph1(resourceCount, 
                        identityArray, 
                        statements, 
                        valueArray, extensions);
            
        	if(DEBUG) {
        		System.out.println("transferable graph content: " + result);
        	}

        	long totalEnd = System.nanoTime();

        	if(PROFILE) {	
        		System.out.println("startup in " + 1e-9*(startupTimeEnd - startupTime) + "s.");
        		System.out.println("domain was found in " + 1e-9*(domainDuration) + "s.");
        		System.out.println("statements were found in " + 1e-9*(statementDuration) + "s.");
        		System.out.println("total time for building subgraph was " + 1e-9*(totalEnd-total) + "s.");
        	}

        	return result;

        } catch (IOException e) {
        	e.printStackTrace();
        } catch (Throwable t) {
        	t.printStackTrace();
        	dumpHeap("crash.hprof");
        }
		
        return null;
		
	}

	private static void dumpHeap(String path) {
		
        try {
            Object bean = getBean();
            if (bean == null)
                return;

            Method m = bean.getClass().getMethod("dumpHeap", String.class, boolean.class);
            m.invoke(bean, path, true);
            
        } catch (IllegalArgumentException e) {
        } catch (IllegalAccessException e) {
        } catch (SecurityException e) {
        } catch (NoSuchMethodException e) {
        } catch (InvocationTargetException e) {
		} finally {
        }
		
	}
	
    private static Object getBean() {
        Class<?> beanClass = getBeanClass();
        if (beanClass == null)
            return null;
        try {
            Object bean = ManagementFactory.newPlatformMXBeanProxy(
                    ManagementFactory.getPlatformMBeanServer(),
                    "com.sun.management:type=HotSpotDiagnostic",
                    beanClass);
            return bean;
        } catch (IOException e) {
            return null;
        }
    }
    
    private static Class<?> getBeanClass() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return clazz;
        } catch (ClassNotFoundException e) {
            return null;
        }
    }
    
	
}
