package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent.ExtentStatus;
import org.simantics.db.layer0.util.DomainProcessor3.ExclusionDecision;
import org.simantics.scl.runtime.function.Function1;

public class TransferableGraphConfiguration2 {
	
	public static class RootSpec {
		public final Resource resource;
		public final String name;
		public final boolean internal;

		public RootSpec(Resource resource, String name, boolean internal) {
			if (resource == null)
				throw new NullPointerException("null resource");
			if (name == null)
				throw new NullPointerException("null name");
			this.resource = resource;
			this.name = name;
			this.internal = internal;
		}

		@Override
		public String toString() {
			return "RootSpec[" + name + ", " + resource + ", " + internal + "]"; 
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + (internal ? 1231 : 1237);
			result = prime * result + resource.hashCode();
			result = prime * result + name.hashCode();
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			RootSpec other = (RootSpec) obj;
			return internal == other.internal && resource.equals(other.resource) && name.equals(other.name);
		}
	}
	
	final public TreeMap<String, Variant> baseExtensions = new TreeMap<String,Variant>();
	final public Resource indexRoot;
	final public Collection<RootSpec> roots;
	final public Map<Resource, ExtentStatus> preStatus;
	final public boolean ignoreVirtualResources;
	final public boolean validate;
	
	/**
	 * <code>true</code> to export values, <code>false</code> to skip the actual
	 * values and only write the resource id.
	 */
	public boolean values = true;

	public Collection<TGValueModifier> valueModifiers;
	public Function1<Statement,ExclusionDecision> exclusionFunction;

	public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, ExtentStatus> preStatus, boolean ignoreVirtualResources, boolean validate) {
		this.indexRoot = indexRoot;
		this.roots = roots;
		this.preStatus = preStatus;
		this.ignoreVirtualResources = ignoreVirtualResources;
		this.validate = validate;
		this.valueModifiers = null;
	}

	public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, ExtentStatus> preStatus, boolean ignoreVirtualResources) {
		this(indexRoot, roots, preStatus, ignoreVirtualResources, true);
	}

	public TransferableGraphConfiguration2(Resource indexRoot, Collection<RootSpec> roots, Map<Resource, ExtentStatus> preStatus) {
		this(indexRoot, roots, preStatus, true);
	}

	public TransferableGraphConfiguration2(TransferableGraphConfiguration2 conf) throws DatabaseException {
		this(conf.indexRoot, conf.roots, conf.preStatus, conf.ignoreVirtualResources, conf.validate);
	}

	public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
		this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(Collections.singletonList(model)).create());
	}

	public TransferableGraphConfiguration2(ReadGraph graph, Collection<Resource> roots, boolean ignoreVirtualResources, boolean validate) throws DatabaseException {
	    this(new TGConfigurer(graph, ignoreVirtualResources, validate).roots2(roots).create());
	}

	public TransferableGraphConfiguration2(ReadGraph graph, Resource model, boolean ignoreVirtualResources) throws DatabaseException {
		this(graph, model, ignoreVirtualResources, true);
	}

	public TransferableGraphConfiguration2(ReadGraph graph, Resource model) throws DatabaseException {
		this(graph, model, true);
	}
	
	public TransferableGraphConfiguration2(ReadGraph graph, Collection<RootSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions) throws DatabaseException {
		this(new TGConfigurer(graph, true).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
	}

	public TransferableGraphConfiguration2(ReadGraph graph, Collection<RootSpec> roots, Collection<Resource> resourceRoots, Collection<Resource> exclusions, boolean ignoreVirtualResource, boolean validate) throws DatabaseException {
		this(new TGConfigurer(graph, ignoreVirtualResource, validate).roots(roots).roots2(resourceRoots).exclusions(exclusions).create());
	}

	public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, final Collection<NamedResource> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
		return processor.sync(new UniqueRead<TransferableGraphConfiguration2>() {

			@Override
			public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
				return new TransferableGraphConfiguration2(graph, translate(roots), Collections.<Resource>emptyList(), exclusions, ignoreVirtualResource, validate);
			}
			
		});
	}

	public static TransferableGraphConfiguration2 createWithNames2(RequestProcessor processor, final Collection<RootSpec> roots, final Collection<Resource> exclusions, final boolean ignoreVirtualResource, final boolean validate) throws DatabaseException {
		return processor.sync(new UniqueRead<TransferableGraphConfiguration2>() {

			@Override
			public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
				return new TransferableGraphConfiguration2(graph, roots, Collections.<Resource>emptyList(), exclusions, ignoreVirtualResource, validate);
			}
			
		});
	}

	public static TransferableGraphConfiguration2 createWithNames(RequestProcessor processor, final Collection<NamedResource> roots, final Collection<Resource> exclusions) throws DatabaseException {
		return createWithNames(processor, roots, exclusions, true, true);
	}

	public static TransferableGraphConfiguration2 createWithResources(RequestProcessor processor, final Collection<Resource> roots, final Collection<Resource> exclusions) throws DatabaseException {
		return processor.sync(new UniqueRead<TransferableGraphConfiguration2>() {

			@Override
			public TransferableGraphConfiguration2 perform(ReadGraph graph) throws DatabaseException {
				return new TransferableGraphConfiguration2(graph, Collections.<RootSpec>emptyList(), roots, exclusions);
			}
			
		});
	}

	public static TransferableGraphConfiguration2 createForModel(RequestProcessor processor, final Resource model) throws DatabaseException {
		return createWithResources(processor, Collections.singletonList(model), Collections.<Resource>emptyList());
	}

	private static Collection<RootSpec> translate(Collection<NamedResource> roots) {
		ArrayList<RootSpec> result = new ArrayList<RootSpec>();
		for(NamedResource nr : roots) result.add(new RootSpec(nr.getResource(), nr.getName(), true));
		return result;
	}
	
}
