package org.simantics.db.layer0.request;

import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.operation.Layer0X;

public class ActivateModel extends WriteResultRequest<Boolean> {

    final Resource project;
    final Resource model;

    public ActivateModel(Resource project, Resource model) {
        
        if(project == null) throw new IllegalArgumentException("project can not be null");
        this.project = project;
        this.model = model;
        
    }

    public static Boolean perform(WriteGraph graph, Resource project, Resource model) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance(graph);
        if (model != null) {
            if (!graph.hasStatement(model, L0X.IsActivatedBy, project)) {
                graph.deny(project, L0X.Activates);
                graph.claim(project, L0X.Activates, model);
                return true;
            }
        } else {
            if (graph.hasStatement(project, L0X.Activates)) {
                graph.deny(project, L0X.Activates);
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean perform(WriteGraph graph) throws DatabaseException {
        VirtualGraphSupport support = graph.getService(VirtualGraphSupport.class);
        VirtualGraph activations = support.getWorkspacePersistent("activations");
        VirtualGraph vg = graph.getProvider();
        if (vg == activations) {
            return perform(graph, project, model);
        } else {
            return graph.syncRequest(new WriteResultRequest<Boolean>() {
                @Override
                public Boolean perform(WriteGraph graph) throws DatabaseException {
                    return ActivateModel.perform(graph, project, model);
                }
            });
        }
    }

}
