/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.exception;

import org.simantics.db.layer0.variable.Variable;

/**
 * This exception should be thrown by Varible implementations when a modifying
 * method is invoked but the variable is considered non-writable.
 * 
 * <p>
 * Such modifying methods include
 * <ul>
 * <li>{@link Variable#setPropertyValue(org.simantics.db.WriteGraph, String, Object)}</li>
 * <li>{@link Variable#setPropertyValue(org.simantics.db.WriteGraph, String, Object, org.simantics.databoard.binding.Binding)
 * <li>{@link Variable#setValue(org.simantics.db.WriteGraph, Object)
 * <li>{@link Variable#setValue(org.simantics.db.WriteGraph, Object, org.simantics.databoard.binding.Binding)}</li>
 * </ul>
 * 
 * @author Tuukka Lehtonen
 */
public class NonWritableVariableException extends VariableException {

    private static final long serialVersionUID = 2206215294220670641L;

    public NonWritableVariableException() {
        super();
    }

    public NonWritableVariableException(String message, Throwable cause) {
        super(message, cause);
    }

    public NonWritableVariableException(String message) {
        super(message);
    }

    public NonWritableVariableException(Throwable cause) {
        super(cause);
    }

}
