/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;

/**
 * @author Antti Villberg
 */
public class TrashBinRemover extends AbstractRemover {

    public TrashBinRemover(Resource resource) {
        super(resource);
    }

    @Override
    public void remove(final WriteGraph graph) throws DatabaseException {

    	Layer0 L0 = Layer0.getInstance(graph);
    	
    	Resource project = SimanticsInternal.getProject();
    	Resource parent = graph.getSingleObject(project, L0.PartOf);
    	Resource trashBin = Layer0Utils.getPossibleChild(graph, parent, "TrashBin");
    	if(trashBin == null) throw new DatabaseException("TrashBin resource could not be located.");
    	
        String oldName = graph.getPossibleRelatedValue2(resource, L0.HasName);
        if (oldName != null) {
            String newName = NameUtils.findFreshName(graph, oldName, trashBin);
            graph.claimLiteral(resource, L0.HasName, newName);
        }
    	graph.deny(resource, L0.PartOf);
    	graph.claim(trashBin, L0.ConsistsOf, L0.PartOf, resource);
    }

}
