/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.TransferableGraphSource.TransferableGraphSourceProcedure;

/**
 * @author Tuukka Lehtonen
 */
public class TGRemover extends AbstractRemover {

    @SuppressWarnings("unused")
    private IProgressMonitor monitor;

    public TGRemover(Resource resource) {
        super(resource);
    }

    public TGRemover(IProgressMonitor monitor, Resource resource) {
        super(resource);
        this.monitor = monitor;
    }

    @Override
    public void remove(final WriteGraph graph) throws DatabaseException {
    	
    	TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, resource);
    	conf.values = false;
    	ModelTransferableGraphSource source = graph.syncRequest(new ModelTransferableGraphSourceRequest(conf));
    	final SerialisationSupport ss = graph.getService(SerialisationSupport.class);
    	
    	try {
			source.forResourceStatements(graph, new TransferableGraphSourceProcedure<int[]>() {
				
				@Override
				public void execute(int[] value) throws Exception {
					Resource s = ss.getResource(value[0]);
					Resource p = ss.getResource(value[1]);
					Resource i = null;
					if(value[2] != -1) i = ss.getResource(value[2]);
					Resource o = ss.getResource(value[3]);
					
//					System.err.println("s=" + s + " p=" + graph.getPossibleURI(p) + " o=" + o + " p:" + p + " i:" + i);
					
					graph.deny(s,p,i,o);
				}
				
			});
			
			source.forValueResources(graph, new TransferableGraphSourceProcedure<int[]>() {
				
				@Override
				public void execute(int[] value) throws Exception {
					Resource s = ss.getResource(value[0]);
//					System.err.println("s=" + s + " p=" + graph.getPossibleURI(p) + " o=" + o + " " + i);
					graph.denyValue(s);
				}
				
			});
			
			source.closeStreams();
			
		} catch (Exception e) {
			throw new DatabaseException(e);
		}
    	
    }

}
