/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.InstanceFactory;
import org.simantics.db.layer0.request.DefaultInstanceFactoryRequest;
import org.simantics.db.request.WriteResult;

public class DefaultInstanceFactory implements InstanceFactory {

	final Resource resource;
	
	public DefaultInstanceFactory(Resource resource) {
		this.resource = resource;
	}
	
	public WriteResult<Map<String, Object>> create(ReadGraph graph, Map<String, Object> attachment, Resource ... templates) {
		return new DefaultInstanceFactoryRequest(resource, attachment, templates);
	}
	
//    @Override
//    public Resource create(WriteGraph graph) throws DatabaseException {
//        
//        Builtins b = graph.getBuiltins();
//        SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
//
//        InstanceFactory sheetElementFactory = graph.adapt(sr.SpreadsheetElement, InstanceFactory.class);
//        Map<String, Object> sheetElement = graph.syncRequest(sheetElementFactory.create(ArrayMap.keys("").values(""), sr.ForCompositeTemplate));
//
////        InstanceFactory sheetFactory = w.adapt(ssr.Spreadsheet, InstanceFactory.class);
////        w.syncRequest(sheetFactory.create(ArrayMap.keys("composite").values(model), ssr.ForCompositeTemplate));
//        
//        Resource result = OrderedSetUtils.create(graph, sr.Spreadsheet, (Resource)sheetElement.get("resource"));
//
//        graph.claim((Resource)sheetElement.get("resource"), sr.HasSheet, result);
//
//	      Resource rowResource0 = graph.newResource();
//	      graph.claim(rowResource0, b.InstanceOf, null, sr.Row);
//	      Resource rowResource1 = graph.newResource();
//	      graph.claim(rowResource1, b.InstanceOf, null, sr.Row);
//	      Resource columnResource0 = graph.newResource();
//	      graph.claim(columnResource0, b.InstanceOf, null, sr.Column);
//	      Resource columnResource1 = graph.newResource();
//	      graph.claim(columnResource1, b.InstanceOf, null, sr.Column);
//	      Resource columnResource2 = graph.newResource();
//	      graph.claim(columnResource2, b.InstanceOf, null, sr.Column);
//	      Resource columnResource3 = graph.newResource();
//	      graph.claim(columnResource3, b.InstanceOf, null, sr.Column);
//        
//	      graph.claim(result, sr.HasRows, OrderedSetUtils.create(graph, sr.Rows, rowResource0, rowResource1));
//	      graph.claim(result, sr.HasColumns, OrderedSetUtils.create(graph, sr.Columns, columnResource0, columnResource1, columnResource2, columnResource3));
//
////        RowsColumnsIndex rowIndex = graph.syncRequest(new Rows(result));
////        RowsColumnsIndex columnIndex = graph.syncRequest(new Columns(result));
////        Resource rowResource0 = rowIndex.ensureIndex(graph, 0);
////        Resource rowResource1 = rowIndex.ensureIndex(graph, 1);
////        Resource columnResource0 = columnIndex.ensureIndex(graph, 0);
////        Resource columnResource1 = columnIndex.ensureIndex(graph, 1);
////        Resource columnResource2 = columnIndex.ensureIndex(graph, 2);
////        Resource columnResource3 = columnIndex.ensureIndex(graph, 3);
////        
//        {
//	        Resource newCell = graph.newResource();
//	        graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
//	        String label = "Pipe name";
//	        graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
//	        graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource0);
//	        graph.addValue(newCell, sr.HasLabel, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
//	        graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
//        }
//
//        {
//	        Resource newCell = graph.newResource();
//	        graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
//	        String label = "Pipe length";
//	        graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
//	        graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource1);
//	        graph.addValue(newCell, sr.HasLabel, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
//	        graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
//        }
//
//        {
//	        Resource newCell = graph.newResource();
//	        graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
//	        String label = "Flow area";
//	        graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
//	        graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource2);
//	        graph.addValue(newCell, sr.HasLabel, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
//	        graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
//        }
//
//        {
//	        Resource newCell = graph.newResource();
//	        graph.claim(newCell, b.InstanceOf, null, sr.TextCell);
//	        String label = "In simulation";
//	        graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource0);
//	        graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource3);
//	        graph.addValue(newCell, sr.HasLabel, sr.LabelOf, b.String, label, StringJavaBinding.INSTANCE);
//	        graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
//        }
//
//        {
//	        Resource newCell = graph.newResource();
//	        graph.claim(newCell, b.InstanceOf, null, sr.ExpressionCell);
//	        String label = "Attributes(Components('Pipe*'), 'Name', 'Pi12 Length', 'Pi12 Area', 'Included In Simulation')";
//	        graph.claim(newCell, sr.HasRow, sr.RowOf, rowResource1);
//	        graph.claim(newCell, sr.HasColumn, sr.ColumnOf, columnResource0);
//	        graph.addValue(newCell, sr.HasExpression, sr.ExpressionOf, b.String, label, StringJavaBinding.INSTANCE);
//	        graph.claim(result, b.ConsistsOf, b.PartOf, newCell);
//        }
//
//        return result;
//        
//    }

//    @Override
//    public Resource create(WriteGraph graph, Resource container, Resource relation) throws DatabaseException {
//
//        Builtins b = graph.getBuiltins();
//        Resource sheet = create(graph);
//        String name = GraphUtils.findFreshName(graph, "Sheet", container, relation);
//        graph.addValue(sheet, b.HasName, b.NameOf, b.String, name, StringJavaBinding.INSTANCE);
//        graph.claim(container, relation, sheet);
//        return sheet;
//        
//    }
//
//	@Override
//	public Resource create(WriteGraph graph, Map<String, Resource> attachment,
//			Collection<Resource> templates) throws DatabaseException {
//		throw new Error("Not implemented");
//	}


}
