package org.simantics.db.layer0.adapter;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.request.ProjectModels;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class SharedOntologyRemover extends EntityRemover {

    public SharedOntologyRemover(Resource resource) {
        super(resource);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
    	
        Layer0 L0 = Layer0.getInstance(graph);
        
        for(Resource ontology : Layer0Utils.listOntologies(graph)) {
        	if(graph.hasStatement(ontology, L0.IsLinkedTo, resource))
            	throw new CannotRemoveException("The shared library is being referenced by " + graph.getURI(ontology));
        }
        
        for(Resource model : graph.syncRequest(new ProjectModels(SimanticsInternal.getProject()))) {
        	if(graph.hasStatement(model, L0.IsLinkedTo, resource))
            	throw new CannotRemoveException("The shared library is being referenced by " + graph.getURI(model));
        }
        
        super.remove(graph);
        
    }

}
