/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class SuperTypes
extends UnaryQuery<InternalProcedure<IntSet>> {
    private SuperTypes(int resource) {
        super(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final SuperTypes runner(ReadGraphImpl graph, int r, CacheEntry parent, QueryProcessor provider, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        SuperTypes entry = (SuperTypes)provider.superTypesMap.get(r);
        if (entry == null) {
            entry = new SuperTypes(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
            return entry;
        }
        if (!entry.isReady()) {
            SuperTypes superTypes = entry;
            synchronized (superTypes) {
                if (!entry.isReady()) {
                    throw new IllegalStateException();
                }
            }
        }
        provider.performForEach(graph, entry, parent, listener, procedure);
        return entry;
    }

    public static final SuperTypes queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        SuperTypes entry;
        if (parent == null && listener == null && (entry = (SuperTypes)provider.superTypesMap.get(r)) != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return entry;
        }
        return SuperTypes.runner(graph, r, parent, provider, listener, procedure);
    }

    @Override
    public UnaryQuery<InternalProcedure<IntSet>> getEntry(QueryProcessor provider) {
        return provider.superTypesMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.superTypesMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.superTypesMap.remove(this.id);
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final InternalProcedure<IntSet> procedure, boolean store) {
        int inherits = provider.getInherits();
        final CacheEntry parent = graph.parent;
        assert (graph.parent != this);
        final IntSet result = new IntSet(provider.querySupport);
        final TIntProcedure addToResult = new TIntProcedure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean execute(int r) {
                IntSet intSet = result;
                synchronized (intSet) {
                    result.add(r);
                }
                return true;
            }
        };
        DirectObjects.queryEach(graph, this.id, inherits, provider, this, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                SuperTypes.this.addOrSet(graph, result, provider);
                procedure.execute(graph, result);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ReadGraphImpl graph, int i) {
                if (!$assertionsDisabled && graph.parent != parent) {
                    throw new AssertionError();
                }
                IntSet intSet = result;
                synchronized (intSet) {
                    result.add(i);
                }
                this.inc();
                SuperTypes.queryEach(graph, i, provider, SuperTypes.this, null, new InternalProcedure<IntSet>(){

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) {
                        types.forEach(addToResult);
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        procedure.exception(graph, t);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        });
        return result;
    }

    public String toString() {
        return "SuperTypes2[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrSet(ReadGraphImpl graph, IntSet value, QueryProcessor provider) {
        assert (!this.isReady());
        SuperTypes superTypes = this;
        synchronized (superTypes) {
            value.trim();
            this.setResult(value);
            this.setReady();
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<IntSet> procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return null;
        }
        IntSet result = (IntSet)this.getResult();
        procedure.execute(graph, result);
        return result;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }
}

