/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.List;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableWrite;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public class EnumerationVariableModifier
implements Labeler.EnumerationModifier {
    protected final Session session;
    protected final UndoContext undoContext;
    protected final Variable variable;
    protected final List<String> allowedValues;
    protected final String defaultValue;
    private String initialValue;
    protected Throwable modifierFailed;

    public EnumerationVariableModifier(RequestProcessor processor, UndoContext undoContext, Variable variable, List<String> allowedValues, String defaultValue) {
        this.session = processor.getSession();
        this.undoContext = undoContext;
        this.variable = variable;
        this.allowedValues = allowedValues;
        this.defaultValue = defaultValue;
        this.initializeModifier(processor);
    }

    protected void initializeModifier(RequestProcessor processor) {
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    EnumerationVariableModifier.this.initialValue = EnumerationVariableModifier.this.getInitialValue(graph);
                }
            });
        }
        catch (DatabaseException e) {
            this.modifierFailed = e;
        }
    }

    protected void doModify(String label) {
        this.session.asyncRequest((Write)new VariableWrite(this.variable, label, null, null), (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException parameter) {
                if (parameter != null) {
                    ErrorLogger.defaultLogError((Throwable)parameter);
                }
            }
        });
    }

    protected String getInitialValue(ReadGraph graph) throws DatabaseException {
        Object value = this.variable.getValue(graph);
        return value == null ? this.defaultValue : value.toString();
    }

    public String getValue() {
        return this.initialValue;
    }

    public String isValid(String label) {
        if (this.modifierFailed != null) {
            return "Could not resolve validator for this value, modification denied. Reason: " + this.modifierFailed.getMessage();
        }
        return null;
    }

    public final void modify(String label) {
        if (this.modifierFailed != null) {
            throw new Error("modifier failed: " + this.modifierFailed.getMessage());
        }
        this.doModify(label);
    }

    public List<String> getValues() {
        return this.allowedValues;
    }
}

