/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.eclipse.core.runtime.ILog;
import org.simantics.Simantics;
import org.simantics.charts.Charts;
import org.simantics.charts.ITrendSupport;
import org.simantics.charts.editor.ChartData;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.fmi.studio.core.Activator;
import org.simantics.fmi.studio.core.FMIExperiment;
import org.simantics.fmi.studio.core.WorkspaceUtil;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.modeling.subscription.CollectSubscriptions;
import org.simantics.modeling.subscription.ModelHistoryCollector;
import org.simantics.modeling.subscription.SubscriptionCollectionResult;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;

public class TrendSupport
implements ITrendSupport {
    private FMIExperiment experiment;
    private ModelHistoryCollector historyCollector;
    private ChartData chartData;

    public TrendSupport(FMIExperiment experiment) {
        this.experiment = experiment;
    }

    public void initializeHistoryCollection(ReadGraph graph) throws DatabaseException {
        final IProject project = Simantics.peekProject();
        if (project == null) {
            return;
        }
        try {
            File workarea = WorkspaceUtil.getExperimentDirectory(graph, this.experiment.getResource(), true, "result-" + this.experiment.getIdentifier());
            HistoryManager history = History.openFileHistory((File)workarea);
            this.historyCollector = ModelHistoryCollector.createCollector((IDynamicExperiment)this.experiment, (HistoryManager)history, (ILog)Activator.getDefault().getLog(), (Supplier)new Supplier<Read<SubscriptionCollectionResult>>(){

                @Override
                public Read<SubscriptionCollectionResult> get() {
                    CollectSubscriptions cs = new CollectSubscriptions((IDynamicExperiment)TrendSupport.this.experiment, 0.1);
                    return cs;
                }
            }, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TrendSupport.this.chartData != null) {
                        Charts.resetChartEditorData((IProject)project, (Resource)TrendSupport.this.experiment.getModel(), (ChartData)TrendSupport.this.chartData);
                    }
                }
            });
            this.historyCollector.initialize((RequestProcessor)graph, 0.0, true);
            HistoryManager historyManager = History.openFileHistory((File)this.historyCollector.getWorkarea());
            this.chartData = new ChartData(this.experiment.getModel(), this.experiment.getResource(), (IExperiment)this.experiment, this.experiment.getDatasource(), historyManager, this.historyCollector.getCollector());
            Charts.resetChartEditorData((IProject)project, (Resource)this.experiment.getModel(), (ChartData)this.chartData);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (HistoryException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void setChartData(ReadGraph graph) throws DatabaseException {
        this.initializeHistoryCollection(graph);
    }

    public void dispose() {
        if (this.historyCollector != null) {
            this.historyCollector.dispose();
            this.historyCollector = null;
        }
        if (this.chartData != null) {
            IProject project = Simantics.peekProject();
            if (project != null) {
                Charts.resetChartEditorData((IProject)project, (Resource)this.experiment.getModel(), null);
            }
            this.chartData = null;
        }
    }

    public ChartData getChartData() {
        return null;
    }
}

