/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.fmi.studio.core.FMIRealm;
import org.simantics.fmi.studio.core.StructuralNode;

public class FMISessionManager {
    static ConcurrentHashMap<String, FMIRealm> CONNECTIONS = new ConcurrentHashMap();
    static ConcurrentHashMap<String, NodeSupport<StructuralNode>> SUPPORTS = new ConcurrentHashMap();

    public static FMIRealm fmiRealmById(String id) {
        return CONNECTIONS.get(id);
    }

    public static synchronized NodeSupport<StructuralNode> getOrCreateNodeSupport(ReadGraph graph, String id) throws DatabaseException {
        NodeSupport result = SUPPORTS.get(id);
        if (result == null) {
            FMIRealm realm = FMISessionManager.getOrCreateFMIRealm(graph, id);
            result = new NodeSupport(realm.getNodeManager());
            SUPPORTS.put(id, (NodeSupport<StructuralNode>)result);
        }
        return result;
    }

    public static synchronized FMIRealm getOrCreateFMIRealm(ReadGraph graph, String id) throws DatabaseException {
        FMIRealm session = FMISessionManager.fmiRealmById(id);
        if (session == null) {
            return FMISessionManager.createRealm(graph, id);
        }
        return session;
    }

    private static FMIRealm createRealm(ReadGraph graph, String id) throws DatabaseException {
        FMIRealm realm = new FMIRealm(graph, id);
        realm.start();
        CONNECTIONS.put(id, realm);
        return realm;
    }

    public static synchronized void removeRealm(String id) {
        CONNECTIONS.remove(id);
        SUPPORTS.remove(id);
    }
}

