/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.math.BigDecimal;
import java.util.UUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.fmi.studio.core.CachingNodeManager;
import org.simantics.fmi.studio.core.DynamicSimulatorThread;
import org.simantics.fmi.studio.core.FMIExperiment;
import org.simantics.fmi.studio.core.FMINodeManager;
import org.simantics.fmi.studio.core.StructuralNode;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIRealm
extends DynamicSimulatorThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIExperiment.class);
    FMIExperiment experiment;
    private CachingNodeManager<StructuralNode> nodeManager;
    public static final long VARIABLE_UPDATE_INTERVAL = 500000000L;
    volatile long previousVariableUpdateTime = 0L;
    volatile boolean skippedVariableUpdate = true;

    FMIRealm(ReadGraph graph, String id) throws DatabaseException {
        this.experiment = new FMIExperiment(graph, this, id);
        this.nodeManager = new CachingNodeManager(new FMINodeManager(id, this.experiment), this);
        this.setName("FMIRealm " + UUID.randomUUID().toString());
    }

    @Override
    public void onDispose() {
        this.experiment = null;
        this.nodeManager.dispose();
        this.nodeManager = null;
    }

    private void updateSubscriptions() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    FMIRealm.this.nodeManager.updateCachedValues();
                    FMIRealm.this.nodeManager.fireNodeListenersSync();
                    FMIRealm.this.skippedVariableUpdate = false;
                }
                catch (NodeManagerException e) {
                    LOGGER.error("FMIRealm.updateSubscriptions: asyncExec: nodeManager update failed", (Throwable)e);
                }
            }
        });
    }

    public void refreshVariables(boolean force, long updateIntervalNs) throws NodeManagerException {
        assert (this.executorThread == Thread.currentThread());
        long time = System.nanoTime();
        if (force || time - this.previousVariableUpdateTime > updateIntervalNs) {
            this.updateSubscriptions();
            this.previousVariableUpdateTime = time;
        } else {
            this.skippedVariableUpdate = true;
        }
    }

    public NodeManager<StructuralNode> getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public void step() {
        double stepInSeconds = BigDecimal.valueOf(this.simulationStepNs).multiply(BigDecimal.valueOf(1.0E-9)).doubleValue();
        this.experiment.doStep(stepInSeconds);
    }

    @Override
    public void changeState(ExperimentState state) {
        super.changeState(state);
        if (this.skippedVariableUpdate && state != ExperimentState.DISPOSED) {
            this.updateSubscriptions();
        }
    }
}

