/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.util.Collection;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.diagram.Logger;
import org.simantics.fmi.studio.core.FMIExperiment;
import org.simantics.fmil.core.FMILException;
import org.simantics.simulation.data.AbstractDatasource;
import org.simantics.simulation.data.VariableHandle;

public class FMIDatasource
extends AbstractDatasource {
    FMIExperiment experiment;

    public FMIDatasource(FMIExperiment experiment) {
        this.experiment = experiment;
    }

    public Collection<String> getVariables() {
        return this.experiment.getVariables();
    }

    public Datatype getType(String key) {
        return Datatypes.DOUBLE;
    }

    public VariableHandle openHandle(Bean item, String key_, Binding valueBinding) {
        try {
            String key = key_.substring(1, key_.length() - 6).replace('/', '.');
            this.experiment.subscribe(key);
            return new FMIVariableHandle(key, valueBinding);
        }
        catch (FMILException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public Object getTime(NumberBinding binding) {
        try {
            return binding.create((Number)this.experiment.getTime());
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyStep() {
        super.notifyStep();
    }

    public class FMIVariableHandle
    implements VariableHandle {
        String key;
        Binding binding;

        public FMIVariableHandle(String key, Binding binding) {
            this.key = key;
            this.binding = binding;
        }

        public String key() {
            return this.key;
        }

        public Binding binding() {
            return this.binding;
        }

        public Object getValue() throws AccessorException {
            try {
                return FMIDatasource.this.experiment.getVariableValue(this.key);
            }
            catch (FMILException e) {
                throw new AccessorException((Throwable)e);
            }
        }

        public void dispose() {
        }
    }
}

