/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.Realm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class CachingNodeManager<T>
implements NodeManager<T> {
    private Map<T, CacheEntry<T>> cache = new THashMap();
    private NodeManager<T> manager;
    private Realm realm;
    THashMap<T, THashSet<Runnable>> listeners = new THashMap();
    AtomicBoolean fireNodeListenersScheduled = new AtomicBoolean(false);
    Runnable fireNodeListeners = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CachingNodeManager.this.fireNodeListenersScheduled.set(false);
            TObjectProcedure<Runnable> procedure = new TObjectProcedure<Runnable>(){

                public boolean execute(Runnable object) {
                    object.run();
                    return true;
                }
            };
            THashMap tHashMap = CachingNodeManager.this.listeners;
            synchronized (tHashMap) {
                CachingNodeManager.this.listeners.forEachValue((TObjectProcedure)new TObjectProcedure<THashSet<Runnable>>((TObjectProcedure)procedure){
                    private final /* synthetic */ TObjectProcedure val$procedure;
                    {
                        this.val$procedure = tObjectProcedure;
                    }

                    public boolean execute(THashSet<Runnable> object) {
                        object.forEach(this.val$procedure);
                        return true;
                    }
                });
            }
        }
    };

    public CachingNodeManager(NodeManager<T> manager, Realm realm) {
        this.manager = manager;
        this.realm = realm;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public NodeManager<T> getManager() {
        return this.manager;
    }

    private CacheEntry<T> getCacheEntry(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.cache.get(node);
        if (entry != null) {
            return entry;
        }
        if (this.listeners.containsKey(node)) {
            entry = this.createEntry(node);
            this.cache.put(node, entry);
            return entry;
        }
        return null;
    }

    private CacheEntry<T> createEntry(T node) throws NodeManagerException {
        CacheEntry result = new CacheEntry();
        List childNames = this.manager.getChildNames(node);
        result.children = new THashMap(childNames.size());
        for (String childName : this.manager.getChildNames(node)) {
            result.children.put(childName, this.manager.getChild(node, childName));
        }
        List propertyNames = this.manager.getPropertyNames(node);
        result.properties = new THashMap(propertyNames.size());
        for (String propertyName : this.manager.getPropertyNames(node)) {
            result.properties.put(propertyName, this.manager.getProperty(node, propertyName));
        }
        result.classifications = this.manager.getClassifications(node);
        result.name = this.manager.getName(node);
        result.value = this.manager.getValue(node);
        return result;
    }

    public String getName(T node) {
        try {
            CacheEntry<T> entry = this.getCacheEntry(node);
            if (entry != null) {
                return entry.name;
            }
        }
        catch (NodeManagerException e) {
            e.printStackTrace();
        }
        return this.manager.getName(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeListener(T node, Runnable listener) {
        THashMap<T, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get(node);
            if (l == null) {
                l = new THashSet();
                this.listeners.put(node, (Object)l);
            }
            l.add((Object)listener);
        }
        this.realm.asyncExec(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeListener(T node, Runnable listener) {
        THashMap<T, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get(node);
            if (l != null) {
                l.remove((Object)listener);
                if (l.isEmpty()) {
                    this.listeners.remove(node);
                }
            }
        }
    }

    public void fireNodeListeners() {
        if (!this.fireNodeListenersScheduled.getAndSet(true)) {
            this.realm.asyncExec(this.fireNodeListeners);
        }
    }

    public void fireNodeListenersSync() {
        try {
            this.realm.syncExec(this.fireNodeListeners);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void updateCachedValues() throws NodeManagerException {
        for (Map.Entry<T, CacheEntry<T>> entry : this.cache.entrySet()) {
            entry.getValue().value = this.manager.getValue(entry.getKey());
        }
    }

    public T getNode(String path) throws NodeManagerException {
        return (T)this.manager.getNode(path);
    }

    public T getChild(T node, String name) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return entry.children.get(name);
        }
        return (T)this.manager.getChild(node, name);
    }

    public T getProperty(T node, String name) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return entry.properties.get(name);
        }
        return (T)this.manager.getProperty(node, name);
    }

    public List<String> getChildNames(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return new ArrayList<String>(entry.children.keySet());
        }
        return this.manager.getChildNames(node);
    }

    public List<String> getPropertyNames(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return new ArrayList<String>(entry.properties.keySet());
        }
        return this.manager.getPropertyNames(node);
    }

    public List<T> getChildren(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return new ArrayList(entry.children.values());
        }
        return this.manager.getChildren(node);
    }

    public List<T> getProperties(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return new ArrayList(entry.properties.values());
        }
        return this.manager.getProperties(node);
    }

    public Datatype getDatatype(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return entry.value.type();
        }
        return this.manager.getDatatype(node);
    }

    public Object getValue(T node, Binding binding) throws NodeManagerException, BindingException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return entry.value.getValue();
        }
        return this.manager.getValue(node);
    }

    public Variant getValue(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.getCacheEntry(node);
        if (entry != null) {
            return entry.value;
        }
        return this.manager.getValue(node);
    }

    public Object getValue(T node, String property, Binding binding) throws NodeManagerException, BindingException {
        T p = this.getProperty(node, property);
        return this.getValue(p, binding);
    }

    public Variant getValue(T node, String property) throws NodeManagerException {
        T p = this.getProperty(node, property);
        return this.getValue(p);
    }

    public void setValue(T node, Object value, Binding binding) throws NodeManagerException, BindingException {
        this.manager.setValue(node, value, binding);
    }

    public void setValue(T node, String property, Object value, Binding binding) throws NodeManagerException, BindingException {
        T p = this.getProperty(node, property);
        this.manager.setValue(p, value, binding);
    }

    public String getPropertyURI(T parent, T property) {
        return this.manager.getPropertyURI(parent, property);
    }

    public Set<String> getClassifications(T node) throws NodeManagerException {
        CacheEntry<T> entry = this.cache.get(node);
        if (entry != null) {
            return entry.classifications;
        }
        return this.manager.getClassifications(node);
    }

    public void dispose() {
        this.manager = null;
        this.realm = null;
    }

    private static class CacheEntry<T> {
        public String name;
        public Variant value;
        public Map<String, T> children;
        public Map<String, T> properties;
        public Set<String> classifications;

        private CacheEntry() {
        }
    }
}

