/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.query;

import java.awt.BasicStroke;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.g2d.element.handler.EdgeVisuals;

public class ConnectionVisualsRequest
extends ResourceRead<ConnectionVisuals> {
    G2DResource g2d;

    public ConnectionVisualsRequest(Resource connectionType) {
        super(connectionType);
        assert (connectionType != null);
    }

    public ConnectionVisuals perform(ReadGraph g) throws DatabaseException {
        float[] col;
        this.g2d = G2DResource.getInstance((ReadGraph)g);
        Resource structuralConnectionType = this.resource;
        Resource c = g.getPossibleObject(structuralConnectionType, this.g2d.HasColor);
        float[] color = null;
        if (c != null && (col = (float[])g.getPossibleValue(c, (Binding)Bindings.FLOAT_ARRAY)) != null && col.length >= 3) {
            color = col;
        }
        EdgeVisuals.StrokeType strokeType = this.toStrokeType(g.getPossibleObject(structuralConnectionType, this.g2d.HasStrokeType));
        BasicStroke stroke = G2DUtils.getStroke(g, g.getPossibleObject(structuralConnectionType, this.g2d.HasStroke));
        return new ConnectionVisuals(color, strokeType, stroke);
    }

    EdgeVisuals.StrokeType toStrokeType(Resource strokeType) {
        if (strokeType != null) {
            if (strokeType.equals(this.g2d.StrokeType_Scaling)) {
                return EdgeVisuals.StrokeType.Absolute;
            }
            if (strokeType.equals(this.g2d.StrokeType_Nonscaling)) {
                return EdgeVisuals.StrokeType.Relative;
            }
        }
        return null;
    }
}

