/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.export;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.utils.QualityHints;
import org.simantics.utils.page.MarginUtils;

public class ImageBuilder {
    File file;
    Double dpi;
    Point size;
    double margin;

    public ImageBuilder(File file, Double dpi, Point size, double margin) {
        this.file = file;
        this.dpi = dpi;
        this.size = size;
        this.margin = Math.max(margin, 0.0);
    }

    public BufferedImage paint(ICanvasContext canvasContext) throws Exception {
        Graphics g2 = null;
        BufferedImage image = null;
        try {
            Rectangle2D.Double controlArea;
            IDiagram diagram = (IDiagram)canvasContext.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
            Rectangle2D diagramRect = DiagramUtils.getContentRect((IDiagram)diagram);
            if (diagramRect == null) {
                diagramRect = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
            }
            double off = Math.max(diagramRect.getWidth(), diagramRect.getHeight()) * this.margin * 0.5;
            diagramRect = new Rectangle2D.Double(diagramRect.getX() - off, diagramRect.getY() - off, diagramRect.getWidth() + off * 2.0, diagramRect.getHeight() + off * 2.0);
            AffineTransform tr = new AffineTransform();
            if (this.dpi != null) {
                double mmToInch = 0.04;
                controlArea = new Rectangle2D.Double(0.0, 0.0, diagramRect.getWidth() * mmToInch * this.dpi, diagramRect.getHeight() * mmToInch * this.dpi);
            } else {
                controlArea = new Rectangle2D.Double(0.0, 0.0, this.size.getX(), this.size.getY());
            }
            ((TransformUtil)canvasContext.getSingleItem(TransformUtil.class)).fitArea((Rectangle2D)controlArea, diagramRect, MarginUtils.NO_MARGINS);
            int width = (int)((RectangularShape)controlArea).getWidth();
            int height = (int)((RectangularShape)controlArea).getHeight();
            long sizeBytes = width * height * 3;
            long free = Runtime.getRuntime().freeMemory();
            if (sizeBytes >= free) {
                System.gc();
                free = Runtime.getRuntime().freeMemory();
            }
            if (sizeBytes >= free) {
                throw new Exception("There is not enough available memory to create the image; required " + sizeBytes + ", available " + free);
            }
            image = new BufferedImage(width, height, 5);
            g2 = (Graphics2D)image.getGraphics();
            QualityHints.HIGH_QUALITY_HINTS.setQuality((Graphics2D)g2);
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            ((Graphics2D)g2).setTransform(tr);
            g2.setClip(new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)controlArea).getWidth(), ((RectangularShape)controlArea).getHeight()));
            ((Graphics2D)g2).setRenderingHint(G2DRenderingHints.KEY_CONTROL_BOUNDS, new Rectangle2D.Double(0.0, 0.0, ((RectangularShape)controlArea).getWidth(), ((RectangularShape)controlArea).getHeight()));
            if (canvasContext.isLocked()) {
                throw new IllegalStateException("cannot render image, canvas context is locked: " + canvasContext);
            }
            canvasContext.getSceneGraph().render((Graphics2D)g2);
            if (this.file != null) {
                String name = this.file.getName();
                name = name.substring(name.lastIndexOf(".") + 1);
                ImageIO.write((RenderedImage)image, name, this.file);
            }
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        return image;
    }
}

