/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.provider;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.internal.core.ECFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseContainerInstantiator
implements IContainerInstantiator {
    protected static String[] NO_ADAPTERS_ARRAY = new String[]{IContainer.class.getName()};
    protected static String[] EMPTY_STRING_ARRAY = new String[0];
    protected static Class[][] EMPTY_CLASS_ARRAY = new Class[][]{new Class[0]};

    protected Integer getIntegerFromArg(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Integer) {
            return (Integer)arg;
        }
        if (arg instanceof String) {
            return new Integer((String)arg);
        }
        throw new IllegalArgumentException("arg=" + arg + " is not of integer type");
    }

    protected String getStringFromArg(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof String) {
            return (String)arg;
        }
        throw new IllegalArgumentException("arg=" + arg + " is not of String type");
    }

    protected Set getAdaptersForClass(Class clazz) {
        HashSet<String> result = new HashSet<String>();
        IAdapterManager adapterManager = ECFPlugin.getDefault().getAdapterManager();
        if (adapterManager != null) {
            result.addAll(Arrays.asList(adapterManager.computeAdapterTypes(clazz)));
        }
        return result;
    }

    protected Set getInterfacesForClass(Set s, Class clazz) {
        if (clazz.equals(Object.class)) {
            return s;
        }
        s.addAll(this.getInterfacesForClass(s, clazz.getSuperclass()));
        s.addAll(Arrays.asList(clazz.getInterfaces()));
        return s;
    }

    protected Set getInterfacesForClass(Class clazz) {
        Set clazzes = this.getInterfacesForClass(new HashSet(), clazz);
        HashSet<String> result = new HashSet<String>();
        Iterator i = clazzes.iterator();
        while (i.hasNext()) {
            result.add(((Class)i.next()).getName());
        }
        return result;
    }

    protected String[] getInterfacesAndAdaptersForClass(Class clazz) {
        Set result = this.getAdaptersForClass(clazz);
        result.addAll(this.getInterfacesForClass(clazz));
        return result.toArray(new String[0]);
    }

    protected Map<String, ?> getMap(Object[] parameters) {
        if (parameters != null && parameters.length > 0) {
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object p = objectArray[n2];
                if (p instanceof Map) {
                    return (Map)p;
                }
                ++n2;
            }
        }
        return null;
    }

    protected <T> T getParameterValue(Map<String, ?> parameters, String key, Class<T> clazz, T def) {
        Object o;
        if (parameters != null && clazz.isInstance(o = parameters.get(key))) {
            return (T)o;
        }
        return def;
    }

    protected String getParameterValue(Map<String, ?> parameters, String key, String def) {
        return this.getParameterValue(parameters, key, String.class, def);
    }

    protected String getParameterValue(Map<String, ?> parameters, String key) {
        return this.getParameterValue(parameters, key, null);
    }

    protected <T> T getParameterValue(Object[] parameters, String key, Class<T> clazz, T def) {
        return this.getParameterValue(this.getMap(parameters), key, clazz, def);
    }

    protected <T> T getParameterValue(Object[] parameters, String key, Class<T> clazz) {
        return this.getParameterValue(parameters, key, clazz, null);
    }

    protected String getMapParameterString(Object[] parameters, String key, String def) {
        return this.getParameterValue(parameters, key, String.class, def);
    }

    protected String getMapParameterString(Object[] parameters, String key) {
        return this.getParameterValue(parameters, key, String.class, null);
    }

    @Override
    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        throw new ContainerCreateException("createInstance not supported");
    }

    @Override
    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        return NO_ADAPTERS_ARRAY;
    }

    @Override
    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        return EMPTY_CLASS_ARRAY;
    }

    @Override
    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return null;
    }
}

