/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.request.DocumentRequest;

public class NodesRequest2
extends VariableRead<Set<Variable>> {
    public NodesRequest2(Variable var) {
        super(var);
    }

    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        Resource type = this.variable.getPossibleType(graph);
        if (type == null) {
            return Collections.emptySet();
        }
        if (!graph.isInheritedFrom(type, DOC.Components_Component)) {
            return Collections.emptySet();
        }
        Boolean pathExists = (Boolean)this.variable.getPossiblePropertyValue(graph, DOC.Properties_pathExists, (Binding)Bindings.BOOLEAN);
        if (pathExists != null && !pathExists.booleanValue()) {
            return Collections.emptySet();
        }
        if (graph.isInheritedFrom(type, DOC.Components_PrimitiveComponent)) {
            return Collections.singleton(this.variable);
        }
        THashSet result = new THashSet();
        for (Variable child : this.variable.getChildren(graph)) {
            Set nodes = (Set)graph.syncRequest((Read)new NodesRequest2(child));
            result.addAll(nodes);
        }
        if (DocumentRequest.PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("NodesRequest2 " + System.identityHashCode((Object)this) + " " + this.variable.getURI(graph) + " in " + 1.0E-6 * (double)dura + "ms.");
        }
        return result;
    }
}

