/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.NodeRequest;
import org.simantics.document.server.request.NodesRequest;

public class DocumentRequest
extends VariableRead<List<JSONObject>> {
    public static boolean PROFILE = false;

    public DocumentRequest(Variable var) {
        super(var);
    }

    public List<JSONObject> perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        Set nodes = (Set)graph.syncRequest((Read)new NodesRequest(this.variable), (AsyncProcedure)TransientCacheAsyncListener.instance());
        HashSet<JSONObject> rs = new HashSet<JSONObject>();
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        for (Variable node : nodes) {
            rs.add((JSONObject)((Object)graph.syncRequest((Read)new NodeRequest(node), (AsyncProcedure)TransientCacheAsyncListener.instance())));
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(rs);
        Collections.sort(result, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o1.id.compareTo(o2.id);
            }
        });
        if (PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("DocumentRequest " + System.identityHashCode((Object)this) + " " + this.variable.getURI(graph) + " in " + 1.0E-6 * (double)dura + "ms.");
        }
        return result;
    }
}

