/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.Functions;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;

public class DocumentServerUtils {
    public static Collection<Variable> getChildren(ReadGraph graph, Variable variable) throws DatabaseException {
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable property : variable.getProperties(graph)) {
            Connection conn;
            Collection classifications = (Collection)property.getPossiblePropertyValue(graph, "classifications");
            if (classifications == null) continue;
            if (classifications.contains("http://www.simantics.org/Documentation-1.2/Document/ChildRelation")) {
                conn = (Connection)property.getValue(graph);
                Variable childConnectionPoint = DocumentServerUtils.getPossibleOtherConnectionPoint(graph, property, conn);
                if (childConnectionPoint == null) continue;
                result.add(childConnectionPoint.getParent(graph));
                continue;
            }
            if (!DOC.Relations_partN.equals(property.getPossiblePredicateResource(graph))) continue;
            conn = (Connection)property.getValue(graph);
            for (Variable childConnectionPoint : DocumentServerUtils.getOtherConnectionPoints(graph, property, conn)) {
                result.add(childConnectionPoint.getParent(graph));
            }
        }
        return result;
    }

    public static String findManualOrdinal(ReadGraph graph, Variable v) throws DatabaseException {
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        Integer j = null;
        while (j == null && v != null) {
            j = (Integer)v.getPossiblePropertyValue(graph, DOC.Components_Component_manualOrdinal);
            v = v.getParent(graph);
        }
        if (j != null) {
            return Integer.toString(j);
        }
        return null;
    }

    public static Collection<Variable> getChildrenInOrdinalOrder(ReadGraph graph, Variable variable) throws DatabaseException {
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        TreeMap<String, Variable> childMap = new TreeMap<String, Variable>((Comparator<String>)AlphanumComparator.COMPARATOR);
        for (Variable property : variable.getProperties(graph)) {
            Collection classifications = (Collection)property.getPossiblePropertyValue(graph, "classifications");
            if (classifications == null) continue;
            if (classifications.contains("http://www.simantics.org/Documentation-1.2/Document/ChildRelation")) {
                Resource cp = property.getPossiblePredicateResource(graph);
                String i = (String)graph.getRelatedValue(cp, DOC.Document_ChildRelation_ordinal, (Binding)Bindings.STRING);
                Connection conn = (Connection)property.getValue(graph);
                Variable childConnectionPoint = DocumentServerUtils.getPossibleOtherConnectionPoint(graph, property, conn);
                if (childConnectionPoint == null) continue;
                childMap.put(i, childConnectionPoint.getParent(graph));
                continue;
            }
            if (!DOC.Relations_partN.equals(property.getPossiblePredicateResource(graph))) continue;
            Connection conn = (Connection)property.getValue(graph);
            for (Variable childConnectionPoint : DocumentServerUtils.getOtherConnectionPoints(graph, property, conn)) {
                Variable child = childConnectionPoint.getParent(graph);
                String i = DocumentServerUtils.findManualOrdinal(graph, child);
                if (i == null) {
                    i = "0";
                }
                childMap.put(i, child);
            }
        }
        return childMap.values();
    }

    public static Collection<Variable> collectNodes(ReadGraph graph, Variable variable, Collection<Variable> nodes) throws DatabaseException {
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        Resource type = variable.getPossibleType(graph);
        if (type == null) {
            return nodes;
        }
        if (!graph.isInheritedFrom(type, DOC.Components_Component)) {
            return nodes;
        }
        Boolean enabled = (Boolean)variable.getPossiblePropertyValue(graph, DOC.Properties_exists, (Binding)Bindings.BOOLEAN);
        if (enabled != null && !enabled.booleanValue()) {
            return nodes;
        }
        if (graph.isInheritedFrom(type, DOC.Components_PrimitiveComponent)) {
            nodes.add(variable);
        } else {
            for (Variable child : variable.getChildren(graph)) {
                DocumentServerUtils.collectNodes(graph, child, nodes);
            }
        }
        return nodes;
    }

    public static Variable getPossibleOtherConnectionPoint(ReadGraph graph, Variable connectionPoint, Connection conn) throws DatabaseException {
        Collection descs = conn.getConnectionPointDescriptors(graph, null);
        if (descs.size() != 2) {
            return null;
        }
        for (VariableConnectionPointDescriptor desc : descs) {
            if (desc.isFlattenedFrom(graph, connectionPoint)) continue;
            return desc.getVariable(graph);
        }
        return null;
    }

    public static Collection<Variable> getOtherConnectionPoints(ReadGraph graph, Variable connectionPoint, Connection conn) throws DatabaseException {
        ArrayList<Variable> connectionPoints = new ArrayList<Variable>();
        Collection descs = conn.getConnectionPointDescriptors(graph, null);
        for (VariableConnectionPointDescriptor desc : descs) {
            if (desc.isFlattenedFrom(graph, connectionPoint)) continue;
            connectionPoints.add(desc.getVariable(graph));
        }
        return connectionPoints;
    }

    public static Variable getPossibleCommandTriggerConnectionPoint(ReadGraph graph, Variable connectionPoint, Connection conn) throws DatabaseException {
        Collection cpts = conn.getConnectionPoints(graph, null);
        Variable result = null;
        for (Variable cpt : cpts) {
            Set classifications = cpt.getClassifications(graph);
            if (!classifications.contains("http://www.simantics.org/Documentation-1.2/Relations/commandExecutorRelation")) continue;
            if (result != null) {
                throw new DatabaseException("Multiple executor connection points in command connection");
            }
            result = cpt;
        }
        return result;
    }

    public static Collection<Variable> getPossibleOtherConnectionPoints(ReadGraph graph, Variable connectionPoint, Connection conn) throws DatabaseException {
        Collection cpts = conn.getConnectionPoints(graph, null);
        if (cpts.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable cpt : cpts) {
            if (cpt.equals(connectionPoint)) continue;
            result.add(cpt);
        }
        return result;
    }

    public static String getId(ReadGraph graph, Variable node) throws DatabaseException {
        if (node == null) {
            return "root";
        }
        String uri = node.getURI(graph);
        int l = uri.lastIndexOf("<<<");
        return uri.substring(l + 4);
    }

    public static Object getValue(ReadGraph graph, Variable attrib) throws DatabaseException {
        return graph.syncRequest((Read)new DocumentValue(attrib));
    }

    public static Variable getParentConnectionPoint(ReadGraph graph, Variable component) throws DatabaseException {
        Connection conn;
        Variable otherCp;
        Variable connectionPoint = component.getPossibleProperty(graph, "parent");
        if (connectionPoint == null) {
            DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
            Collection cps = component.getProperties(graph, DOC.Relations_parentRelation);
            if (cps.size() == 1) {
                connectionPoint = (Variable)cps.iterator().next();
            } else {
                return null;
            }
        }
        if ((otherCp = DocumentServerUtils.getPossibleOtherConnectionPoint(graph, connectionPoint, conn = (Connection)connectionPoint.getValue(graph))) != null) {
            return otherCp;
        }
        Variable parentCp = (Variable)graph.sync((ReadInterface)new UnaryRead<Connection, Variable>(conn){

            public Variable perform(ReadGraph graph) throws DatabaseException {
                DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
                Collection descs = ((Connection)this.parameter).getConnectionPointDescriptors(graph, null);
                for (VariableConnectionPointDescriptor desc : descs) {
                    if (!DOC.Relations_partN.equals(desc.getConnectionPointResource(graph))) continue;
                    return desc.getVariable(graph);
                }
                return null;
            }
        });
        if (parentCp != null) {
            return parentCp;
        }
        return null;
    }

    public static Collection<Variable> getChildConnections(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_ChildRelation);
    }

    public static Collection<Variable> getTriggerCommands(ReadGraph graph, Variable variable) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        for (Variable var : variable.getProperties(graph, DOC.Document_CommandRelation)) {
            if (DOC.Relations_broadcasted.equals(var.getPredicateResource(graph))) continue;
            result.add(var);
        }
        return result;
    }

    public static Collection<Variable> getCommands(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_CommandRelation);
    }

    public static Collection<Variable> getDataDefinitions(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_DataDefinitionRelation);
    }

    public static Collection<Variable> getDataRelations(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_DataRelation);
    }

    public static Collection<Variable> getAttributes(ReadGraph graph, DocumentationResource DOC, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DOC.Document_AttributeRelation);
    }

    public static Collection<Variable> getStaticAttributes(ReadGraph graph, DocumentationResource DOC, Variable variable) throws DatabaseException {
        Pair attribs = (Pair)graph.syncRequest((Read)new AttributesRequest(variable));
        return (Collection)attribs.first;
    }

    public static Collection<Variable> getDynamicAttributes(ReadGraph graph, DocumentationResource DOC, Variable variable) throws DatabaseException {
        Pair attribs = (Pair)graph.syncRequest((Read)new AttributesRequest(variable));
        return (Collection)attribs.second;
    }

    public static Variable getPossibleDocumentRootVariable(ReadGraph graph, Variable documentPart) throws DatabaseException {
        if (documentPart instanceof Functions.RootVariable) {
            return documentPart;
        }
        Variable parent = documentPart.getParent(graph);
        if (parent == null) {
            return null;
        }
        return DocumentServerUtils.getPossibleDocumentRootVariable(graph, parent);
    }

    static class AttributesRequest
    extends VariableRead<Pair<Collection<Variable>, Collection<Variable>>> {
        public AttributesRequest(Variable variable) {
            super(variable);
        }

        public Pair<Collection<Variable>, Collection<Variable>> perform(ReadGraph graph) throws DatabaseException {
            ArrayList<Variable> statics = new ArrayList<Variable>();
            ArrayList<Variable> dynamics = new ArrayList<Variable>();
            DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
            for (Variable property : DocumentServerUtils.getAttributes(graph, DOC, this.variable)) {
                Boolean defaultProperty = (Boolean)property.getPossiblePropertyValue(graph, "default");
                if (defaultProperty != null && defaultProperty.booleanValue()) continue;
                Boolean dynamicProperty = (Boolean)property.getPossiblePropertyValue(graph, DOC.Document_AttributeRelation_dynamic);
                if (dynamicProperty != null && dynamicProperty.booleanValue()) {
                    dynamics.add(property);
                    continue;
                }
                statics.add(property);
            }
            return new Pair(statics, dynamics);
        }
    }

    public static class DocumentValue
    extends VariableRead<Object> {
        public DocumentValue(Variable variable) {
            super(variable);
        }

        public Object perform(ReadGraph graph) throws DatabaseException {
            return this.variable.getValue(graph);
        }

        public String toString() {
            return "DocumentValue[" + this.variable + "]";
        }
    }
}

