/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.experiment;

import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.experiment.IExperimentStatusListener;
import org.simantics.utils.datastructures.ListenerList;

public abstract class Experiment
implements IExperiment {
    protected Resource experiment;
    protected Resource model;
    protected ListenerList<IExperimentListener> listeners = new ListenerList(IExperimentListener.class);
    protected ListenerList<IExperimentStatusListener> statusListeners = new ListenerList(IExperimentStatusListener.class);
    protected volatile ExperimentState state = ExperimentState.INITIALIZING;
    protected String identifier;
    private ExperimentStateRead EXPERIMENT_STATE_READ = new ExperimentStateRead(this);

    public Experiment(Resource model) {
        this(null, model, UUID.randomUUID().toString());
    }

    public Experiment(Resource model, String identifier) {
        this(null, model, identifier);
    }

    public Experiment(Resource experiment, Resource model) {
        this(experiment, model, UUID.randomUUID().toString());
    }

    public Experiment(Resource experiment, Resource model, String identifier) {
        this.experiment = experiment;
        this.model = model;
        this.identifier = identifier;
    }

    @Override
    public <T> T getService(Class<T> clazz) {
        return null;
    }

    @Override
    public ExperimentState getState() {
        if (this.state == null) {
            System.err.println("nullstate");
        }
        return this.state;
    }

    @Override
    public ExperimentState getState(ReadGraph graph) throws DatabaseException {
        return (ExperimentState)((Object)graph.syncRequest((ExternalRead)this.EXPERIMENT_STATE_READ));
    }

    @Override
    public void changeState(ExperimentState newState) {
        if (this.state == ExperimentState.DISPOSED) {
            return;
        }
        if (newState != this.state) {
            this.state = newState;
            this.localStateChange();
            IExperimentListener[] iExperimentListenerArray = (IExperimentListener[])this.listeners.getListeners();
            int n = iExperimentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExperimentListener listener = iExperimentListenerArray[n2];
                listener.stateChanged(newState);
                ++n2;
            }
        }
    }

    protected void localStateChange() {
    }

    @Override
    public void addListener(IExperimentListener listener) {
        this.listeners.add((Object)listener);
        listener.stateChanged(this.state);
    }

    @Override
    public Resource getResource() {
        return this.experiment;
    }

    @Override
    public Resource getModel() {
        return this.model;
    }

    @Override
    public void removeListener(IExperimentListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void addStatusListener(IExperimentStatusListener listener) {
        this.statusListeners.add((Object)listener);
    }

    @Override
    public void removeStatusListener(IExperimentStatusListener listener) {
        this.statusListeners.remove((Object)listener);
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
        this.changeState(ExperimentState.DISPOSED);
    }

    @Override
    public Lock getDatasourceLock() {
        throw new UnsupportedOperationException("deprecated operation");
    }

    @Override
    public Accessor getAccessor() {
        return null;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    static class ExperimentStateRead
    implements ExternalRead<ExperimentState>,
    Runnable {
        private final Experiment experiment;
        private Listener<ExperimentState> listener = null;

        ExperimentStateRead(Experiment experiment) {
            this.experiment = experiment;
        }

        public void register(ReadGraph graph, Listener<ExperimentState> procedure) {
            this.listener = procedure;
            procedure.execute((Object)this.experiment.state);
        }

        public void unregistered() {
            this.listener = null;
        }

        @Override
        public void run() {
            Listener<ExperimentState> l = this.listener;
            if (l != null) {
                l.execute((Object)this.experiment.state);
            }
        }
    }
}

