/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.writer;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.writer.AbstractDelayedGraphWriter;
import org.simantics.layer0.utils.writer.GraphWriter;

public class DelayedGraphWriter
extends AbstractDelayedGraphWriter {
    protected File file;
    protected ObjectOutputStream s;
    TIntIntHashMap clusterHints = new TIntIntHashMap();
    TIntLongHashMap clusterIds = new TIntLongHashMap();

    public DelayedGraphWriter(ReadGraph graph) {
        super(graph);
        try {
            this.file = File.createTempFile("graph", ".tmp");
            System.out.println("Temp file: " + this.file.getAbsolutePath());
            this.s = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.file), 0x100000));
            this.file.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException("Opening output stream to temporary file failed", e);
        }
    }

    private void writeRef(int ref) throws IOException {
        if (ref > 0) {
            this.timestamps.set(ref - 1, this.time++);
        }
        this.s.writeInt(ref);
    }

    @Override
    public GraphWriter let(Resource p, Resource o) throws DatabaseException {
        assert (p != null);
        assert (o != null);
        try {
            this.s.writeByte(0);
            this.writeRef(this.current);
            this.writeRef(this.getPredicateId(p));
            this.writeRef(this.getId(o));
        }
        catch (IOException e) {
            throw new RuntimeException("Writing statement failed.", e);
        }
        return this;
    }

    @Override
    public GraphWriter let(Resource p, Object value, Resource dataType) throws DatabaseException {
        assert (p != null);
        assert (value != null);
        assert (dataType != null);
        try {
            ++this.internalCount;
            this.timestamps.add(0);
            this.s.writeByte(1);
            this.writeRef(this.internalCount);
            this.s.writeUnshared(value);
            this.writeRef(this.getId(dataType));
            this.s.writeByte(0);
            this.writeRef(this.current);
            this.writeRef(this.getPredicateId(p));
            this.writeRef(this.internalCount);
        }
        catch (IOException e) {
            throw new RuntimeException("Writing statement failed.", e);
        }
        return this;
    }

    @Override
    public GraphWriter let(int clusterHint, Resource p, Object value, Resource dataType) throws DatabaseException {
        this.let(p, value, dataType);
        this.clusterHints.put(this.internalCount, clusterHint);
        return this;
    }

    @Override
    public GraphWriter createLiteral(Object value, Resource dataType) {
        assert (value != null);
        assert (dataType != null);
        try {
            ++this.internalCount;
            this.timestamps.add(0);
            this.s.writeByte(1);
            this.writeRef(this.internalCount);
            this.s.writeUnshared(value);
            this.writeRef(this.getId(dataType));
            this.current = this.internalCount;
        }
        catch (IOException e) {
            throw new RuntimeException("Writing statement failed.", e);
        }
        return this;
    }

    @Override
    public GraphWriter createLiteral(int clusterHint, Object value, Resource dataType) {
        this.createLiteral(value, dataType);
        this.clusterHints.put(this.current, clusterHint);
        return this;
    }

    @Override
    public GraphWriter createInverse(int cluster, Resource r) {
        assert (r != null);
        this.create(cluster);
        try {
            this.s.writeByte(5);
            this.writeRef(this.current);
            this.writeRef(this.getId(r));
        }
        catch (IOException e) {
            throw new RuntimeException("Writing statement failed.", e);
        }
        return this;
    }

    @Override
    public GraphWriter createInverse(Resource r) {
        assert (r != null);
        this.create();
        try {
            this.s.writeByte(5);
            this.writeRef(this.current);
            this.writeRef(this.getId(r));
        }
        catch (IOException e) {
            throw new RuntimeException("Writing statement failed.", e);
        }
        return this;
    }

    protected Resource getResource(WriteOnlyGraph wg, Resource[] internals, long[] resourceIds, int id) {
        if (id > 0) {
            Resource ret = internals[id - 1];
            if (ret == null) {
                throw new Error("Error");
            }
            if (this.timestamps.getQuick(id - 1) == this.time) {
                internals[id - 1] = null;
            }
            ++this.time;
            return ret;
        }
        if (id < 0) {
            return (Resource)this.externals.get(-1 - id);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit(IProgressMonitor monitor, WriteOnlyGraph wg) throws DatabaseException {
        try {
            try {
                if (this.s != null) {
                    this.s.close();
                    this.s = null;
                }
                this.externalsInv = null;
                monitor.beginTask("", 100);
                int lastPercentageDone = 0;
                long fileLength = this.file.length();
                Resource[] internals = new Resource[this.internalCount];
                this.resourceIds = new long[this.internalCount];
                FileInputStream fis = new FileInputStream(this.file);
                FileChannel fc = fis.getChannel();
                ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(fis, 0x100000));
                int resourceCounter = 0;
                int statementCounter = 0;
                int valueCounter = 0;
                this.time = 0;
                block15: while (true) {
                    switch (is.read()) {
                        case -1: {
                            break block15;
                        }
                        case 0: {
                            int s = is.readInt();
                            int p = is.readInt();
                            int o = is.readInt();
                            Resource rs = this.getResource(wg, internals, this.resourceIds, s);
                            Resource rp = this.getResource(wg, internals, this.resourceIds, p);
                            Resource ro = this.getResource(wg, internals, this.resourceIds, o);
                            Resource rpInv = (Resource)this.inverses.get(p);
                            wg.claim(rs, rp, rpInv, ro);
                            statementCounter += 2;
                            break;
                        }
                        case 1: {
                            int id = is.readInt();
                            Object value = is.readUnshared();
                            int type = is.readInt();
                            Resource r = this.newResource(wg, internals, id);
                            wg.claim(r, this.l0.InstanceOf, null, this.getResource(wg, internals, this.resourceIds, type));
                            wg.claimValue(r, value);
                            ++statementCounter;
                            ++resourceCounter;
                            ++valueCounter;
                            break;
                        }
                        case 2: {
                            wg.flushCluster();
                            break;
                        }
                        case 3: {
                            int s = is.readInt();
                            int t = is.readInt();
                            Resource type = this.getResource(wg, internals, this.resourceIds, t);
                            wg.claim(this.newResource(wg, internals, s), this.l0.InstanceOf, null, type);
                            ++statementCounter;
                            ++resourceCounter;
                            break;
                        }
                        case 4: {
                            int s = is.readInt();
                            this.newResource(wg, internals, s);
                            ++resourceCounter;
                            break;
                        }
                        case 5: {
                            int r1 = is.readInt();
                            int r2 = is.readInt();
                            Resource rr1 = this.getResource(wg, internals, this.resourceIds, r1);
                            Resource rr2 = this.getResource(wg, internals, this.resourceIds, r2);
                            wg.claim(rr1, this.l0.InverseOf, this.l0.InverseOf, rr2);
                            statementCounter += 2;
                            this.inverses.put(r1, (Object)rr2);
                            this.inverses.put(r2, (Object)rr1);
                        }
                    }
                    double percentageDone = 100.0 * (double)fc.position() / (double)fileLength;
                    int newPercentageDone = (int)Math.round(percentageDone);
                    if (newPercentageDone <= lastPercentageDone) continue;
                    monitor.setTaskName("Writing database (" + newPercentageDone + "%)");
                    monitor.worked(newPercentageDone - lastPercentageDone);
                    lastPercentageDone = newPercentageDone;
                }
                System.out.println("clusterIds.size() = " + this.clusterIds.size());
                System.out.println("Wrote " + resourceCounter + " resources, " + statementCounter + " statements and " + valueCounter + " values.");
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Commiting delayed graph writings failed.", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Commiting delayed graph writings failed.", e);
            }
        }
        finally {
            this.file.delete();
            monitor.done();
        }
    }

    private Resource newResource(WriteOnlyGraph wg, Resource[] internals, int s) throws DatabaseException {
        Resource r;
        int clusterHint = this.clusterHints.get(s);
        if (clusterHint == 0) {
            r = wg.newResource();
        } else {
            long clusterId = this.clusterIds.get(clusterHint);
            if (clusterId == 0L) {
                wg.flushCluster();
                r = wg.newResource();
                this.clusterIds.put(clusterHint, this.clustering.getCluster(r));
            } else {
                r = wg.newResource(clusterId);
            }
        }
        internals[s - 1] = r;
        this.resourceIds[s - 1] = r.getResourceId();
        return r;
    }

    @Override
    public GraphWriter create() {
        this.current = ++this.internalCount;
        this.timestamps.add(0);
        try {
            this.s.writeByte(4);
            this.s.writeInt(this.current);
        }
        catch (IOException e) {
            throw new RuntimeException("Writing statement failed.", e);
        }
        return this;
    }

    @Override
    public GraphWriter create(int clusterHint) {
        this.create();
        this.clusterHints.put(this.current, clusterHint);
        return this;
    }

    @Override
    public GraphWriter create(Resource type) {
        assert (type != null);
        this.current = ++this.internalCount;
        this.timestamps.add(0);
        try {
            this.s.writeByte(3);
            this.s.writeInt(this.current);
            this.s.writeInt(this.getId(type));
        }
        catch (IOException e) {
            throw new RuntimeException("Writing statement failed.", e);
        }
        return this;
    }

    @Override
    public GraphWriter create(int clusterHint, Resource type) {
        this.create(type);
        this.clusterHints.put(this.current, clusterHint);
        return this;
    }

    @Override
    public Resource get() {
        if (this.current > 0) {
            return new AbstractDelayedGraphWriter.InternalResource(this.current);
        }
        if (this.current < 0) {
            return (Resource)this.externals.get(-1 - this.current);
        }
        return null;
    }

    @Override
    public GraphWriter handle(Resource s) {
        assert (s != null);
        this.current = this.getId(s);
        return this;
    }

    @Override
    public GraphWriter flush() {
        try {
            this.s.writeByte(2);
        }
        catch (IOException e) {
            throw new RuntimeException("Writing flush failed.", e);
        }
        return this;
    }
}

