/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.layer0.request.PossibleActiveVariableFromVariable;
import org.simantics.db.layer0.request.PossibleVariableIndexRoot;
import org.simantics.db.layer0.request.PossibleVariableModel;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.ResourceURIToVariable;
import org.simantics.db.layer0.request.VariableIndexRoot;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.NodeStructureRequest;
import org.simantics.db.layer0.variable.NodeValueRequest;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.SCLValueAccessor;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.VariableNodeReadRunnable;
import org.simantics.db.layer0.variable.VariableRepository;
import org.simantics.db.layer0.variable.VariablesImpl;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.Function3;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.utils.datastructures.Pair;

public final class Variables {
    public static final Variant PENDING_NODE_VALUE = new Variant();
    public static final NodeStructure PENDING_NODE_STRUCTURE = new NodeStructure(Collections.emptyMap(), Collections.emptyMap()){

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    };
    @Deprecated
    public static final String NAME = "HasName";
    public static final String CLASSIFICATIONS = "classifications";
    public static final String EXPRESSION = "HasExpression";
    public static final String INPUT_VALIDATOR = "HasInputValidator";
    public static final String INPUT_MODIFIER = "HasInputModifier";
    public static final String FORMATTER = "HasFormatter";
    public static final String STANDARD_RESOURCE = "hasStandardResource";
    public static final String TYPE = "Type";
    public static final String URI = "URI";
    public static final String VALID = "valid";
    public static final String REQUIRED = "required";
    public static final String DEFAULT = "default";
    public static final String READONLY = "readOnly";
    public static final String VALIDATOR = "validator";
    public static final String LABEL = "HasLabel";
    public static final String ENUMERATION_VALUES = "HasEnumerationValues";
    public static final String CUSTOM_MODIFIER = "HasCustomModifier";
    public static final String DISPLAY_COLUMN = "HasDisplayColumn";
    public static final String DISPLAY_PROPERTY = "HasDisplayProperty";
    public static final String DISPLAY_VALUE = "HasDisplayValue";
    public static final String DISPLAY_UNIT = "HasDisplayUnit";
    public static final String CONVERTED_VALUE = "convertedValue";
    public static final String ARRAY_SIZE = "ARRAY_SIZE";
    @Deprecated
    public static final String RESOURCE = "Resource";
    @Deprecated
    public static final String CONTAINER_RESOURCE = "ContainerResource";
    @Deprecated
    public static final String PROPERTY_RESOURCE = "PROPERTY_RESOURCE";
    @Deprecated
    public static final String[] builtins = new String[]{"Type", "Resource", "URI"};

    public static Variable getPossibleVariable(ReadGraph graph, Resource resource) throws DatabaseException {
        String uri = graph.getPossibleURI(resource);
        return uri != null ? Variables.getPossibleVariable(graph, uri) : null;
    }

    public static Variable getPossibleVariable(ReadGraph graph, String uri) throws DatabaseException {
        try {
            return Variables.getVariable(graph, uri);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public static Variable getVariable(ReadGraph graph, Resource resource) throws DatabaseException {
        return Variables.getVariable(graph, graph.getURI(resource));
    }

    public static Variable getVariable(ReadGraph graph, String uri) throws DatabaseException {
        try {
            return (Variable)graph.sync((ReadInterface)new ResourceURIToVariable(uri));
        }
        catch (MissingVariableException missingVariableException) {
            return VariableRepository.get(graph, uri);
        }
    }

    private static int commonPrefixLength(String a, String b) {
        int maxC = Math.min(a.length(), b.length());
        int c = 0;
        while (c < maxC) {
            if (a.charAt(c) != b.charAt(c)) {
                return c;
            }
            ++c;
        }
        return maxC;
    }

    private static boolean isSplitPos(String str, int p) {
        if (p == str.length()) {
            return true;
        }
        char c = str.charAt(p);
        return c == '/' || c == '#';
    }

    private static int pathLength(String path) {
        int count = 0;
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c == '/' || c == '#') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static String prefixByParentPath(int parentPathLength, String suffix) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < parentPathLength) {
            b.append('.');
            ++i;
        }
        b.append(suffix);
        return b.toString();
    }

    public static String getRVI(ReadGraph graph, Variable base, Variable other) throws DatabaseException {
        String baseURI = (String)graph.syncRequest((Read)new VariableURI(base));
        String otherURI = (String)graph.syncRequest((Read)new VariableURI(other));
        return Variables.getRelativeRVI(baseURI, otherURI);
    }

    public static String getRelativeRVI(String baseURI, String otherURI) {
        int prefixLength = Variables.commonPrefixLength(baseURI, otherURI);
        if (!Variables.isSplitPos(baseURI, prefixLength) || !Variables.isSplitPos(otherURI, prefixLength)) {
            --prefixLength;
            while (prefixLength > 0 && !Variables.isSplitPos(baseURI, prefixLength)) {
                --prefixLength;
            }
        }
        if (prefixLength == baseURI.length()) {
            return otherURI.substring(prefixLength);
        }
        return Variables.prefixByParentPath(Variables.pathLength(baseURI.substring(prefixLength)), otherURI.substring(prefixLength));
    }

    public static String getRVI2(ReadGraph graph, Variable base, Variable other) throws DatabaseException {
        TObjectIntHashMap baseLength = new TObjectIntHashMap();
        int depth = 0;
        while (base != null) {
            baseLength.put((Object)base, depth);
            base = base.getParent(graph);
            ++depth;
        }
        Variable cur = other;
        while (!baseLength.containsKey((Object)cur)) {
            cur = cur.getParent(graph);
        }
        String curURI = cur.getURI(graph);
        String otherURI = other.getURI(graph);
        return Variables.prefixByParentPath(baseLength.get((Object)cur), otherURI.substring(curURI.length()));
    }

    public static String getProjectRVI(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource project = Variables.getProject(graph, variable);
        String projectURI = graph.getURI(project);
        return variable.getURI(graph).substring(projectURI.length());
    }

    private static int getSegmentEnd(String suffix) {
        int pos = 1;
        while (pos < suffix.length()) {
            char c = suffix.charAt(pos);
            if (c == '/' || c == '#') break;
            ++pos;
        }
        return pos;
    }

    public static String getRVI(String rvi, String suffix) throws DatabaseException {
        if (suffix.isEmpty()) {
            return rvi;
        }
        switch (suffix.charAt(0)) {
            case '.': {
                return Variables.getRVI(URIStringUtils.getRVIParent((String)rvi), suffix.substring(1));
            }
            case '#': {
                int segmentEnd = Variables.getSegmentEnd(suffix);
                return Variables.getRVI(String.valueOf(rvi) + "#" + suffix.substring(1, segmentEnd), suffix.substring(segmentEnd));
            }
            case '/': {
                int segmentEnd = Variables.getSegmentEnd(suffix);
                return Variables.getRVI(String.valueOf(rvi) + "/" + suffix.substring(1, segmentEnd), suffix.substring(segmentEnd));
            }
        }
        return null;
    }

    public static Variable getRootVariable(ReadGraph graph) throws DatabaseException {
        return (Variable)graph.adapt(graph.getRootLibrary(), Variable.class);
    }

    public static Resource getPossibleIndexRoot(ReadGraph graph, Variable variable) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleVariableIndexRoot(variable));
    }

    public static Resource getIndexRoot(ReadGraph graph, Variable variable) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new VariableIndexRoot(variable));
    }

    public static Resource getModel(ReadGraph graph, Variable variable) throws DatabaseException {
        String URI2 = variable.getURI(graph);
        return VariablesImpl.getFirst(graph, SimulationResource.getInstance((ReadGraph)graph).Model, URI2, 8);
    }

    public static Resource getPossibleModel(ReadGraph graph, Variable variable) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleVariableModel(variable));
    }

    public static Resource getProject(ReadGraph graph, Variable variable) throws DatabaseException {
        String URI2 = variable.getURI(graph);
        return VariablesImpl.getFirst(graph, ProjectResource.getInstance((ReadGraph)graph).Project, URI2, 8);
    }

    public static Variable getConfigurationContext(ReadGraph graph, Resource resource) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(resource, SIMU.Model)) {
            resource = (Resource)graph.sync((ReadInterface)new Model(resource));
        }
        Resource configurationResource = graph.getSingleObject(resource, SIMU.HasConfiguration);
        return Variables.getVariable(graph, configurationResource);
    }

    public static Resource getConfigurationContextResource(ReadGraph graph, Resource resource) throws DatabaseException {
        Variable config = Variables.getConfigurationContext(graph, resource);
        return config.getRepresents(graph);
    }

    public static Variable getConfigurationContext(ReadGraph graph, Variable variable) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getModel(graph, variable);
        Resource configurationResource = graph.getSingleObject(model, SIMU.HasConfiguration);
        return Variables.getVariable(graph, configurationResource);
    }

    public static Resource getPossibleConfigurationContextResource(ReadGraph graph, Resource resource) throws DatabaseException {
        Variable config = Variables.getPossibleConfigurationContext(graph, resource);
        return config != null ? config.getPossibleRepresents(graph) : null;
    }

    public static Variable getPossibleConfigurationContext(ReadGraph graph, Resource resource) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(resource, SIMU.Model)) {
            resource = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(resource));
        }
        if (resource == null) {
            return null;
        }
        Resource configurationResource = graph.getPossibleObject(resource, SIMU.HasConfiguration);
        if (configurationResource == null) {
            return null;
        }
        return Variables.getPossibleVariable(graph, configurationResource);
    }

    public static Variable getPossibleConfigurationContext(ReadGraph graph, Variable variable) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getPossibleIndexRoot(graph, variable);
        if (model == null) {
            return null;
        }
        Resource configurationResource = graph.getPossibleObject(model, SIMU.HasConfiguration);
        if (configurationResource == null) {
            return null;
        }
        return Variables.getPossibleVariable(graph, configurationResource);
    }

    public static Variable getConfigurationVariable(ReadGraph graph, Resource resource, String RVI2) throws DatabaseException {
        Variable context = Variables.getConfigurationContext(graph, resource);
        return context.browse(graph, RVI2);
    }

    public static Variable getConfigurationVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable context = Variables.getConfigurationContext(graph, variable);
        RVI rvi = variable.getRVI(graph);
        return rvi.resolve(graph, context);
    }

    public static Variable getPossibleConfigurationVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable context = Variables.getPossibleConfigurationContext(graph, variable);
        if (context == null) {
            return null;
        }
        try {
            RVI rvi = variable.getRVI(graph);
            return rvi.resolvePossible(graph, context);
        }
        catch (MissingVariableException missingVariableException) {
            return null;
        }
    }

    public static Datatype getDatatype(ReadGraph graph, Resource resource, RVI rvi) throws DatabaseException {
        Variable var = rvi.resolve(graph, Variables.getConfigurationContext(graph, resource));
        return var.getDatatype(graph);
    }

    @Deprecated
    public static Resource getRealization(ReadGraph graph, Variable variable) throws DatabaseException {
        String URI2 = variable.getURI(graph);
        return VariablesImpl.getFirst(graph, Layer0X.getInstance((ReadGraph)graph).Realization, URI2, 8);
    }

    public static boolean isContext(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource type = variable.getPossibleType(graph);
        return type != null && graph.isInheritedFrom(type, Layer0.getInstance((ReadGraph)graph).RVIContext);
    }

    public static Variable getPossibleContext(ReadGraph graph, Variable variable) throws DatabaseException {
        if (Variables.isContext(graph, variable)) {
            return variable;
        }
        Variable parent = variable.getParent(graph);
        if (parent == null) {
            return null;
        }
        return Variables.getPossibleContext(graph, parent);
    }

    public static Variable getContext(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable context = Variables.getPossibleContext(graph, variable);
        if (context == null) {
            throw new DatabaseException("No context found for " + variable.getURI(graph));
        }
        return context;
    }

    public static RVI getRVI2(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getRVI(graph);
    }

    public static RVI getPossibleRVI2(ReadGraph graph, Variable variable) throws DatabaseException {
        try {
            return variable.getRVI(graph);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public static String getRVI(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource realizationResource = Variables.getRealization(graph, variable);
        if (realizationResource == null) {
            throw new DatabaseException("No realization found for " + variable.getURI(graph));
        }
        return variable.getURI(graph).substring(graph.getURI(realizationResource).length());
    }

    public static String getRVI(ReadGraph graph, Resource config) throws DatabaseException {
        Variable var = Variables.getVariable(graph, config);
        return Variables.getRVI(graph, var);
    }

    public static String getPossibleRVI(ReadGraph graph, Resource config) throws DatabaseException {
        Variable var = Variables.getPossibleVariable(graph, config);
        return var != null ? Variables.getPossibleRVI(graph, var) : null;
    }

    public static String getPossibleRVI(ReadGraph graph, Variable variable) throws DatabaseException {
        try {
            return Variables.getRVI(graph, variable);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public static List<Variable> getPath(ReadGraph graph, Variable base, Variable var) throws DatabaseException {
        if (!Variables.isChild(graph, base, var)) {
            return null;
        }
        LinkedList<Variable> result = new LinkedList<Variable>();
        var = var.getParent(graph);
        while (!var.equals(base)) {
            result.addFirst(var);
            var = var.getParent(graph);
        }
        return result;
    }

    public static Variable getChild(ReadGraph graph, Variable base, Variable var) throws DatabaseException {
        List<Variable> path = Variables.getPath(graph, base, var);
        if (path == null || path.size() == 0) {
            return null;
        }
        return path.get(0);
    }

    public static boolean isChild(ReadGraph graph, Variable base, Variable var) throws DatabaseException {
        if (base.equals(var)) {
            return false;
        }
        return var.getURI(graph).startsWith(base.getURI(graph));
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Resource realization) throws DatabaseException {
        Resource current = Variables.getRealization(graph, variable);
        if (current == null) {
            throw new DatabaseException("No current realization found for variable");
        }
        return Variables.switchRealization(graph, variable, current, realization);
    }

    public static Variable switchPossibleContext(ReadGraph graph, Variable variable, Resource realization) throws DatabaseException {
        Variable current = Variables.getPossibleContext(graph, variable);
        if (current == null) {
            return null;
        }
        Resource currentContext = current.getPossibleRepresents(graph);
        if (currentContext == null) {
            return null;
        }
        return Variables.switchPossibleRealization(graph, variable, currentContext, realization);
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Variable realization) throws DatabaseException {
        Resource current = Variables.getRealization(graph, variable);
        return Variables.switchRealization(graph, variable, current, realization);
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Resource currentRealization, Resource targetRealization) throws DatabaseException {
        String currentURI = graph.getURI(currentRealization);
        String targetURI = graph.getURI(targetRealization);
        String variableURI = variable.getURI(graph);
        String targetVariableURI = String.valueOf(targetURI) + variableURI.substring(currentURI.length());
        return Variables.getVariable(graph, targetVariableURI);
    }

    public static Variable switchRealization(ReadGraph graph, Variable variable, Resource currentRealization, Variable targetRealization) throws DatabaseException {
        String currentURI = graph.getURI(currentRealization);
        String targetURI = targetRealization.getURI(graph);
        String variableURI = variable.getURI(graph);
        String targetVariableURI = String.valueOf(targetURI) + variableURI.substring(currentURI.length());
        return Variables.getVariable(graph, targetVariableURI);
    }

    public static Variable switchPossibleRealization(ReadGraph graph, Variable variable, Resource currentRealization, Resource targetRealization) throws DatabaseException {
        String currentURI = graph.getURI(currentRealization);
        String targetURI = graph.getURI(targetRealization);
        String variableURI = variable.getURI(graph);
        String targetVariableURI = String.valueOf(targetURI) + variableURI.substring(currentURI.length());
        return Variables.getPossibleVariable(graph, targetVariableURI);
    }

    public static Variable toConfigurationVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable config = Variables.getConfigurationContext(graph, variable);
        return Variables.switchRealization(graph, variable, config);
    }

    public static Variable toPossibleConfigurationVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource represents = variable.getPossibleRepresents(graph);
        if (represents == null) {
            return null;
        }
        Resource config = Variables.getPossibleConfigurationContextResource(graph, represents);
        if (config == null) {
            return null;
        }
        return Variables.switchPossibleContext(graph, variable, config);
    }

    public static String toRVI(ReadGraph graph, List<Resource> compositePath) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StringBuilder rvi = new StringBuilder();
        for (Resource composite : compositePath) {
            String name = (String)graph.getPossibleRelatedValue(composite, L0.HasName);
            if (name == null) {
                return null;
            }
            rvi.append('/');
            String escapedName = URIStringUtils.escape((String)name);
            rvi.append(escapedName);
        }
        return rvi.toString();
    }

    public static String appendRVI(ReadGraph graph, String modelURI, String rvi, Resource configuration) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String partName = (String)graph.getPossibleRelatedValue(configuration, L0.HasName);
        if (partName == null) {
            throw new MissingVariableException("Can not append a child corresponding to " + configuration + " to rvi '" + rvi + "' since there is no name.");
        }
        String escaped = URIStringUtils.escape((String)partName);
        return String.valueOf(rvi) + "/" + escaped;
    }

    public static boolean isValid(ReadGraph graph, Variable variable) {
        if (variable == null) {
            return false;
        }
        try {
            variable.getURI(graph);
        }
        catch (DatabaseException databaseException) {
            return false;
        }
        return true;
    }

    public static Variable possibleChildWithType(ReadGraph graph, Variable variable, Resource targetType) throws DatabaseException {
        Variable found = null;
        for (Variable child : variable.getChildren(graph)) {
            Resource type = (Resource)child.getPossiblePropertyValue(graph, TYPE);
            if (type == null || !graph.isInheritedFrom(type, targetType)) continue;
            if (found != null) {
                return null;
            }
            found = child;
        }
        return found;
    }

    public static Collection<Variable> childrenWithType(ReadGraph graph, Variable variable, Resource targetType) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable child : variable.getChildren(graph)) {
            Resource type = (Resource)child.getPossiblePropertyValue(graph, TYPE);
            if (!graph.isInheritedFrom(type, targetType)) continue;
            result.add(child);
        }
        return result;
    }

    public static <T> T adapt(ReadGraph graph, Variable variable, String property, Class<T> clazz) throws DatabaseException {
        Resource resource = (Resource)variable.getPropertyValue(graph, property);
        return (T)graph.adapt(resource, clazz);
    }

    public static <T> T getPossiblePropertyValue(RequestProcessor processor, Variable variable, Resource property, Binding binding) {
        try {
            return (T)processor.sync((ReadInterface)new TernaryRead<Variable, Resource, Binding, T>(variable, property, binding){

                public T perform(ReadGraph graph) throws DatabaseException {
                    return ((Variable)this.parameter).getPossiblePropertyValue(graph, (Resource)this.parameter2, (Binding)this.parameter3);
                }
            });
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public static Variable possibleActiveVariable(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable activeVariable = (Variable)graph.sync((ReadInterface)new PossibleActiveVariableFromVariable(variable));
        return activeVariable;
    }

    public static Variant requestNodeValue(ReadGraph graph, VariableNode<?> node) throws DatabaseException {
        return Variables.requestNodeValue(graph, node, null);
    }

    public static Variant requestNodeValue(ReadGraph graph, VariableNode<?> node, Binding binding) throws DatabaseException {
        Variant value = (Variant)graph.syncRequest((ExternalRead)new NodeValueRequest(node, binding));
        if (PENDING_NODE_VALUE == value && graph.getSynchronous()) {
            ValueGetter getter = new ValueGetter(node, binding);
            try {
                node.support.manager.getRealm().syncExec((Runnable)getter);
            }
            catch (InterruptedException e) {
                Logger.defaultLogError((Throwable)e);
            }
            if (getter.exception != null) {
                throw new DatabaseException((Throwable)getter.exception);
            }
            return getter.result;
        }
        return value;
    }

    public static NodeStructure requestNodeStructure(ReadGraph graph, VariableNode<?> node) throws DatabaseException {
        NodeStructure value = (NodeStructure)graph.syncRequest((ExternalRead)new NodeStructureRequest(node));
        if (value == null) {
            throw new DatabaseException("External data access error");
        }
        if (PENDING_NODE_STRUCTURE == value && graph.getSynchronous()) {
            StructureGetter getter = new StructureGetter(node);
            try {
                node.support.manager.getRealm().syncExec((Runnable)getter);
            }
            catch (InterruptedException e) {
                Logger.defaultLogError((Throwable)e);
                throw new DatabaseException("External data access error", (Throwable)e);
            }
            if (getter.exception != null) {
                throw new DatabaseException("External data access error", (Throwable)getter.exception);
            }
            if (getter.result == null) {
                throw new DatabaseException("External data access error");
            }
            return getter.result;
        }
        return value;
    }

    public static String getPossibleUnit(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype dt;
        block7: {
            Binding binding;
            block6: {
                try {
                    Variant variant;
                    Resource predicate = variable.getPossiblePredicateResource(graph);
                    if (predicate != null) {
                        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
                        if (info.definedUnit != null) {
                            return info.definedUnit;
                        }
                    }
                    if ((binding = (variant = variable.getVariantValue(graph)).getBinding()) != null) break block6;
                    return null;
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
            }
            dt = binding.type();
            if (dt instanceof NumberType) break block7;
            return null;
        }
        NumberType nt = (NumberType)dt;
        return nt.getUnit();
    }

    public static Pair<Variable, Variable> resolvePossible(ReadGraph graph, RVI rvi, Variable context1, Variable context2) throws DatabaseException {
        Variable v = rvi.resolvePossible(graph, context1);
        if (v != null) {
            return new Pair((Object)v, (Object)context1);
        }
        if (context2 != null && (v = rvi.resolvePossible(graph, context2)) != null) {
            return new Pair((Object)v, (Object)context2);
        }
        return null;
    }

    public static Variable tryGetProperty(ReadGraph graph, Resource entity, Resource property) throws DatabaseException {
        Variable v = Variables.getPossibleVariable(graph, entity);
        return v != null ? v.getPossibleProperty(graph, property) : null;
    }

    public static ValueAccessor createValueAccessor(Function1<Variable, Object> getValue1, Function2<Variable, Binding, Object> getValue2, Function2<Variable, Object, Object> setValue2, Function3<Variable, Object, Binding, Object> setValue3, Function1<Variable, Datatype> getDatatype) {
        return new SCLValueAccessor(getValue1, getValue2, setValue2, setValue3, getDatatype);
    }

    public static class NodeStructure {
        public final Map<String, Object> children;
        public final Map<String, Object> properties;
        private final int hash;

        public NodeStructure(Map<String, Object> children, Map<String, Object> properties) {
            this.children = children;
            this.properties = properties;
            this.hash = this.calcHash();
        }

        private int calcHash() {
            return 31 * this.children.hashCode() + 41 * this.properties.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object == PENDING_NODE_STRUCTURE) {
                return false;
            }
            if (!(object instanceof NodeStructure)) {
                return false;
            }
            NodeStructure r = (NodeStructure)object;
            return r.children.equals(this.children) && r.properties.equals(this.properties);
        }
    }

    public static enum Role {
        CHILD("/"),
        PROPERTY("#");

        final transient String identifier;

        private Role(String identifier) {
            this.identifier = identifier;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public static Role getRole(String identifier) {
            Role[] roleArray = Role.values();
            int n = roleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Role role = roleArray[n2];
                if (role.identifier.equals(identifier)) {
                    return role;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class StructureGetter
    implements VariableNodeReadRunnable {
        final VariableNode n;
        NodeStructure result;
        Exception exception;

        public StructureGetter(VariableNode n) {
            this.n = n;
        }

        @Override
        public void run() {
            try {
                this.result = NodeStructureRequest.get(this.n);
            }
            catch (NodeManagerException e) {
                Logger.defaultLogError((Throwable)e);
                this.exception = e;
            }
        }
    }

    private static class ValueGetter
    implements VariableNodeReadRunnable {
        final VariableNode n;
        final Binding binding;
        Variant result;
        Exception exception;

        public ValueGetter(VariableNode n, Binding binding) {
            this.n = n;
            this.binding = binding;
        }

        @Override
        public void run() {
            try {
                this.result = this.binding != null ? new Variant(this.binding, this.n.support.manager.getValue(this.n.node, this.binding)) : this.n.support.manager.getValue(this.n.node);
            }
            catch (Exception e) {
                Logger.defaultLogError((Throwable)e);
                this.exception = e;
            }
        }
    }
}

