/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityInstances;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.ConsistsOfProcess;
import org.simantics.db.layer0.util.DomainProcessor3;
import org.simantics.db.layer0.util.GUIDExclusionFunction;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function1;

public class TGRepresentationUtils {
    public static boolean findByIdentifier(ReadGraph graph, Resource targetIndex, Resource source) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        GUID guid = (GUID)graph.getPossibleRelatedValue(source, L0.identifier, GUID.BINDING);
        if (guid != null) {
            List exist = (List)graph.syncRequest((Read)new EntityInstances.QueryIndex(targetIndex, L0.Entity, "GUID:" + guid.indexString()));
            return !exist.isEmpty();
        }
        return false;
    }

    public static Function1<Statement, DomainProcessor3.ExclusionDecision> computeExclusionFunction(ReadGraph graph, Resource[] resources, Map<String, Object> hints) throws DatabaseException {
        Resource targetRoot;
        Resource targetResource = (Resource)hints.get(ClipboardUtils.HINT_TARGET_RESOURCE);
        if (targetResource != null && (targetRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(targetResource))) != null) {
            Resource[] resourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r = resourceArray[n2];
                Resource sourceRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
                if (!r.equals(sourceRoot)) {
                    if (targetRoot.equals(sourceRoot)) {
                        return new GUIDExclusionFunction(graph);
                    }
                    if (TGRepresentationUtils.findByIdentifier(graph, targetRoot, r)) {
                        return new GUIDExclusionFunction(graph);
                    }
                    for (Resource part : ConsistsOfProcess.walk(graph, Collections.singleton(r), Collections.emptySet(), true)) {
                        if (!TGRepresentationUtils.findByIdentifier(graph, targetRoot, part)) continue;
                        return new GUIDExclusionFunction(graph);
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

