/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.Arrays;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TGRepresentationUtils;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TGRepresentation
implements SimanticsClipboard.Representation {
    protected boolean ignoreVirtualResources = false;
    protected Resource[] resources;
    private TransferableGraph1 value = null;
    private TransferableGraphConfiguration2 configuration;

    public TGRepresentation(Resource ... resources) {
        this.resources = resources;
    }

    public TGRepresentation(boolean ignoreVirtualResources, Resource ... resources) {
        this.ignoreVirtualResources = ignoreVirtualResources;
        this.resources = resources;
    }

    public TGRepresentation(TransferableGraphConfiguration2 configuration) {
        this.configuration = configuration;
    }

    public TGRepresentation(TransferableGraph1 value) {
        this.value = value;
    }

    @Override
    public IHintContext.Key getKey() {
        return SimanticsKeys.KEY_TRANSFERABLE_GRAPH;
    }

    public TransferableGraph1 compute(ReadGraph graph, Map<String, Object> hints) throws DatabaseException {
        if (this.configuration == null) {
            this.configuration = new TransferableGraphConfiguration2(graph, Arrays.asList(this.resources), this.ignoreVirtualResources, false);
            this.configuration.exclusionFunction = TGRepresentationUtils.computeExclusionFunction(graph, this.resources, hints);
        }
        ModelTransferableGraphSource source = (ModelTransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(this.configuration));
        return TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)source);
    }

    @Override
    public <T> T getValue(RequestProcessor processor, final Map<String, Object> hints) throws DatabaseException {
        if (this.value == null) {
            this.value = (TransferableGraph1)processor.syncRequest((Read)new UniqueRead<TransferableGraph1>(){

                public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
                    return TGRepresentation.this.compute(graph, hints);
                }
            });
        }
        return (T)this.value;
    }
}

