/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.AsyncReadRequest;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphAdvisor;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.ConsistsOfProcess;
import org.simantics.db.layer0.util.DomainStatementProcedure;
import org.simantics.db.layer0.util.DomainStatementProcedure2;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.StatementSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class Subgraphs {
    public static String LOG_FILE = "export.log";
    private static final boolean LOG = false;
    private static final boolean DEBUG = false;
    private static final boolean PARENT_DEBUG = false;
    private static final boolean EXTERNAL_DEBUG = false;
    private static final boolean ADVISOR_LOG = false;
    private static final boolean EXPANSION_LOG = false;
    private static final boolean INTERNAL_LOG = false;
    private static final boolean COMPOSED_LOG = false;
    private static final boolean RESOLVE_LOG = false;
    private static final boolean CLASSIFY_LOG = false;
    private static final boolean EXTERNAL_LOG = false;
    private static final boolean PROFILE = false;
    static DataOutput log;
    static int kess;

    static {
        kess = 0;
    }

    private static void log(String line) {
    }

    public static Collection<Resource> getParents(ReadGraph g, Resource r) throws DatabaseException {
        return Subgraphs.getParents(g, r, false);
    }

    private static Collection<Resource> getParents(ReadGraph g, Resource r, boolean isStrong) throws DatabaseException {
        System.out.println("getParents " + NameUtils.getSafeName((ReadGraph)g, (Resource)r));
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        Collection predicates = g.getPredicates(r);
        if (predicates.contains(l0.PartOf)) {
            Collection parents = g.getObjects(r, l0.PartOf);
            if (parents.size() == 1) {
                return parents;
            }
            ArrayList<Resource> libraryParents = new ArrayList<Resource>(1);
            for (Resource p : parents) {
                if (!g.isInstanceOf(p, l0.Library)) continue;
                libraryParents.add(p);
            }
            if (!libraryParents.isEmpty()) {
                return libraryParents;
            }
            return parents;
        }
        ArrayList<Resource> parents = null;
        for (Resource p : predicates) {
            if (!g.isInstanceOf(p, l0.OrderedSet) || p.equals(r)) continue;
            if (parents == null) {
                parents = new ArrayList<Resource>(1);
            }
            parents.add(p);
        }
        if (parents != null) {
            return parents;
        }
        if (isStrong) {
            return Collections.emptyList();
        }
        if (predicates.contains(l0.InverseOf)) {
            Resource inv = g.getInverse(r);
            return Subgraphs.getParents(g, inv, true);
        }
        HashSet<Resource> result = new HashSet<Resource>();
        for (Resource predicate : predicates) {
            if (!g.isSubrelationOf(predicate, l0.IsDependencyOf)) continue;
            result.addAll(g.getObjects(r, predicate));
        }
        if (!result.isEmpty()) {
            return result;
        }
        for (Resource predicate : predicates) {
            Resource inv = g.getPossibleInverse(predicate);
            if (inv == null || !g.isSubrelationOf(inv, l0.IsRelatedTo)) continue;
            result.addAll(g.getObjects(r, predicate));
        }
        return result;
    }

    public static void getDomain2(ReadGraph graph, TIntIntHashMap ids, Collection<Resource> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, Map<Resource, Statement> specials, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput, TreeMap<String, Variant> extensions, TIntHashSet excludedShared) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin("getDomain2");
        final DomainProcessor2 processor = new DomainProcessor2();
        processor.startupTime = System.nanoTime();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        processor.ids = ids;
        processor.specials = specials;
        processor.status = (Map)cs.createMap(SubgraphExtent.ExtentStatus.class);
        processor.weakInverses = (Map)cs.createMap(WeakStatus.class);
        processor.predicates = cs.createSet();
        processor.isRelatedToPredicates = cs.createSet();
        processor.sharedPredicates = cs.createSet();
        for (Map.Entry<Resource, SubgraphExtent.ExtentStatus> entry : preStatus.entrySet()) {
            processor.status.put(entry.getKey(), entry.getValue());
            if (!SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)entry.getValue())) continue;
            processor.exclusions.add(entry.getKey());
        }
        Resource rootLibrary = graph.getResource("http:/");
        if (!roots.contains(rootLibrary)) {
            processor.status.put(rootLibrary, SubgraphExtent.ExtentStatus.EXTERNAL);
        }
        for (Resource root : roots) {
            processor.status.put(root, SubgraphExtent.ExtentStatus.INTERNAL);
            for (Resource resource : graph.getObjects(root, l0.IsOwnedBy)) {
                processor.status.put(resource, SubgraphExtent.ExtentStatus.EXTERNAL);
            }
        }
        processor.startupTime = System.nanoTime() - processor.startupTime;
        processor.fringe = new HashSet<Resource>();
        processor.fringe.addAll(roots);
        processor.internalDomain.addAll(roots);
        processor.sharedExternalReferences = new HashSet<Resource>();
        processor.sharedExternalFringe = new HashSet<Resource>();
        try {
            processor.process(graph, otherStatementsOutput, valueOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Resource r : processor.sharedExternalReferences) {
            excludedShared.add(support.getTransientId(r));
        }
        ClusteringSupport cls = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        TLongObjectHashMap clusterMap = new TLongObjectHashMap();
        for (Map.Entry entry : processor.status.entrySet()) {
            if (SubgraphExtent.ExtentStatus.INTERNAL != entry.getValue()) continue;
            long cluster = cls.getCluster((Resource)entry.getKey());
            TIntArrayList list = (TIntArrayList)clusterMap.get(cluster);
            if (list == null) {
                list = new TIntArrayList();
                clusterMap.put(cluster, (Object)list);
            }
            list.add(support.getTransientId((Resource)entry.getKey()));
        }
        final TIntArrayList tIntArrayList = new TIntArrayList();
        clusterMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TIntArrayList>(){

            public boolean execute(long cluster, TIntArrayList b) {
                tIntArrayList.add(b.size());
                b.forEach(new TIntProcedure(){

                    public boolean execute(int rId) {
                        processor.ids.put(rId, processor.id++);
                        return true;
                    }
                });
                return true;
            }
        });
        extensions.put("clustering", new Variant((Binding)Bindings.INT_ARRAY, (Object)tIntArrayList.toArray()));
        long total = processor.startupTime + processor.expandTime + processor.composedPredicateTime + processor.composedObjectTime + processor.extentSeedTime + processor.fullResolveTime + processor.fastResolveTime + processor.parentResolveTime + processor.otherStatementTime;
        task.finish();
    }

    public static void getDomain(ReadGraph graph, Map<Resource, Integer> ids, Collection<Resource> roots, Map<Resource, SubgraphExtent.ExtentStatus> preStatus, Set<SubgraphAdvisor> advisors, ObjectOutputStream composedStatementsOutput, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin("getDomain");
        DomainProcessor processor = new DomainProcessor(advisors);
        processor.startupTime = System.nanoTime();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        processor.ids = ids;
        processor.status = (Map)cs.createMap(SubgraphExtent.ExtentStatus.class);
        processor.weakInverses = (Map)cs.createMap(WeakStatus.class);
        processor.predicates = cs.createSet();
        processor.composedPredicates = cs.createSet();
        processor.expansionSeeds = cs.createSet();
        for (Map.Entry<Resource, SubgraphExtent.ExtentStatus> entry : preStatus.entrySet()) {
            processor.status.put(entry.getKey(), entry.getValue());
        }
        if (!roots.contains(graph.getRootLibrary())) {
            processor.status.put(graph.getRootLibrary(), SubgraphExtent.ExtentStatus.EXTERNAL);
        }
        for (Resource root : roots) {
            processor.status.put(root, SubgraphExtent.ExtentStatus.INTERNAL);
            processor.ids.put(root, processor.id++);
            for (Resource owner : graph.getObjects(root, l0.IsOwnedBy)) {
                processor.status.put(owner, SubgraphExtent.ExtentStatus.EXTERNAL);
            }
        }
        processor.expansionSeeds.addAll(roots);
        processor.startupTime = System.nanoTime() - processor.startupTime;
        while (!processor.expansionSeeds.isEmpty()) {
            processor.process(graph, composedStatementsOutput, otherStatementsOutput, valueOutput);
        }
        long total = processor.startupTime + processor.expandTime + processor.composedPredicateTime + processor.composedObjectTime + processor.extentSeedTime + processor.fullResolveTime + processor.fastResolveTime + processor.parentResolveTime + processor.otherStatementTime;
        task.finish();
    }

    static class ClassifyStatementsRequest
    implements AsyncRead<Boolean> {
        final Set<Resource> schedule;
        final Map<Resource, WeakStatus> weakMap;

        public ClassifyStatementsRequest(Set<Resource> schedule, Map<Resource, WeakStatus> weakMap) {
            this.weakMap = weakMap;
            this.schedule = schedule;
        }

        public int threadHash() {
            return this.hashCode();
        }

        public int getFlags() {
            return 0;
        }

        public void perform(AsyncReadGraph graph, AsyncProcedure<Boolean> procedure) {
            for (final Resource p : this.schedule) {
                graph.forPossibleInverse(p, (AsyncProcedure)new AsyncProcedure<Resource>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void register(AsyncReadGraph graph, Resource predicate, Resource superRelation, WeakStatus status) {
                        Map<Resource, WeakStatus> map = weakMap;
                        synchronized (map) {
                            weakMap.put(predicate, status);
                            if (superRelation != null) {
                                weakMap.put(superRelation, status);
                            }
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        throwable.printStackTrace();
                    }

                    public void execute(AsyncReadGraph graph, final Resource inverse) {
                        if (inverse == null) {
                            this.register(graph, p, null, WeakStatus.WEAK);
                        } else {
                            graph.forPossibleSuperrelation(inverse, (AsyncProcedure)new AsyncProcedure<Resource>(){

                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                    throwable.printStackTrace();
                                }

                                public void execute(AsyncReadGraph graph, final Resource superRelation) {
                                    if (superRelation != null && weakMap.containsKey(superRelation)) {
                                        this.register(graph, p, null, weakMap.get(superRelation));
                                        return;
                                    }
                                    graph.forIsSubrelationOf(inverse, ((Layer0)graph.getService(Layer0.class)).IsRelatedTo, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                            throwable.printStackTrace();
                                        }

                                        public void execute(AsyncReadGraph graph, Boolean strong) {
                                            this.register(graph, p, superRelation, strong != false ? WeakStatus.STRONG : WeakStatus.WEAK);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
            }
            procedure.execute(graph, (Object)false);
        }
    }

    static class DomainProcessor {
        Serializer variantSerializer;
        int id = 0;
        Set<Resource> predicates = null;
        Set<Resource> composedPredicates = null;
        Set<Resource> expansionSeeds = null;
        Map<Resource, Integer> ids = null;
        Map<Resource, SubgraphExtent.ExtentStatus> status = null;
        Map<Resource, WeakStatus> weakInverses = null;
        final Set<SubgraphAdvisor> advisors;
        final ArrayList<Double> priorityList = new ArrayList();
        private long composedObjectCounter = 0L;
        private long fastInternalCounter = 0L;
        private long parentExternalCounter = 0L;
        private long fullInternalCounter = 0L;
        private long fullExternalCounter = 0L;
        private long startupTime = 0L;
        private long expandTime = 0L;
        private long fullResolveTime = 0L;
        private long fastResolveTime = 0L;
        private long otherStatementTime = 0L;
        private long parentResolveTime = 0L;
        private long extentSeedTime = 0L;
        private long composedPredicateTime = 0L;
        private long composedObjectTime = 0L;
        ConcurrentLinkedQueue<Resource> fastInternals = new ConcurrentLinkedQueue();

        public DomainProcessor(Set<SubgraphAdvisor> advisors) {
            this.advisors = advisors;
            HashSet<Double> prioritySet = new HashSet<Double>();
            for (SubgraphAdvisor advisor : advisors) {
                prioritySet.add(advisor.priority());
            }
            this.priorityList.addAll(prioritySet);
            Collections.sort(this.priorityList);
        }

        public void expand(ReadGraph graph, Collection<DirectStatements>[] expansion, Set<Resource> schedule) throws DatabaseException {
            long start = System.nanoTime();
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            ArrayList[] listElements = new ArrayList[control.getAmountOfQueryThreads()];
            int i = 0;
            while (i < control.getAmountOfQueryThreads()) {
                listElements[i] = new ArrayList();
                ++i;
            }
            graph.syncRequest((AsyncRead)new Expansion(this.expansionSeeds, expansion, listElements));
            i = 0;
            while (i < control.getAmountOfQueryThreads()) {
                for (Resource s : listElements[i]) {
                    schedule.add(s);
                }
                ++i;
            }
            this.expandTime += System.nanoTime() - start;
        }

        public void extractComposedPredicates(ReadGraph graph, Collection<DirectStatements>[] expansion) throws DatabaseException {
            long start = System.nanoTime();
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            final ConcurrentLinkedQueue composedResult = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue singleResult = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue singles = new ConcurrentLinkedQueue();
            final Set schedule = cs.createSet();
            Collection<DirectStatements>[] collectionArray = expansion;
            int n = expansion.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<DirectStatements> coll = collectionArray[n2];
                for (DirectStatements stms : coll) {
                    for (Statement stm : stms) {
                        Resource predicate = stm.getPredicate();
                        if (!this.predicates.add(predicate)) continue;
                        schedule.add(predicate);
                    }
                }
                ++n2;
            }
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : schedule) {
                        graph.forPossibleSuperrelation(predicate, (AsyncProcedure)new AsyncProcedure<Resource>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Resource single) {
                                singles.add(Pair.make((Object)predicate, (Object)single));
                            }
                        });
                    }
                }
            });
            final Set singleSchedule = cs.createSet();
            for (Pair pair : singles) {
                Resource single = (Resource)pair.second;
                if (single == null || !this.predicates.add(single)) continue;
                singleSchedule.add(single);
            }
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : singleSchedule) {
                        graph.forIsSubrelationOf(predicate, ((Layer0)graph.getService(Layer0.class)).IsComposedOf, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean composed) {
                                if (composed.booleanValue()) {
                                    singleResult.add(predicate);
                                }
                            }
                        });
                    }
                }
            });
            this.composedPredicates.addAll(singleResult);
            final Set specialSchedule = cs.createSet();
            for (Pair pair : singles) {
                Resource single = (Resource)pair.second;
                if (single != null) {
                    if (!this.composedPredicates.contains(single)) continue;
                    this.composedPredicates.add((Resource)pair.first);
                    continue;
                }
                specialSchedule.add((Resource)pair.first);
            }
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : specialSchedule) {
                        graph.forIsSubrelationOf(predicate, ((Layer0)graph.getService(Layer0.class)).IsComposedOf, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean composed) {
                                if (composed.booleanValue()) {
                                    composedResult.add(predicate);
                                }
                            }
                        });
                    }
                }
            });
            this.composedPredicates.addAll(composedResult);
            this.composedPredicateTime += System.nanoTime() - start;
        }

        public void collectComposedObjects(ReadGraph graph, Collection<DirectStatements>[] expansion, Set<Resource> typeTodo, Set<Resource> objectTodo, Set<Resource> predicateTodo) throws DatabaseException {
            long start = System.nanoTime();
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Collection<DirectStatements>[] collectionArray = expansion;
            int n = expansion.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<DirectStatements> coll = collectionArray[n2];
                for (DirectStatements stms : coll) {
                    for (Statement stm : stms) {
                        Resource predicate = stm.getPredicate();
                        Resource object = stm.getObject();
                        if (this.composedPredicates.contains(predicate)) {
                            SubgraphExtent.ExtentStatus existing = this.status.put(object, SubgraphExtent.ExtentStatus.INTERNAL);
                            if (existing == null) {
                                this.ids.put(object, this.id++);
                                ++this.composedObjectCounter;
                                this.expansionSeeds.add(object);
                                continue;
                            }
                            if (existing == SubgraphExtent.ExtentStatus.EXCLUDED) {
                                System.err.println("preExcluded: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)object, (boolean)true));
                                this.status.put(object, SubgraphExtent.ExtentStatus.EXCLUDED);
                                continue;
                            }
                            if (existing != SubgraphExtent.ExtentStatus.EXTERNAL) continue;
                            System.err.println("preExternal: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)object, (boolean)true));
                            this.status.put(object, SubgraphExtent.ExtentStatus.EXTERNAL);
                            continue;
                        }
                        if (!this.status.containsKey(object)) {
                            if (l0.InstanceOf.equalsResource(predicate)) {
                                typeTodo.add(object);
                            } else {
                                objectTodo.add(object);
                            }
                        }
                        if (this.status.containsKey(predicate)) continue;
                        predicateTodo.add(predicate);
                    }
                }
                ++n2;
            }
            this.composedObjectTime += System.nanoTime() - start;
        }

        public void writeOtherStatements(ReadGraph graph, Collection<Collection<DirectStatements>[]> expansion, ObjectOutputStream composedStatementsOutput, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput) throws DatabaseException {
            long start = System.nanoTime();
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
            TransferableGraphSupport cfr_ignored_0 = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
            TIntArrayList other = new TIntArrayList();
            TIntArrayList composed = new TIntArrayList();
            try {
                Iterator<Collection<DirectStatements>[]> iterator = expansion.iterator();
                while (iterator.hasNext()) {
                    Collection<DirectStatements>[] colls;
                    Collection<DirectStatements>[] collectionArray = colls = iterator.next();
                    int n = colls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Collection<DirectStatements> coll = collectionArray[n2];
                        for (DirectStatements stms : coll) {
                            Resource subject = stms.getSubject();
                            composed.resetQuick();
                            int sId = support.getTransientId(subject);
                            composedStatementsOutput.writeInt(sId);
                            if (graph.hasValue(subject)) {
                                Datatype dt = (Datatype)graph.getRelatedValue(subject, l0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
                                Binding b = Bindings.getBinding((Datatype)dt);
                                Object _value = graph.getValue(subject, b);
                                Variant variant = new Variant(b, _value);
                                byte[] value = this.variantSerializer.serialize((Object)variant);
                                valueOutput.writeInt(sId);
                                valueOutput.writeInt(value.length);
                                assert (value.length > 0);
                                valueOutput.write(value);
                            }
                            for (Statement s : stms) {
                                Resource object = s.getObject();
                                Resource predicate = s.getPredicate();
                                SubgraphExtent.ExtentStatus objectStatus = this.status.get(object);
                                if (objectStatus == SubgraphExtent.ExtentStatus.INTERNAL) {
                                    composed.add(support.getTransientId(predicate));
                                    composed.add(support.getTransientId(object));
                                    continue;
                                }
                                if (l0.InstanceOf.equalsResource(predicate)) {
                                    composed.add(support.getTransientId(predicate));
                                    composed.add(support.getTransientId(object));
                                    continue;
                                }
                                if (l0.SubrelationOf.equalsResource(predicate)) {
                                    composed.add(support.getTransientId(predicate));
                                    composed.add(support.getTransientId(object));
                                    continue;
                                }
                                if (objectStatus != SubgraphExtent.ExtentStatus.EXTERNAL) continue;
                                other.add(support.getTransientId(predicate));
                                other.add(support.getTransientId(object));
                            }
                            if (!other.isEmpty()) {
                                otherStatementsOutput.writeInt(sId);
                                otherStatementsOutput.writeInt(other.size() / 2);
                                int i = 0;
                                while (i < other.size()) {
                                    otherStatementsOutput.writeInt(other.getQuick(i));
                                    ++i;
                                }
                                other.resetQuick();
                            }
                            composedStatementsOutput.writeInt(composed.size() / 2);
                            int i = 0;
                            while (i < composed.size()) {
                                composedStatementsOutput.writeInt(composed.getQuick(i));
                                ++i;
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.otherStatementTime += System.nanoTime() - start;
        }

        boolean hasStrictParents(ReadGraph g, Resource r) throws DatabaseException {
            return g.getPossibleURI(r) != null;
        }

        public boolean getExpansionSeedsFromExtents(ReadGraph graph, final Collection<DirectStatements>[] expansion) throws DatabaseException {
            long start = System.nanoTime();
            final ConcurrentLinkedQueue accepts = new ConcurrentLinkedQueue();
            block0: for (Double priority : this.priorityList) {
                for (final SubgraphAdvisor advisor : this.advisors) {
                    if (advisor.priority() > 0.0) continue;
                    if (advisor.priority() == priority.doubleValue()) {
                        graph.syncRequest((Read)new ReadRequest(){

                            public void run(ReadGraph graph) throws DatabaseException {
                                Collection[] collectionArray = expansion;
                                int n = expansion.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Collection coll = collectionArray[n2];
                                    for (DirectStatements stms : coll) {
                                        for (final Statement stm : stms) {
                                            advisor.advise((AsyncReadGraph)graph, stm, new AsyncProcedure<Boolean>(){

                                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                                    throwable.printStackTrace();
                                                }

                                                public void execute(AsyncReadGraph graph, Boolean accept) {
                                                    if (accept.booleanValue()) {
                                                        accepts.add(stm.getObject());
                                                    }
                                                }
                                            });
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        });
                    }
                    if (!accepts.isEmpty()) break block0;
                }
            }
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Set schedule = cs.createSet();
            for (Resource r : accepts) {
                if (this.status.containsKey(r)) continue;
                schedule.add(r);
            }
            this.extentSeedTime += System.nanoTime() - start;
            if (schedule.isEmpty()) {
                return false;
            }
            this.fastResolve(graph, schedule);
            this.uriResolve(graph, schedule);
            this.fullResolve(graph, schedule, "accepts");
            return true;
        }

        public void fastResolve(ReadGraph graph, Set<Resource> rs) throws DatabaseException {
            if (this.fastResolveLoop(graph, rs)) {
                this.fastResolveLoop(graph, rs);
            }
        }

        public boolean fastResolveLoop(ReadGraph graph, final Set<Resource> rs) throws DatabaseException {
            long start = System.nanoTime();
            final ConcurrentLinkedQueue weakSchedule = new ConcurrentLinkedQueue();
            graph.syncRequest((AsyncRead)new AsyncRead<Boolean>(){

                public int threadHash() {
                    return this.hashCode();
                }

                public int getFlags() {
                    return 0;
                }

                public void perform(AsyncReadGraph graph, AsyncProcedure<Boolean> procedure) {
                    QueryControl control = (QueryControl)graph.getService(QueryControl.class);
                    final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
                    int slice = rs.size() / control.getAmountOfQueryThreads() + 1;
                    final Resource[] rootArray = rs.toArray(Resource.NONE);
                    int i = 0;
                    while (i < control.getAmountOfQueryThreads()) {
                        final int start = i * slice;
                        final int end = Math.min(start + slice, rootArray.length);
                        control.schedule(graph, i, new QueryControl.ControlProcedure(){

                            public void execute(AsyncReadGraph graph) {
                                int index = start;
                                while (index < end) {
                                    final Resource r = rootArray[index];
                                    graph.asyncRequest((AsyncRead)new FastInternalRequest(dqs, r, status, weakInverses, weakSchedule), (AsyncProcedure)new AsyncProcedure<Boolean>(){

                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                            throwable.printStackTrace();
                                        }

                                        public void execute(AsyncReadGraph graph, Boolean isInternal) {
                                            if (isInternal.booleanValue()) {
                                                fastInternals.add(r);
                                            }
                                        }
                                    });
                                    ++index;
                                }
                            }
                        });
                        ++i;
                    }
                    procedure.execute(graph, (Object)true);
                }
            });
            if (!weakSchedule.isEmpty()) {
                THashSet weaks = new THashSet(weakSchedule);
                graph.syncRequest((AsyncRead)new ClassifyStatementsRequest((Set<Resource>)weaks, this.weakInverses));
            }
            for (Resource r : this.fastInternals) {
                rs.remove(r);
                if (this.status.put(r, SubgraphExtent.ExtentStatus.INTERNAL) != null) continue;
                this.ids.put(r, this.id++);
                ++this.fastInternalCounter;
                this.expansionSeeds.add(r);
            }
            this.fastResolveTime += System.nanoTime() - start;
            return !weakSchedule.isEmpty();
        }

        private SubgraphExtent.ExtentStatus resolveExtent(ReadGraph graph, Resource r, Map<Resource, SubgraphExtent.ExtentStatus> statuses, Set<Resource> expansionSeeds, THashSet<Resource> pending, ArrayList<Resource> stack) throws DatabaseException {
            SubgraphExtent.ExtentStatus current = statuses.get(r);
            if (current != null) {
                return current;
            }
            if (pending.contains((Object)r)) {
                return SubgraphExtent.ExtentStatus.PENDING;
            }
            pending.add((Object)r);
            SubgraphExtent.ExtentStatus status = SubgraphExtent.ExtentStatus.INTERNAL;
            for (Resource p : Subgraphs.getParents(graph, r)) {
                switch (this.resolveExtent(graph, p, statuses, expansionSeeds, pending, stack)) {
                    case EXTERNAL: {
                        return SubgraphExtent.ExtentStatus.EXTERNAL;
                    }
                    case PENDING: {
                        status = SubgraphExtent.ExtentStatus.PENDING;
                    }
                }
            }
            if (status == SubgraphExtent.ExtentStatus.INTERNAL) {
                pending.remove((Object)r);
                stack.add(r);
            }
            return status;
        }

        public void uriResolve(ReadGraph graph, final Set<Resource> todo) throws DatabaseException {
            long start = System.nanoTime();
            for (Resource r : todo) {
                System.out.println("uriResolve " + NameUtils.getSafeName((ReadGraph)graph, (Resource)r));
            }
            final ConcurrentSkipListSet found = new ConcurrentSkipListSet();
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource r : todo) {
                        if (status.containsKey(r)) continue;
                        graph.forURI(r, (AsyncProcedure)new AsyncProcedure<String>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, String uri) {
                                if (uri != null) {
                                    if (found.add(r)) {
                                        DomainProcessor domainProcessor = this;
                                        domainProcessor.parentExternalCounter = domainProcessor.parentExternalCounter + 1L;
                                    }
                                } else {
                                    graph.forPossibleInverse(r, (AsyncProcedure)new AsyncProcedure<Resource>(){

                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                            throwable.printStackTrace();
                                        }

                                        public void execute(AsyncReadGraph graph, Resource inverse) {
                                            if (inverse != null) {
                                                graph.forURI(inverse, (AsyncProcedure)new AsyncProcedure<String>(){

                                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                                        throwable.printStackTrace();
                                                    }

                                                    public void execute(AsyncReadGraph graph, String uri) {
                                                        if (uri != null && found.add(r)) {
                                                            DomainProcessor domainProcessor = this;
                                                            domainProcessor.parentExternalCounter = domainProcessor.parentExternalCounter + 1L;
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
            todo.removeAll(found);
            for (Resource r : found) {
                this.status.put(r, SubgraphExtent.ExtentStatus.EXTERNAL);
            }
            this.parentResolveTime += System.nanoTime() - start;
        }

        public void fullResolve(ReadGraph graph, Collection<Resource> rs, String koss) throws DatabaseException {
            long start = System.nanoTime();
            for (Resource r : rs) {
                if (this.status.containsKey(r)) continue;
                THashSet pending = new THashSet();
                ArrayList<Resource> stack = new ArrayList<Resource>();
                SubgraphExtent.ExtentStatus s = this.resolveExtent(graph, r, this.status, this.expansionSeeds, (THashSet<Resource>)pending, stack);
                if ((SubgraphExtent.ExtentStatus.INTERNAL == s || SubgraphExtent.ExtentStatus.PENDING == s) && this.status.put(r, SubgraphExtent.ExtentStatus.INTERNAL) == null) {
                    this.ids.put(r, this.id++);
                    ++this.fullInternalCounter;
                    this.expansionSeeds.add(r);
                }
                if (SubgraphExtent.ExtentStatus.EXTERNAL != s || this.status.put(r, SubgraphExtent.ExtentStatus.EXTERNAL) != null) continue;
                ++this.fullExternalCounter;
            }
            this.fullResolveTime += System.nanoTime() - start;
        }

        public void process(ReadGraph graph, ObjectOutputStream composedStatementsOutput, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput) throws DatabaseException {
            this.variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Set typeTodo = cs.createSet();
            Set objectTodo = cs.createSet();
            Set predicateTodo = cs.createSet();
            ArrayList<Collection<DirectStatements>[]> fullExpansion = new ArrayList<Collection<DirectStatements>[]>();
            do {
                QueryControl control = (QueryControl)graph.getService(QueryControl.class);
                ArrayList[] expansion = new ArrayList[control.getAmountOfQueryThreads()];
                int i = 0;
                while (i < control.getAmountOfQueryThreads()) {
                    expansion[i] = new ArrayList();
                    ++i;
                }
                this.expand(graph, expansion, objectTodo);
                this.expansionSeeds = cs.createSet();
                this.extractComposedPredicates(graph, expansion);
                this.collectComposedObjects(graph, expansion, typeTodo, objectTodo, predicateTodo);
                this.getExpansionSeedsFromExtents(graph, expansion);
                fullExpansion.add(expansion);
            } while (!this.expansionSeeds.isEmpty());
            this.fastResolve(graph, objectTodo);
            this.uriResolve(graph, predicateTodo);
            this.uriResolve(graph, objectTodo);
            this.uriResolve(graph, typeTodo);
            this.fullResolve(graph, objectTodo, "objectTodo");
            this.fullResolve(graph, predicateTodo, "predicateTodo");
            this.fullResolve(graph, typeTodo, "typeTodo");
            this.writeOtherStatements(graph, fullExpansion, composedStatementsOutput, otherStatementsOutput, valueOutput);
        }
    }

    static class DomainProcessor2 {
        Serializer variantSerializer;
        int id = 0;
        Set<Resource> fringe = null;
        Set<Resource> exclusions = new HashSet<Resource>();
        Set<Resource> internalDomain = new HashSet<Resource>();
        Set<Resource> sharedExternalReferences = null;
        TIntSet sharedExternalIds = null;
        Set<Resource> sharedExternalFringe = null;
        Set<Resource> predicates = null;
        Set<Resource> isRelatedToPredicates = null;
        Set<Resource> sharedPredicates = null;
        TIntIntHashMap ids = null;
        Map<Resource, Statement> specials = null;
        Map<Resource, SubgraphExtent.ExtentStatus> status = null;
        Map<Resource, WeakStatus> weakInverses = null;
        private long composedObjectCounter = 0L;
        private long fastInternalCounter = 0L;
        private long parentExternalCounter = 0L;
        private long fullInternalCounter = 0L;
        private long fullExternalCounter = 0L;
        private long startupTime = 0L;
        private long expandTime = 0L;
        private long fullResolveTime = 0L;
        private long fastResolveTime = 0L;
        private long otherStatementTime = 0L;
        private long parentResolveTime = 0L;
        private long extentSeedTime = 0L;
        private long composedPredicateTime = 0L;
        private long composedObjectTime = 0L;
        private Set<Resource> strongInverseSet = new HashSet<Resource>();

        DomainProcessor2() {
        }

        public void expand(ReadGraph graph, Set<Resource> fringe, Collection<DirectStatements>[] expansion) throws DatabaseException {
            long start = System.nanoTime();
            new ArrayList();
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            int i = 0;
            while (i < control.getAmountOfQueryThreads()) {
                expansion[i] = new ArrayList<DirectStatements>();
                ++i;
            }
            graph.syncRequest((AsyncRead)new Expansion2(fringe, expansion));
            fringe.clear();
            this.expandTime += System.nanoTime() - start;
        }

        public void classifyPredicates(ReadGraph graph, final Set<Resource> schedule) throws DatabaseException {
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            final Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            long start = System.nanoTime();
            final ConcurrentLinkedQueue composedResult = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue singleResult = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue sharedResult = new ConcurrentLinkedQueue();
            final ConcurrentLinkedQueue singles = new ConcurrentLinkedQueue();
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : schedule) {
                        graph.forPossibleSuperrelation(predicate, (AsyncProcedure)new AsyncProcedure<Resource>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Resource single) {
                                singles.add(Pair.make((Object)predicate, (Object)single));
                            }
                        });
                        graph.forHasStatement(predicate, L0.SharedRange, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean shared) {
                                if (shared.booleanValue()) {
                                    sharedResult.add(predicate);
                                }
                            }
                        });
                    }
                }
            });
            final Set singleSchedule = cs.createSet();
            for (Pair pair : singles) {
                Resource single = (Resource)pair.second;
                if (single == null || !this.predicates.add(single)) continue;
                singleSchedule.add(single);
            }
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : singleSchedule) {
                        graph.forIsSubrelationOf(predicate, L0.IsRelatedTo, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean strong) {
                                if (strong.booleanValue()) {
                                    singleResult.add(predicate);
                                }
                            }
                        });
                    }
                }
            });
            this.isRelatedToPredicates.addAll(singleResult);
            this.sharedPredicates.addAll(sharedResult);
            final Set specialSchedule = cs.createSet();
            for (Pair pair : singles) {
                Resource single = (Resource)pair.second;
                if (single != null) {
                    if (!this.isRelatedToPredicates.contains(single)) continue;
                    this.isRelatedToPredicates.add((Resource)pair.first);
                    continue;
                }
                specialSchedule.add((Resource)pair.first);
            }
            graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                public void run(AsyncReadGraph graph) {
                    for (final Resource predicate : specialSchedule) {
                        graph.forIsSubrelationOf(predicate, L0.IsRelatedTo, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean composed) {
                                if (composed.booleanValue()) {
                                    composedResult.add(predicate);
                                }
                            }
                        });
                    }
                }
            });
            this.isRelatedToPredicates.addAll(composedResult);
            this.composedPredicateTime += System.nanoTime() - start;
        }

        public void classifyPredicates(ReadGraph graph, Collection<DirectStatements>[] expansion) throws DatabaseException {
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Set schedule = cs.createSet();
            Map newPredicates = (Map)cs.createMap(Resource.class);
            Collection<DirectStatements>[] collectionArray = expansion;
            int n = expansion.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<DirectStatements> coll = collectionArray[n2];
                for (DirectStatements stms : coll) {
                    for (Statement stm : stms) {
                        Resource predicate = stm.getPredicate();
                        if (!this.predicates.add(predicate)) continue;
                        Resource inverse = graph.getPossibleInverse(predicate);
                        schedule.add(predicate);
                        if (inverse == null) continue;
                        newPredicates.put(predicate, inverse);
                        if (!this.predicates.add(inverse)) continue;
                        schedule.add(inverse);
                    }
                }
                ++n2;
            }
            this.classifyPredicates(graph, schedule);
            for (Map.Entry entry : newPredicates.entrySet()) {
                if (this.isRelatedToPredicates.contains(entry.getValue())) {
                    this.strongInverseSet.add((Resource)entry.getKey());
                }
                if (!this.isRelatedToPredicates.contains(entry.getKey())) continue;
                this.strongInverseSet.add((Resource)entry.getValue());
            }
        }

        public void processFringe(ReadGraph graph, Collection<DirectStatements>[] expansion, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput) throws DatabaseException, IOException {
            SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
            TransferableGraphSupport cfr_ignored_0 = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            long start = System.nanoTime();
            Collection<DirectStatements>[] collectionArray = expansion;
            int n = expansion.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<DirectStatements> coll = collectionArray[n2];
                for (DirectStatements stms : coll) {
                    Resource subject = stms.getSubject();
                    boolean partOf = false;
                    for (Statement stm : stms) {
                        Resource predicate = stm.getPredicate();
                        if (!L0.PartOf.equals(predicate)) continue;
                        partOf = true;
                        break;
                    }
                    SubgraphExtent.ExtentStatus subjectStatus = this.status.get(subject);
                    if (subjectStatus == SubgraphExtent.ExtentStatus.EXTERNAL) continue;
                    if (partOf && subjectStatus == null && graph.getPossibleURI(subject) != null) {
                        this.status.put(subject, SubgraphExtent.ExtentStatus.EXTERNAL);
                        for (Statement stm : stms) {
                            Resource predicate = stm.getPredicate();
                            if (!this.sharedPredicates.contains(predicate)) continue;
                            this.sharedExternalFringe.add(stm.getObject());
                        }
                        continue;
                    }
                    boolean special = this.specials.containsKey(subject);
                    this.status.put(subject, SubgraphExtent.ExtentStatus.INTERNAL);
                    int sId = support.getTransientId(subject);
                    if (graph.hasValue(subject)) {
                        Datatype dt = (Datatype)graph.getRelatedValue(subject, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
                        Binding b = Bindings.getBinding((Datatype)dt);
                        Object _value = graph.getValue(subject, b);
                        Variant variant = new Variant(b, _value);
                        byte[] value = this.variantSerializer.serialize((Object)variant);
                        valueOutput.writeInt(sId);
                        valueOutput.writeInt(value.length);
                        assert (value.length > 0);
                        valueOutput.write(value);
                    }
                    TIntArrayList stream = new TIntArrayList();
                    for (Statement stm : stms) {
                        int oId;
                        Resource predicate = stm.getPredicate();
                        Resource object = stm.getObject();
                        SubgraphExtent.ExtentStatus objectStatus = this.status.get(object);
                        if (this.isRelatedToPredicates.contains(predicate) && objectStatus != SubgraphExtent.ExtentStatus.EXCLUDED) {
                            int pId = support.getTransientId(predicate);
                            oId = support.getTransientId(object);
                            stream.add(pId);
                            stream.add(oId);
                            if (objectStatus != null) continue;
                            this.fringe.add(object);
                            continue;
                        }
                        if (objectStatus == SubgraphExtent.ExtentStatus.INTERNAL) {
                            if (this.strongInverseSet.contains(predicate)) continue;
                            int pId = support.getTransientId(predicate);
                            oId = support.getTransientId(object);
                            stream.add(pId);
                            stream.add(oId);
                            continue;
                        }
                        if (!special) continue;
                        Statement spec = this.specials.get(subject);
                        if (!stm.getPredicate().equals(spec.getPredicate()) || !stm.getObject().equals(spec.getObject())) continue;
                        int pId = support.getTransientId(predicate);
                        int oId2 = support.getTransientId(object);
                        stream.add(pId);
                        stream.add(oId2);
                    }
                    if (stream.isEmpty()) continue;
                    otherStatementsOutput.writeInt(sId);
                    otherStatementsOutput.writeInt(stream.size() / 2);
                    int i = 0;
                    while (i < stream.size()) {
                        otherStatementsOutput.writeInt(stream.getQuick(i));
                        ++i;
                    }
                }
                ++n2;
            }
            this.composedObjectTime += System.nanoTime() - start;
        }

        public void process(ReadGraph graph, ObjectOutputStream otherStatementsOutput, ObjectOutputStream valueOutput) throws DatabaseException, IOException {
            ArrayList[] expansion;
            this.variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            for (Resource r : ConsistsOfProcess.walk(graph, this.fringe, this.exclusions, true)) {
                if (this.status.put(r, SubgraphExtent.ExtentStatus.INTERNAL) != null) continue;
                String URI2 = graph.getPossibleURI(r);
                if (URI2 != null) {
                    Subgraphs.log("URI INTERNAL " + URI2);
                } else {
                    Subgraphs.log("URI has no URI for " + r);
                }
                this.fringe.add(r);
                this.internalDomain.add(r);
            }
            while (!this.fringe.isEmpty()) {
                expansion = new ArrayList[control.getAmountOfQueryThreads()];
                this.expand(graph, this.fringe, expansion);
                this.classifyPredicates(graph, expansion);
                this.processFringe(graph, expansion, otherStatementsOutput, valueOutput);
            }
            while (!this.sharedExternalFringe.isEmpty()) {
                expansion = new ArrayList[control.getAmountOfQueryThreads()];
                this.expand(graph, this.sharedExternalFringe, expansion);
                ArrayList[] arrayListArray = expansion;
                int n = expansion.length;
                int n2 = 0;
                while (n2 < n) {
                    ArrayList coll = arrayListArray[n2];
                    for (DirectStatements stms : coll) {
                        Resource subject = stms.getSubject();
                        SubgraphExtent.ExtentStatus subjectStatus = this.status.get(subject);
                        if (SubgraphExtent.ExtentStatus.INTERNAL != subjectStatus || this.internalDomain.contains(subject)) continue;
                        this.status.put(subject, SubgraphExtent.ExtentStatus.EXTERNAL);
                        this.sharedExternalReferences.add(subject);
                        for (Statement stm : stms) {
                            Resource predicate = stm.getPredicate();
                            if (!this.isRelatedToPredicates.contains(predicate)) continue;
                            this.sharedExternalFringe.add(stm.getObject());
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    static class Expansion
    extends AsyncReadRequest {
        private final Collection<Resource> roots;
        final Collection<DirectStatements>[] results;
        final Collection<Resource>[] listElements;

        public Expansion(Collection<Resource> roots, Collection<DirectStatements>[] results, Collection<Resource>[] listElements) {
            this.roots = roots;
            this.results = results;
            this.listElements = listElements;
        }

        public void run(AsyncReadGraph graph) {
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
            final DomainStatementProcedure proc = new DomainStatementProcedure(dqs, (StatementSupport)graph.getService(StatementSupport.class), (Layer0)graph.getService(Layer0.class), this.results, this.listElements);
            int slice = this.roots.size() / control.getAmountOfQueryThreads() + 1;
            final Resource[] rootArray = this.roots.toArray(Resource.NONE);
            int i = 0;
            while (i < control.getAmountOfQueryThreads()) {
                final int start = i * slice;
                final int end = Math.min(start + slice, rootArray.length);
                control.schedule(graph, i, new QueryControl.ControlProcedure(){

                    public void execute(AsyncReadGraph graph) {
                        int index = start;
                        while (index < end) {
                            dqs.forEachDirectStatement(graph, rootArray[index], (AsyncProcedure)proc);
                            ++index;
                        }
                    }
                });
                ++i;
            }
        }

        public int getFlags() {
            return 0;
        }
    }

    static class Expansion2
    extends AsyncReadRequest {
        private final Collection<Resource> roots;
        final Collection<DirectStatements>[] results;
        final boolean ignoreVirtual;

        public Expansion2(Collection<Resource> roots, Collection<DirectStatements>[] results) {
            this(roots, results, true);
        }

        public Expansion2(Collection<Resource> roots, Collection<DirectStatements>[] results, boolean ignoreVirtual) {
            this.roots = roots;
            this.results = results;
            this.ignoreVirtual = ignoreVirtual;
        }

        public void run(AsyncReadGraph graph) {
            QueryControl control = (QueryControl)graph.getService(QueryControl.class);
            final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
            final DomainStatementProcedure2 proc = new DomainStatementProcedure2(this.results);
            int slice = this.roots.size() / control.getAmountOfQueryThreads() + 1;
            final Resource[] rootArray = this.roots.toArray(Resource.NONE);
            int i = 0;
            while (i < control.getAmountOfQueryThreads()) {
                final int start = i * slice;
                final int end = Math.min(start + slice, rootArray.length);
                control.schedule(graph, i, new QueryControl.ControlProcedure(){

                    public void execute(AsyncReadGraph graph) {
                        if (ignoreVirtual) {
                            int index = start;
                            while (index < end) {
                                dqs.forEachDirectPersistentStatement(graph, rootArray[index], (AsyncProcedure)proc);
                                ++index;
                            }
                        } else {
                            int index = start;
                            while (index < end) {
                                dqs.forEachDirectStatement(graph, rootArray[index], (AsyncProcedure)proc);
                                ++index;
                            }
                        }
                    }
                });
                ++i;
            }
        }

        public int getFlags() {
            return 0;
        }
    }

    static class FastInternalRequest
    extends ResourceAsyncRead<Boolean> {
        final DirectQuerySupport dqs;
        final ConcurrentLinkedQueue<Resource> queue;
        final Map<Resource, WeakStatus> weakInverses;
        final Map<Resource, SubgraphExtent.ExtentStatus> status;

        public FastInternalRequest(DirectQuerySupport dqs, Resource resource, Map<Resource, SubgraphExtent.ExtentStatus> status, Map<Resource, WeakStatus> weakInverses, ConcurrentLinkedQueue<Resource> queue) {
            super(resource);
            this.dqs = dqs;
            this.status = status;
            this.weakInverses = weakInverses;
            this.queue = queue;
        }

        public int getFlags() {
            return 0;
        }

        public void perform(AsyncReadGraph graph, final AsyncProcedure<Boolean> procedure) {
            this.dqs.forEachDirectStatement(graph, this.resource, (AsyncProcedure)new AsyncProcedure<DirectStatements>(){

                public void execute(AsyncReadGraph graph, DirectStatements ss) {
                    boolean ok = true;
                    for (Statement statement : ss) {
                        WeakStatus status;
                        if (status.get(statement.getObject()) == SubgraphExtent.ExtentStatus.INTERNAL || (status = weakInverses.get(statement.getPredicate())) == WeakStatus.WEAK) continue;
                        if (status == null) {
                            queue.add(statement.getPredicate());
                        }
                        ok = false;
                    }
                    procedure.execute(graph, (Object)ok);
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    throwable.printStackTrace();
                }
            });
        }
    }

    static enum WeakStatus {
        STRONG,
        WEAK;

    }
}

