/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.FunctionalStatementMapOfResource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.tuple.Tuple2;

public class ExtendedUris {
    private static boolean initialized = false;
    private static Resource ElementToComponent;

    public static Resource resolveAbsoluteUri(ReadGraph graph, String uri) throws DatabaseException {
        if (!uri.startsWith("http:/")) {
            throw new IllegalArgumentException("Invalid absolute URI '" + uri + "'.");
        }
        return ExtendedUris.resolveRelativeUri(graph, graph.getRootLibrary(), uri.substring(6));
    }

    public static Resource resolveRelativeUri(ReadGraph graph, Resource parent, String uri) throws DatabaseException {
        int beginPos = 0;
        while (beginPos < uri.length()) {
            String name;
            String escapedName;
            char c;
            int endPos = beginPos + 1;
            while (endPos < uri.length()) {
                c = uri.charAt(endPos);
                if (c == '/' || c == '#') break;
                ++endPos;
            }
            if ((c = uri.charAt(beginPos)) == '/') {
                escapedName = uri.substring(beginPos + 1, endPos);
                name = URIStringUtils.unescape((String)escapedName);
                if ((parent = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parent))).get(name)) == null) {
                    throw new DatabaseException("Didn't find a child " + name);
                }
            } else if (c == '#') {
                escapedName = uri.substring(beginPos + 1, endPos);
                name = URIStringUtils.unescape((String)escapedName);
                if ((parent = (Resource)((Map)graph.syncRequest((Read)new FunctionalStatementMapOfResource(parent))).get(name)) == null) {
                    throw new DatabaseException("Didn't find a property " + name);
                }
            } else {
                throw new IllegalArgumentException("Invalid relative URI '" + uri + "'.");
            }
            beginPos = endPos;
        }
        return parent;
    }

    private static void initialize(ReadGraph graph) throws DatabaseException {
        ElementToComponent = graph.getResource("http://www.simantics.org/Modeling-1.2/ElementToComponent");
        initialized = true;
    }

    public static Tuple2 getPrimaryFunctionalReference(ReadGraph graph, Resource r) throws DatabaseException {
        Statement stat;
        if (!initialized) {
            ExtendedUris.initialize(graph);
        }
        if ((stat = graph.getPossibleStatement(r, ElementToComponent)) != null) {
            return ExtendedUris.statementToResult(graph, stat);
        }
        return null;
    }

    public static Tuple2 getSecondaryFunctionalReference(ReadGraph graph, Resource r) throws DatabaseException {
        Iterator iterator;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection statements = graph.getStatements(r, L0.PropertyOf);
        if (statements.size() == 1 && (iterator = statements.iterator()).hasNext()) {
            Statement stat = (Statement)iterator.next();
            return ExtendedUris.statementToResult(graph, stat);
        }
        return null;
    }

    private static Tuple2 statementToResult(ReadGraph graph, Statement stat) throws DatabaseException {
        return new Tuple2((Object)stat.getObject(), (Object)graph.getInverse(stat.getPredicate()));
    }
}

