/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.Collection;
import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.layer0.Layer0;

class ConsistsOfProcess {
    final Set<Resource> result;
    final AsyncContextMultiProcedure<Resource, Resource> structure;

    public static Set<Resource> walk(ReadGraph graph, Collection<Resource> resources, Set<Resource> exclusions, boolean ignoreVirtual) throws DatabaseException {
        ConsistsOfProcess process = new ConsistsOfProcess(graph, resources, exclusions, ignoreVirtual);
        return process.result;
    }

    private ConsistsOfProcess(ReadGraph graph, final Collection<Resource> resources, final Set<Resource> exclusions, final boolean ignoreVirtual) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        this.result = cs.createSet();
        this.structure = dqs.compileForEachObject(graph, L0.ConsistsOf, (AsyncContextMultiProcedure)new AsyncContextMultiProcedure<Resource, Resource>(){

            public void execute(AsyncReadGraph graph, Resource parent, Resource child) {
                if (exclusions.contains(child)) {
                    return;
                }
                if ((!ignoreVirtual || child.isPersistent()) && ConsistsOfProcess.this.result.add(child)) {
                    dqs.forEachObjectCompiled(graph, child, (Object)child, ConsistsOfProcess.this.structure);
                }
            }

            public void finished(AsyncReadGraph graph) {
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Logger.defaultLogError((Throwable)throwable);
            }
        });
        graph.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                for (Resource r : resources) {
                    dqs.forEachObjectCompiled((AsyncReadGraph)graph, r, (Object)r, ConsistsOfProcess.this.structure);
                }
            }
        });
    }
}

