/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.refactoring.GraphRefactoringException;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.refactoring.MappingSpecification;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.IdentityStore;
import org.simantics.layer0.Layer0;

public class NamespaceMigrationStep
implements MigrationStep {
    final ArrayList<MappingSpecification.MappingRule> rules = new ArrayList();

    public NamespaceMigrationStep(ReadGraph graph, Resource step) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource prefix : ListUtils.toList((ReadGraph)graph, (Resource)step)) {
            String base = (String)graph.getPossibleRelatedValue(prefix, L0.NamespaceMigrationStep_Prefix_base, (Binding)Bindings.STRING);
            String from = (String)graph.getPossibleRelatedValue(prefix, L0.NamespaceMigrationStep_Prefix_from, (Binding)Bindings.STRING);
            String to = (String)graph.getPossibleRelatedValue(prefix, L0.NamespaceMigrationStep_Prefix_to, (Binding)Bindings.STRING);
            if (from == null || to == null) continue;
            Path fromURI = UriUtils.uriToPath((String)(String.valueOf(base) + from));
            Path toURI = UriUtils.uriToPath((String)(String.valueOf(base) + to));
            if (fromURI != null && toURI != null) {
                this.rules.add(new MappingSpecification.MappingRule(fromURI, toURI));
                continue;
            }
            System.err.println("Namespace migration uri formation error: base " + base + " from " + from + " to " + to);
        }
    }

    @Override
    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        TransferableGraph1 tg = MigrationUtils.getTG(session, state);
        try {
            MappingSpecification mappingSpec = new MappingSpecification(this.rules);
            boolean fixed = GraphRefactoringUtils.fixIncorrectRoot((Identity[])tg.identities);
            System.err.println("fixed=" + fixed);
            IdentityStore idStore = TransferableGraphConversion.extractIdentities((TransferableGraph1)tg);
            idStore.printChildMap();
            TIntHashSet parentsAffected = new TIntHashSet();
            GraphRefactoringUtils.refactor((TransferableGraph1)tg, (IdentityStore)idStore, (MappingSpecification)mappingSpec, (TIntHashSet)parentsAffected);
            tg.resourceCount = idStore.getResourceCount();
            tg.identities = idStore.toArray();
            if (fixed) {
                GraphRefactoringUtils.unfixIncorrectRoot((Identity[])tg.identities);
            }
            System.err.println("rc2: " + tg.resourceCount);
        }
        catch (GraphRefactoringException e) {
            e.printStackTrace();
        }
    }
}

