/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.TransferableGraphSource;

public class TGRemover
extends AbstractRemover {
    private IProgressMonitor monitor;

    public TGRemover(Resource resource) {
        super(resource);
    }

    public TGRemover(IProgressMonitor monitor, Resource resource) {
        super(resource);
        this.monitor = monitor;
    }

    @Override
    public void remove(final WriteGraph graph) throws DatabaseException {
        TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2((ReadGraph)graph, this.resource);
        conf.values = false;
        ModelTransferableGraphSource source = (ModelTransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
        final SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        try {
            source.forResourceStatements((ReadGraph)graph, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

                public void execute(int[] value) throws Exception {
                    Resource s = ss.getResource(value[0]);
                    Resource p = ss.getResource(value[1]);
                    Resource i = null;
                    if (value[2] != -1) {
                        i = ss.getResource(value[2]);
                    }
                    Resource o = ss.getResource(value[3]);
                    graph.deny(s, p, i, o);
                }
            });
            source.forValueResources((ReadGraph)graph, new TransferableGraphSource.TransferableGraphSourceProcedure<int[]>(){

                public void execute(int[] value) throws Exception {
                    Resource s = ss.getResource(value[0]);
                    graph.denyValue(s);
                }
            });
            source.closeStreams();
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

