/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadExt;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;

public class EntityInstances
implements Instances {
    private static final boolean TRACE_QUERIES = false;
    private final Resource type;

    public EntityInstances(Resource type) {
        this.type = type;
    }

    @Override
    public Collection<Resource> find(ReadGraph graph, Resource index) throws DatabaseException {
        return this.find(graph, index, "");
    }

    private List<Resource> findRec(ReadGraph graph, Resource index, String filter, Set<Resource> visited) throws DatabaseException {
        if (!visited.add(index)) {
            return Collections.emptyList();
        }
        CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
        List indexResult = (List)graph.syncRequest((Read)new QueryIndex(index, this.type, filter), (Listener)TransientCacheListener.instance());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection linkedRoots = (Collection)graph.syncRequest((Read)new ObjectsWithType(index, L0.IsLinkedTo, L0.IndexRoot));
        if (linkedRoots.isEmpty()) {
            return indexResult;
        }
        List result = indexResult;
        for (Resource dep : linkedRoots) {
            List<Resource> linkedIndexResults = this.findRec(graph, dep, filter, visited);
            if (linkedIndexResults.isEmpty()) continue;
            if (result == indexResult) {
                result = coll.createList();
                result.addAll(indexResult);
            }
            result.addAll(linkedIndexResults);
        }
        return result;
    }

    @Override
    public Collection<Resource> find(ReadGraph graph, Resource index, String filter) throws DatabaseException {
        CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
        THashSet visited = new THashSet();
        List<Resource> rec = this.findRec(graph, index, filter, (Set<Resource>)visited);
        for (Resource global : Layer0Utils.listGlobalOntologies(graph)) {
            if (!visited.add((Object)global)) continue;
            List rs = (List)graph.syncRequest((Read)new QueryIndex(global, this.type, filter), (Listener)TransientCacheListener.instance());
            if (rec.isEmpty() && !rs.isEmpty()) {
                rec = new ArrayList<Resource>();
            }
            rec.addAll(rs);
        }
        List result = coll.asSortedList(rec);
        return result;
    }

    @Override
    public Collection<Resource> findByName(ReadGraph graph, Resource model, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
        List results = coll.createList();
        for (Resource match : this.find(graph, model, name)) {
            if (!name.equals(graph.getPossibleRelatedValue(match, L0.HasName, (Binding)Bindings.STRING))) continue;
            results.add(match);
        }
        return results;
    }

    public static class QueryIndex
    extends TernaryRead<Resource, Resource, String, List<Resource>>
    implements ReadExt {
        public QueryIndex(Resource index, Resource type, String filter) {
            super((Object)index, (Object)type, (Object)filter);
        }

        public List<Resource> perform(ReadGraph graph) throws DatabaseException {
            String filter;
            List results;
            Resource type = (Resource)this.parameter2;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            String typeName = (String)graph.getRelatedValue(type, L0.HasName);
            if (typeName.isEmpty()) {
                return Collections.emptyList();
            }
            Function dependencyResources = (Function)graph.syncRequest((Read)new Adapter(L0X.DependencyResources, Function.class), (Listener)TransientCacheListener.instance());
            StringBuilder filtersb = new StringBuilder();
            filtersb.append("Types:*").append(IndexQueries.escape(typeName, true));
            if (((String)this.parameter3).length() > 0) {
                filtersb.append(" AND ").append((String)this.parameter3);
            }
            if ((results = (List)dependencyResources.apply((Object)graph, this.parameter, (Object)(filter = filtersb.toString()))) == null || results.isEmpty()) {
                return Collections.emptyList();
            }
            CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
            List result = coll.createList();
            for (Resource res : Layer0Utils.sortByCluster(graph, results)) {
                if (!graph.isInstanceOf(res, type)) continue;
                result.add(res);
            }
            return result;
        }

        public String toString() {
            return "QueryIndex " + this.parameter + " " + this.parameter2 + " " + (String)this.parameter3;
        }

        public boolean isImmutable(ReadGraph graph) throws DatabaseException {
            return graph.isImmutable((Resource)this.parameter);
        }

        public int getType() {
            return 1;
        }
    }
}

