/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.layer0.StandardEngine;
import org.simantics.db.layer0.StandardNodeManager;
import org.simantics.db.layer0.StandardSessionManager;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.simulator.variable.Realm;

public abstract class StandardRealm<Node, Engine extends StandardEngine<Node>>
implements Realm {
    String id;
    Thread executorThread;
    ExecutorService executor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            StandardRealm.this.executorThread = new Thread(r);
            return StandardRealm.this.executorThread;
        }
    });
    Semaphore beginSyncExec = new Semaphore(0);
    Semaphore endSyncExec = new Semaphore(0);
    Engine engine;
    StandardSessionManager<Node, Engine> sessionManager;
    StandardNodeManager<Node, Engine> nodeManager;
    Runnable scheduleSyncExec = new Runnable(){

        @Override
        public void run() {
            StandardRealm.this.beginSyncExec.release();
            try {
                StandardRealm.this.endSyncExec.acquire();
            }
            catch (InterruptedException interruptedException) {}
        }
    };

    protected StandardRealm(StandardSessionManager<Node, Engine> sessionManager, Engine engine, String id) {
        this.sessionManager = sessionManager;
        this.engine = engine;
        this.id = id;
        this.nodeManager = this.createManager();
    }

    protected abstract StandardNodeManager<Node, Engine> createManager();

    protected String getSCLContextKey() {
        return this.getClass().getSimpleName();
    }

    public String getId() {
        return this.id;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Thread getThread() {
        return this.executorThread;
    }

    public Object syncExec(Function fun) throws InterruptedException {
        this.executor.execute(this.scheduleSyncExec);
        SCLContext context = SCLContext.getCurrent();
        StandardEngine oldConnection = (StandardEngine)context.put((Object)this.getSCLContextKey(), this.engine);
        try {
            this.beginSyncExec.acquire();
            Thread oldThread = this.executorThread;
            this.executorThread = Thread.currentThread();
            try {
                Object r = fun.apply(Tuple0.INSTANCE);
                this.executorThread = oldThread;
                this.endSyncExec.release();
                return r;
            }
            catch (Throwable throwable) {
                this.executorThread = oldThread;
                this.endSyncExec.release();
                throw throwable;
            }
        }
        finally {
            context.put((Object)this.getSCLContextKey(), (Object)oldConnection);
        }
    }

    public void asyncExec(final Function fun) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SCLContext context = SCLContext.getCurrent();
                context.put((Object)StandardRealm.this.getSCLContextKey(), StandardRealm.this.engine);
                fun.apply(Tuple0.INSTANCE);
            }
        });
    }

    public void syncExec(Runnable runnable) throws InterruptedException {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
            }
            return;
        }
        this.executor.execute(this.scheduleSyncExec);
        this.beginSyncExec.acquire();
        Thread oldThread = this.executorThread;
        this.executorThread = Thread.currentThread();
        try {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
                this.executorThread = oldThread;
                this.endSyncExec.release();
            }
        }
        finally {
            this.executorThread = oldThread;
            this.endSyncExec.release();
        }
    }

    public void asyncExec(Runnable runnable) {
        if (this.executorThread == Thread.currentThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
            }
            return;
        }
        this.executor.execute(runnable);
    }

    public void close() {
        this.sessionManager.removeRealm(this.id);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    public StandardNodeManager<Node, Engine> getNodeManager() {
        return this.nodeManager;
    }
}

