/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.svg;

import java.util.Arrays;
import org.simantics.g2d.svg.LineCap;
import org.simantics.g2d.svg.LineJoin;
import org.simantics.g2d.svg.SVGUnits;

public class StrokeDesc {
    public static final String DEFAULT_MEASUREMENT_UNIT = "";
    public static final double[] NO_DASHES_DASH_ARRAY = new double[0];
    public static final Integer JOIN_MITER = 0;
    public static final Integer JOIN_ROUND = 1;
    public static final Integer JOIN_BEVEL = 2;
    public static final Integer CAP_BUTT = 0;
    public static final Integer CAP_ROUND = 1;
    public static final Integer CAP_SQUARE = 2;
    private String paint;
    private double opacity;
    private double width;
    private LineJoin join;
    private LineCap cap;
    private double miterLimit;
    private double[] dash;
    private double dashOffset;
    private String unitSuffix;

    public StrokeDesc() {
        this("inherit", 1.0, 1.0, LineJoin.bevel, LineCap.butt, 10.0, null, 0.0);
    }

    public StrokeDesc(String paint) {
        this(paint, 1.0, 1.0, LineJoin.bevel, LineCap.butt, 10.0, null, 0.0);
    }

    public StrokeDesc(String paint, double opacity, double width) {
        this(paint, opacity, width, LineJoin.bevel, LineCap.butt, 10.0, null, 0.0);
    }

    public StrokeDesc(String paint, double opacity, double width, LineJoin join, LineCap cap) {
        this(paint, opacity, width, join, cap, 10.0, null, 0.0);
    }

    public StrokeDesc(String paint, double opacity, double width, LineJoin join, LineCap cap, double miterLimit, double[] dashArray, double dashOffset) {
        this.setPaint(paint);
        this.setOpacity(opacity);
        this.setLineWidth(width);
        this.setLineJoin(join);
        this.setEndCap(cap);
        this.setMiterLimit(miterLimit);
        if (dashArray == null || dashArray.length == 0) {
            dashArray = NO_DASHES_DASH_ARRAY;
        }
        this.dash = dashArray;
        this.dashOffset = dashOffset;
        this.unitSuffix = DEFAULT_MEASUREMENT_UNIT;
    }

    public void setUnitSuffix(String unitSuffix) {
        if (!SVGUnits.isValidUnit(unitSuffix)) {
            throw new IllegalArgumentException("invalid unit suffix: " + unitSuffix);
        }
        this.unitSuffix = unitSuffix;
    }

    public String getUnitSuffix() {
        return this.unitSuffix;
    }

    public String getPaint() {
        return this.paint;
    }

    public void setPaint(String paint) {
        this.paint = paint;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    public double getLineWidth() {
        return this.width;
    }

    public String getLineWidthWithUnit() {
        return String.valueOf(String.valueOf(this.width)) + this.unitSuffix;
    }

    public void setLineWidth(double width) {
        this.width = width;
    }

    public LineCap getEndCap() {
        return this.cap;
    }

    public void setEndCap(LineCap cap) {
        this.cap = cap;
    }

    public LineJoin getLineJoin() {
        return this.join;
    }

    public void setLineJoin(LineJoin join) {
        this.join = join;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(double miterLimit) {
        this.miterLimit = miterLimit;
    }

    public double[] getDashArray() {
        if (this.dash == NO_DASHES_DASH_ARRAY) {
            return this.dash;
        }
        return (double[])this.dash.clone();
    }

    public void setDashArray(double[] dash) {
        if (dash == null || dash.length == 0) {
            dash = NO_DASHES_DASH_ARRAY;
        }
        this.dash = dash;
    }

    public double getDashOffset() {
        return this.dashOffset;
    }

    public void setDashOffset(double dashOffset) {
        this.dashOffset = dashOffset;
    }

    public int hashCode() {
        int hash = (int)Double.doubleToLongBits(this.width);
        hash = hash * 31 + this.join.ordinal();
        hash = hash * 31 + this.cap.ordinal();
        hash = hash * 31 + (int)Double.doubleToLongBits(this.miterLimit);
        if (this.dash != null) {
            hash = hash * 31 + (int)Double.doubleToLongBits(this.dashOffset);
            int i = 0;
            while (i < this.dash.length) {
                hash = hash * 31 + (int)Double.doubleToLongBits(this.dash[i]);
                ++i;
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StrokeDesc)) {
            return false;
        }
        StrokeDesc bs = (StrokeDesc)obj;
        if (this.width != bs.width) {
            return false;
        }
        if (this.join != bs.join) {
            return false;
        }
        if (this.cap != bs.cap) {
            return false;
        }
        if (this.miterLimit != bs.miterLimit) {
            return false;
        }
        if (this.dash != null) {
            if (this.dashOffset != bs.dashOffset) {
                return false;
            }
            if (!Arrays.equals(this.dash, bs.dash)) {
                return false;
            }
        } else if (bs.dash != null) {
            return false;
        }
        return true;
    }

    public void appendDashArrayString(StringBuilder s) {
        if (this.dash.length > 0) {
            s.append(this.dash[0]);
            int i = 1;
            while (i < this.dash.length) {
                s.append(',');
                s.append(this.dash[i]);
                ++i;
            }
        }
    }

    public String dashArrayToString() {
        String s = DEFAULT_MEASUREMENT_UNIT;
        if (this.dash.length > 0) {
            s = String.valueOf(s) + this.dash[0];
            int i = 1;
            while (i < this.dash.length) {
                s = String.valueOf(s) + (44.0 + this.dash[i]);
                ++i;
            }
        }
        return s;
    }
}

