/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import java.awt.geom.Rectangle2D;
import org.simantics.g2d.routing.algorithm1.Rectangle;
import org.simantics.g2d.routing.algorithm1.RoutePencil;

public interface Direction {
    public static final Direction EAST = new East();
    public static final Direction SOUTH = new South();
    public static final Direction WEST = new West();
    public static final Direction NORTH = new North();
    public static final Direction[] directions = new Direction[]{EAST, SOUTH, WEST, NORTH};

    public int getId();

    public double front(Rectangle var1);

    public double back(Rectangle var1);

    public double minSide(Rectangle var1);

    public double maxSide(Rectangle var1);

    public double front(Rectangle2D var1);

    public double back(Rectangle2D var1);

    public double minSide(Rectangle2D var1);

    public double maxSide(Rectangle2D var1);

    public Direction turnLeft();

    public Direction turnRight();

    public double getDir(double var1, double var3);

    public double getSide(double var1, double var3);

    public RoutePencil createPencil(double var1, double var3, double var5, double var7, double var9, RoutePencil var11);

    public static class East
    implements Direction {
        @Override
        public int getId() {
            return 0;
        }

        @Override
        public double front(Rectangle rect) {
            return rect.x0;
        }

        @Override
        public double back(Rectangle rect) {
            return rect.x1;
        }

        @Override
        public double minSide(Rectangle rect) {
            return rect.y0;
        }

        @Override
        public double maxSide(Rectangle rect) {
            return rect.y1;
        }

        @Override
        public double front(Rectangle2D rect) {
            return rect.getMinX();
        }

        @Override
        public double back(Rectangle2D rect) {
            return rect.getMaxX();
        }

        @Override
        public double minSide(Rectangle2D rect) {
            return rect.getMinY();
        }

        @Override
        public double maxSide(Rectangle2D rect) {
            return rect.getMaxY();
        }

        @Override
        public Direction turnLeft() {
            return NORTH;
        }

        @Override
        public Direction turnRight() {
            return SOUTH;
        }

        @Override
        public RoutePencil createPencil(double front, double back, double min, double max, double penalty, RoutePencil parent) {
            return new RoutePencil(front, min, back, max, penalty, this, parent);
        }

        @Override
        public double getDir(double x, double y) {
            return x;
        }

        @Override
        public double getSide(double x, double y) {
            return y;
        }
    }

    public static class North
    implements Direction {
        @Override
        public int getId() {
            return 3;
        }

        @Override
        public double front(Rectangle rect) {
            return -rect.y1;
        }

        @Override
        public double back(Rectangle rect) {
            return -rect.y0;
        }

        @Override
        public double minSide(Rectangle rect) {
            return rect.x0;
        }

        @Override
        public double maxSide(Rectangle rect) {
            return rect.x1;
        }

        @Override
        public double front(Rectangle2D rect) {
            return -rect.getMaxY();
        }

        @Override
        public double back(Rectangle2D rect) {
            return -rect.getMinY();
        }

        @Override
        public double minSide(Rectangle2D rect) {
            return rect.getMinX();
        }

        @Override
        public double maxSide(Rectangle2D rect) {
            return rect.getMaxX();
        }

        @Override
        public Direction turnLeft() {
            return WEST;
        }

        @Override
        public Direction turnRight() {
            return EAST;
        }

        @Override
        public RoutePencil createPencil(double front, double back, double min, double max, double penalty, RoutePencil parent) {
            return new RoutePencil(min, -back, max, -front, penalty, this, parent);
        }

        @Override
        public double getDir(double x, double y) {
            return -y;
        }

        @Override
        public double getSide(double x, double y) {
            return x;
        }
    }

    public static class South
    implements Direction {
        @Override
        public int getId() {
            return 1;
        }

        @Override
        public double front(Rectangle rect) {
            return rect.y0;
        }

        @Override
        public double back(Rectangle rect) {
            return rect.y1;
        }

        @Override
        public double minSide(Rectangle rect) {
            return rect.x0;
        }

        @Override
        public double maxSide(Rectangle rect) {
            return rect.x1;
        }

        @Override
        public double front(Rectangle2D rect) {
            return rect.getMinY();
        }

        @Override
        public double back(Rectangle2D rect) {
            return rect.getMaxY();
        }

        @Override
        public double minSide(Rectangle2D rect) {
            return rect.getMinX();
        }

        @Override
        public double maxSide(Rectangle2D rect) {
            return rect.getMaxX();
        }

        @Override
        public Direction turnLeft() {
            return EAST;
        }

        @Override
        public Direction turnRight() {
            return WEST;
        }

        @Override
        public RoutePencil createPencil(double front, double back, double min, double max, double penalty, RoutePencil parent) {
            return new RoutePencil(min, front, max, back, penalty, this, parent);
        }

        @Override
        public double getDir(double x, double y) {
            return y;
        }

        @Override
        public double getSide(double x, double y) {
            return x;
        }
    }

    public static class West
    implements Direction {
        @Override
        public int getId() {
            return 2;
        }

        @Override
        public double front(Rectangle rect) {
            return -rect.x1;
        }

        @Override
        public double back(Rectangle rect) {
            return -rect.x0;
        }

        @Override
        public double minSide(Rectangle rect) {
            return rect.y0;
        }

        @Override
        public double maxSide(Rectangle rect) {
            return rect.y1;
        }

        @Override
        public double front(Rectangle2D rect) {
            return -rect.getMaxX();
        }

        @Override
        public double back(Rectangle2D rect) {
            return -rect.getMinX();
        }

        @Override
        public double minSide(Rectangle2D rect) {
            return rect.getMinY();
        }

        @Override
        public double maxSide(Rectangle2D rect) {
            return rect.getMaxY();
        }

        @Override
        public Direction turnLeft() {
            return SOUTH;
        }

        @Override
        public Direction turnRight() {
            return NORTH;
        }

        @Override
        public RoutePencil createPencil(double front, double back, double min, double max, double penalty, RoutePencil parent) {
            return new RoutePencil(-back, min, -front, max, penalty, this, parent);
        }

        @Override
        public double getDir(double x, double y) {
            return -x;
        }

        @Override
        public double getSide(double x, double y) {
            return y;
        }
    }
}

