/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;

public class OrientationRestorer
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    CanvasGrab grab;
    @DependencyReflection.Dependency
    CanvasBoundsParticipant bounds;
    long lastTrigger;
    Point2D centerPoint = new Point2D.Double();
    transient Timer timer = new Timer("Rotate restore");
    transient boolean checkRotatePending = false;
    TimerTask task = new TimerTask(){

        @Override
        public void run() {
            ICanvasContext ctx = OrientationRestorer.this.getContext();
            if (ctx.getDisposeState() != DisposeState.Alive) {
                return;
            }
            IThreadWorkQueue thread = ctx.getThreadAccess();
            if (thread == null) {
                return;
            }
            thread.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if ((this).OrientationRestorer.this.checkRotatePending) {
                        return;
                    }
                    (this).OrientationRestorer.this.checkRotatePending = true;
                    OrientationRestorer.this.timerEvent();
                }
            });
        }
    };
    double angVel = 0.0;

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        this.timer.cancel();
        super.removedFromContext(ctx);
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        long delay = 40L;
        this.lastTrigger = System.currentTimeMillis();
        this.timer.scheduleAtFixedRate(this.task, delay, delay);
    }

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_CANVAS_BOUNDS")
    public void selectionChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        Rectangle2D cb = (Rectangle2D)newValue;
        this.centerPoint.setLocation(cb.getCenterX(), cb.getCenterY());
    }

    void timerEvent() {
        ICanvasContext ctx = this.getContext();
        if (ctx == null) {
            return;
        }
        if (ctx.getDisposeState() != DisposeState.Alive) {
            return;
        }
        long cur = System.currentTimeMillis();
        long delta = cur - this.lastTrigger;
        this.lastTrigger = cur;
        this.checkRotatePending = false;
        Point2D centerPoint = new Point2D.Double();
        int grabCount = this.grab.grabInfo.size();
        if (grabCount == 0) {
            centerPoint = this.centerPoint;
        } else if (grabCount == 1) {
            centerPoint = this.grab.grabInfo.values().iterator().next().anchorPos;
        } else {
            this.angVel = 0.0;
            return;
        }
        double theta = this.util.getRotate();
        if (theta == 0.0) {
            return;
        }
        if (Math.abs(theta) < 0.001) {
            this.util.restoreOrientation(centerPoint);
            this.angVel = 0.0;
            return;
        }
        double momentum = theta * 100.0;
        double dt = (double)delta / 1000.0;
        if (dt > 0.15) {
            dt = 0.15;
        }
        this.angVel += momentum * dt;
        this.util.rotate(centerPoint, -this.angVel * dt);
        this.angVel *= 0.5;
    }
}

