/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Rotate;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.FlagHandler;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.g2d.utils.Alignment;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.FlagNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class FlagClass {
    private static final double GLOBAL_SCALE = 0.1;
    private static final double FLAG_SIZE_SCALE = 0.30000000000000004;
    public static final double DEFAULT_WIDTH = 21.000000000000004;
    public static final double DEFAULT_HEIGHT = 6.000000000000001;
    public static final double DEFAULT_BEAK_ANGLE = 60.0;
    public static final IHintContext.Key KEY_FLAG_TYPE = new IHintContext.KeyOf(Type.class, "FLAG_TYPE");
    public static final IHintContext.Key KEY_EXTERNAL = new IHintContext.KeyOf(Boolean.class, "FLAG_EXTERNAL");
    public static final IHintContext.Key KEY_FLAG_MODE = new IHintContext.KeyOf(Mode.class, "FLAG_MODE");
    public static final IHintContext.Key KEY_FLAG_WIDTH = new IHintContext.KeyOf(Double.class, "FLAG_WIDTH");
    public static final IHintContext.Key KEY_FLAG_HEIGHT = new IHintContext.KeyOf(Double.class, "FLAG_HEIGHT");
    public static final IHintContext.Key KEY_FLAG_BEAK_ANGLE = new IHintContext.KeyOf(Double.class, "FLAG_BEAK_ANGLE");
    public static final IHintContext.Key KEY_FLAG_TEXT = new IHintContext.KeyOf(String[].class, "FLAG_TEXT");
    public static final IHintContext.Key KEY_FLAG_TEXT_AREA = new IHintContext.KeyOf(Rectangle2D.class, "FLAG_TEXT_AREA_SIZE");
    public static final IHintContext.Key KEY_SHAPE = new IHintContext.KeyOf(Shape.class, "SHAPE");
    public static final IHintContext.Key KEY_TEXT_HORIZONTAL_ALIGN = new IHintContext.KeyOf(Alignment.class, "TEXT_HORIZONTAL_ALIGN");
    public static final IHintContext.Key KEY_TEXT_VERTICAL_ALIGN = new IHintContext.KeyOf(Alignment.class, "TEXT_VERTICAL_ALIGN");
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "FLAG_SG_NODE");
    private static final IHintContext.Key KEY_FLAG_CONNECTION_DATA = new IHintContext.KeyOf(DataConnection.class, "FLAG_CONNECTION_DATA");
    private static final IHintContext.Key KEY_FLAG_CONNECTION_ELEMENTS = new IHintContext.KeyOf(ElementConnection.class, "FLAG_CONNECTION_ELEMENTS");
    public static final FlagHandler FLAG_HANDLER = new FlagHandler(){
        private static final long serialVersionUID = -4258875745321808416L;

        @Override
        public Type getType(IElement e) {
            return FlagClass.getType(e);
        }

        @Override
        public void setType(IElement e, Type type) {
            e.setHint(KEY_FLAG_TYPE, (Object)type);
        }

        @Override
        public boolean isExternal(IElement e) {
            return Boolean.TRUE.equals(e.getHint(KEY_EXTERNAL));
        }

        @Override
        public void setExternal(IElement e, boolean external) {
            e.setHint(KEY_EXTERNAL, external);
        }

        @Override
        public Connection<IElement> getConnection(IElement e) {
            return (Connection)e.getHint(KEY_FLAG_CONNECTION_ELEMENTS);
        }

        @Override
        public Connection<Object> getConnectionData(IElement e) {
            DataConnection dc = (DataConnection)e.getHint(KEY_FLAG_CONNECTION_DATA);
            return dc != null && dc.isConnected() ? dc : null;
        }

        @Override
        public void connect(IElement e1, IElement e2) {
            if (!($assertionsDisabled || e1 != null && e2 != null)) {
                throw new AssertionError();
            }
            ElementConnection ce = new ElementConnection(e1, e2);
            e1.setHint(KEY_FLAG_CONNECTION_ELEMENTS, ce);
            e2.setHint(KEY_FLAG_CONNECTION_ELEMENTS, ce);
        }

        @Override
        public void connectData(IElement e1, Object o1, Object o2) {
            e1.removeHint(KEY_FLAG_CONNECTION_ELEMENTS);
            e1.setHint(KEY_FLAG_CONNECTION_DATA, new DataConnection(o1, o2));
        }

        @Override
        public void disconnect(IElement local) {
            IElement remote;
            if (!$assertionsDisabled && local == null) {
                throw new AssertionError();
            }
            local.removeHint(KEY_FLAG_CONNECTION_ELEMENTS);
            DataConnection c = (DataConnection)local.removeHint(KEY_FLAG_CONNECTION_DATA);
            if (c != null && (remote = this.otherElement(local, c)) != null) {
                local.removeHint(KEY_FLAG_CONNECTION_ELEMENTS);
                remote.removeHint(KEY_FLAG_CONNECTION_DATA);
            }
        }

        @Override
        public boolean isWithinDiagram(IDiagram d, Connection<?> c) {
            if (!$assertionsDisabled && d == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && c == null) {
                throw new AssertionError();
            }
            if (c instanceof DataConnection) {
                return this.bothOnDiagram(d, (DataConnection)c);
            }
            if (c instanceof ElementConnection) {
                return this.bothOnDiagram(d, (ElementConnection)c);
            }
            return false;
        }

        @Override
        public IElement getCorrespondence(IElement end) {
            if (!$assertionsDisabled && end == null) {
                throw new AssertionError();
            }
            DataConnection dc = (DataConnection)end.getHint(KEY_FLAG_CONNECTION_DATA);
            if (dc != null && dc.isConnected()) {
                return this.otherElement(end, dc);
            }
            ElementConnection ec = (ElementConnection)end.getHint(KEY_FLAG_CONNECTION_ELEMENTS);
            if (ec != null) {
                return this.otherElement(end, ec);
            }
            return null;
        }

        boolean bothOnDiagram(IDiagram d, DataConnection c) {
            if (!c.isConnected()) {
                return false;
            }
            DataElementMap dem = d.getDiagramClass().getSingleItem(DataElementMap.class);
            IElement eout = dem.getElement(d, c.getFirst());
            IElement ein = dem.getElement(d, c.getSecond());
            return eout != null && ein != null;
        }

        boolean bothOnDiagram(IDiagram d, ElementConnection c) {
            DataElementMap dem = d.getDiagramClass().getSingleItem(DataElementMap.class);
            Object o1 = dem.getData(d, (IElement)c.getFirst());
            Object o2 = dem.getData(d, (IElement)c.getSecond());
            return o1 != null && o2 != null;
        }

        public IElement otherElement(IElement e, DataConnection c) {
            if (!c.isConnected()) {
                return null;
            }
            IDiagram d = ElementUtils.peekDiagram(e);
            if (d == null) {
                return null;
            }
            DataElementMap dem = d.getDiagramClass().getSingleItem(DataElementMap.class);
            Object o = dem.getData(d, e);
            if (c.getFirst().equals(o)) {
                return dem.getElement(d, c.getSecond());
            }
            if (c.getSecond().equals(o)) {
                return dem.getElement(d, c.getFirst());
            }
            throw new IllegalArgumentException("specified object '" + o + "' is neither of the connected objects: first='" + c.getSecond() + "', second='" + c.getFirst() + "'");
        }

        public IElement otherElement(IElement e, ElementConnection c) {
            IElement a = (IElement)c.getFirst();
            IElement b = (IElement)c.getSecond();
            if (e == a) {
                return b;
            }
            if (e == b) {
                return a;
            }
            throw new IllegalArgumentException("specified element '" + e + "' is neither of the connected objects: first='" + c.getSecond() + "', second='" + c.getFirst() + "'");
        }
    };
    static final Shape staticShape;
    public static final BasicStroke STROKE;
    static final Image DEFAULT_IMAGE;
    static final StaticSymbolImpl DEFAULT_STATIC_SYMBOL;
    static final FlagSize DEFAULT_FLAG_SIZE;
    static final Initializer DEFAULT_INITIALIZER;
    public static final ElementClass FLAGCLASS;

    static {
        Path2D.Double path = new Path2D.Double();
        staticShape = path;
        FlagClass.createFlagShape(path, Type.In, Mode.External, 21.000000000000004, 6.000000000000001, FlagClass.getBeakLength(6.000000000000001, 60.0));
        STROKE = new BasicStroke(0.15f, 0, 0);
        DEFAULT_IMAGE = new ShapeImage(staticShape, null, STROKE);
        DEFAULT_STATIC_SYMBOL = new StaticSymbolImpl(DEFAULT_IMAGE);
        DEFAULT_FLAG_SIZE = new FlagSize(21.000000000000004, 6.000000000000001, 60.0);
        DEFAULT_INITIALIZER = new Initializer(Type.In, Mode.External);
        FLAGCLASS = ElementClass.compile(DEFAULT_INITIALIZER, FLAG_HANDLER, DefaultTransform.INSTANCE, DEFAULT_FLAG_SIZE, BorderColorImpl.BLACK, FillColorImpl.WHITE, TextImpl.INSTANCE, FlagTerminalTopology.DEFAULT, FlagSceneGraph.INSTANCE, DEFAULT_STATIC_SYMBOL).setId(FlagClass.class.getSimpleName());
    }

    public static ElementClass create(Topology.Terminal terminal) {
        return ElementClass.compile(DEFAULT_INITIALIZER, FLAG_HANDLER, DefaultTransform.INSTANCE, DEFAULT_FLAG_SIZE, BorderColorImpl.BLACK, FillColorImpl.WHITE, TextImpl.INSTANCE, new FlagTerminalTopology(terminal), FlagSceneGraph.INSTANCE, DEFAULT_STATIC_SYMBOL, SimpleElementLayers.INSTANCE).setId(FlagClass.class.getSimpleName());
    }

    public static ElementClass create(Topology.Terminal terminal, SceneGraph scn) {
        return ElementClass.compile(DEFAULT_INITIALIZER, FLAG_HANDLER, DefaultTransform.INSTANCE, DEFAULT_FLAG_SIZE, BorderColorImpl.BLACK, FillColorImpl.WHITE, TextImpl.INSTANCE, new FlagTerminalTopology(terminal), scn, DEFAULT_STATIC_SYMBOL, SimpleElementLayers.INSTANCE).setId(FlagClass.class.getSimpleName());
    }

    public static Path2D createFlagShape(Path2D path, Type type, Mode mode, double width, double height, double beakLength) {
        double hh = height / 2.0;
        path.reset();
        switch (type) {
            case Out: {
                if (mode instanceof External) {
                    path.moveTo(0.0, hh);
                    path.lineTo(width, hh);
                    path.lineTo(width + beakLength, 0.0);
                    path.lineTo(width, -hh);
                    path.lineTo(0.0, -hh);
                    path.closePath();
                    path.moveTo(width, hh);
                    path.lineTo(width, -hh);
                    int count = ((External)mode).count;
                    if (count > 1) {
                        double shadow = hh * 0.25;
                        double ix = beakLength - 0.5 * shadow * (1.0 + beakLength / hh);
                        double iy = hh * (ix / beakLength - 1.0);
                        int sid = 1;
                        while (sid <= Math.min(count - 1, 4)) {
                            double dis = (double)sid * shadow;
                            path.moveTo(dis, hh + dis - shadow);
                            path.lineTo(dis, hh + dis);
                            path.lineTo(dis + width, hh + dis);
                            path.lineTo(dis + width + beakLength, dis);
                            path.lineTo(width + ix + dis, iy + dis);
                            ++sid;
                        }
                        break;
                    }
                    double left = 0.0;
                    double right = width - 0.0;
                    if (!(left < right)) break;
                    path.moveTo(left, 0.0);
                    path.lineTo(right, 0.0);
                    break;
                }
                if (mode != Mode.Internal) break;
                path.moveTo(0.0, hh);
                path.lineTo(beakLength, 0.0);
                path.lineTo(0.0, -hh);
                path.closePath();
                break;
            }
            case In: {
                path.moveTo(0.0, 0.0);
                if (mode instanceof External) {
                    path.lineTo(-beakLength, -hh);
                    path.lineTo(-width - beakLength, -hh);
                    path.lineTo(-width - beakLength, hh);
                    path.lineTo(-beakLength, hh);
                    path.closePath();
                    path.moveTo(-beakLength, -hh);
                    path.lineTo(-beakLength, hh);
                    int count = ((External)mode).count;
                    if (count > 1) {
                        double shadow = hh * 0.25;
                        double ix = beakLength - 0.5 * shadow * (1.0 + beakLength / hh);
                        double iy = hh * (ix / beakLength - 1.0);
                        double xDisp = -width - beakLength;
                        int sid = 1;
                        while (sid <= Math.min(count - 1, 4)) {
                            double dis = (double)sid * shadow;
                            path.moveTo(xDisp + dis, hh + dis - shadow);
                            path.lineTo(xDisp + dis, hh + dis);
                            path.lineTo(xDisp + dis + width, hh + dis);
                            path.lineTo(xDisp + dis + width + beakLength, dis);
                            path.lineTo(xDisp + width + ix + dis, iy + dis);
                            ++sid;
                        }
                        break;
                    }
                    double left = -width - beakLength + 0.0;
                    double right = -beakLength - 0.0;
                    if (!(left < right)) break;
                    path.moveTo(left, 0.0);
                    path.lineTo(right, 0.0);
                    break;
                }
                if (mode != Mode.Internal) break;
                path.lineTo(-beakLength, -hh);
                path.lineTo(-beakLength, hh);
                path.closePath();
            }
        }
        return path;
    }

    public static Path2D createFlagShape(IElement e) {
        Type type = FlagClass.getType(e);
        Mode mode = (Mode)e.getHint(KEY_FLAG_MODE);
        double width = (Double)e.getHint(KEY_FLAG_WIDTH);
        double height = (Double)e.getHint(KEY_FLAG_HEIGHT);
        double beakLength = FlagClass.getBeakLength(e);
        Path2D.Double path = new Path2D.Double();
        FlagClass.createFlagShape(path, type, mode, width, height, beakLength);
        return path;
    }

    public static AffineTransform getTransform(IElement e) {
        AffineTransform at = ElementUtils.getTransform(e);
        if (at == null) {
            return new AffineTransform();
        }
        return at;
    }

    public static double getDirection(IElement e) {
        Rotate rotate = e.getElementClass().getAtMostOneItemOfClass(Rotate.class);
        if (rotate != null) {
            return rotate.getAngle(e);
        }
        return 0.0;
    }

    public static Type getType(IElement e) {
        Type t = (Type)((Object)e.getHint(KEY_FLAG_TYPE));
        return t != null ? t : Type.In;
    }

    public static Mode getMode(IElement e) {
        Mode m = (Mode)e.getHint(KEY_FLAG_MODE);
        return m != null ? m : Mode.External;
    }

    public static double getBeakLength(IElement e) {
        double height = (Double)e.getHint(KEY_FLAG_HEIGHT);
        double beakAngle = (Double)e.getHint(KEY_FLAG_BEAK_ANGLE);
        beakAngle = Math.min(180.0, Math.max(10.0, beakAngle));
        return height / (2.0 * Math.tan(Math.toRadians(beakAngle) / 2.0));
    }

    public static double getBeakLength(double height, double beakAngle) {
        beakAngle = Math.min(180.0, Math.max(10.0, beakAngle));
        return height / (2.0 * Math.tan(Math.toRadians(beakAngle) / 2.0));
    }

    private static class Conn<T>
    implements Connection<T> {
        private final T first;
        private final T second;

        public Conn(T first, T second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public T getFirst() {
            return this.first;
        }

        @Override
        public T getSecond() {
            return this.second;
        }
    }

    public static interface Connection<T> {
        public T getFirst();

        public T getSecond();
    }

    private static class DataConnection
    extends Conn<Object> {
        public DataConnection(Object first, Object second) {
            super(first, second);
            if (first == null) {
                throw new IllegalArgumentException("first is null");
            }
        }

        public boolean isConnected() {
            return this.getSecond() != null;
        }
    }

    private static class ElementConnection
    extends Conn<IElement> {
        public ElementConnection(IElement first, IElement second) {
            super(first, second);
            if (first == null) {
                throw new IllegalArgumentException("first is null");
            }
            if (second == null) {
                throw new IllegalArgumentException("second is null");
            }
        }
    }

    public static class External
    extends Mode {
        public final int count;

        public External(int count) {
            this.count = count;
        }

        public String toString() {
            return "External(" + this.count + ")";
        }
    }

    static class FlagSceneGraph
    implements SceneGraph {
        private static final long serialVersionUID = 35208146123929197L;
        public static final FlagSceneGraph INSTANCE = new FlagSceneGraph();

        FlagSceneGraph() {
        }

        @Override
        public void cleanup(IElement e) {
            ElementUtils.removePossibleNode(e, KEY_SG_NODE);
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            Rectangle2D textArea;
            String text;
            Text t;
            Color fc = ElementUtils.getFillColor(e, Color.WHITE);
            Color bc = ElementUtils.getBorderColor(e, Color.BLACK);
            Color tc = ElementUtils.getTextColor(e, Color.BLACK);
            Outline outline = e.getElementClass().getSingleItem(Outline.class);
            Shape shape = outline.getElementShape(e);
            Type type = FlagClass.getType(e);
            double dir = FlagClass.getDirection(e);
            double width = (Double)e.getHint(KEY_FLAG_WIDTH);
            double height = (Double)e.getHint(KEY_FLAG_HEIGHT);
            double beakAngle = (Double)e.getHint(KEY_FLAG_BEAK_ANGLE);
            String[] flagText = (String[])e.getHint(KEY_FLAG_TEXT);
            if (flagText == null && (t = e.getElementClass().getAtMostOneItemOfClass(Text.class)) != null && (text = t.getText(e)) != null) {
                flagText = new String[]{text};
            }
            if ((textArea = (Rectangle2D)e.getHint(KEY_FLAG_TEXT_AREA)) == null) {
                double beakLength = FlagClass.getBeakLength(height, beakAngle);
                textArea = type == Type.In ? new Rectangle2D.Double(-width - beakLength, -height * 0.5, width, height) : new Rectangle2D.Double(0.0, -height * 0.5, width, height);
            }
            Alignment horizAlign = ElementUtils.getHintOrDefault(e, KEY_TEXT_HORIZONTAL_ALIGN, Alignment.LEADING);
            Alignment vertAlign = ElementUtils.getHintOrDefault(e, KEY_TEXT_VERTICAL_ALIGN, Alignment.CENTER);
            FlagNode flag = ElementUtils.getOrCreateNode(e, parent, KEY_SG_NODE, ElementUtils.generateNodeId(e), FlagNode.class);
            flag.init(shape, flagText, (Stroke)STROKE, bc, fc, tc, (float)width, (float)height, (double)((float)dir), (float)beakAngle, textArea, horizAlign.ordinal(), vertAlign.ordinal());
            AffineTransform at = ElementUtils.getTransform(e);
            if (at != null) {
                flag.setTransform(at);
            }
        }
    }

    static class FlagSize
    implements InternalSize,
    Outline,
    LifeCycle {
        private static final long serialVersionUID = 829379327756475944L;
        private final double length;
        private final double thickness;
        private final double beakAngle;

        public FlagSize(double length, double thickness, double beakAngle) {
            this.length = length;
            this.thickness = thickness;
            this.beakAngle = beakAngle;
        }

        @Override
        public Shape getElementShape(IElement e) {
            Shape shape = (Shape)e.getHint(KEY_SHAPE);
            if (shape != null) {
                return shape;
            }
            return FlagClass.createFlagShape(e);
        }

        @Override
        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            Shape shape = this.getElementShape(e);
            size.setFrame(shape.getBounds2D());
            return size;
        }

        @Override
        public void onElementActivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementCreated(IElement e) {
            e.setHint(KEY_FLAG_WIDTH, this.length);
            e.setHint(KEY_FLAG_HEIGHT, this.thickness);
            e.setHint(KEY_FLAG_BEAK_ANGLE, this.beakAngle);
        }

        @Override
        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementDestroyed(IElement e) {
        }

        public int hashCode() {
            int result = 1;
            long temp = Double.doubleToLongBits(this.beakAngle);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.length);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.thickness);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlagSize other = (FlagSize)obj;
            if (Double.doubleToLongBits(this.beakAngle) != Double.doubleToLongBits(other.beakAngle)) {
                return false;
            }
            if (Double.doubleToLongBits(this.length) != Double.doubleToLongBits(other.length)) {
                return false;
            }
            return Double.doubleToLongBits(this.thickness) == Double.doubleToLongBits(other.thickness);
        }
    }

    public static class FlagTerminalTopology
    implements TerminalTopology,
    TerminalLayout {
        private static final long serialVersionUID = -4194634598346105458L;
        public static final Topology.Terminal DEFAULT_T0 = new TerminalPoint();
        public static final FlagTerminalTopology DEFAULT = new FlagTerminalTopology(DEFAULT_T0);
        final Topology.Terminal T0;

        public FlagTerminalTopology(Topology.Terminal t) {
            this.T0 = t;
        }

        @Override
        public void getTerminals(IElement e, Collection<Topology.Terminal> result) {
            result.add(this.T0);
        }

        @Override
        public AffineTransform getTerminalPosition(IElement node, Topology.Terminal t) {
            if (t == this.T0) {
                return new AffineTransform();
            }
            return null;
        }

        @Override
        public boolean getTerminalDirection(IElement node, Topology.Terminal t, DirectionSet directions) {
            Type type = FlagClass.getType(node);
            double d = FlagClass.getDirection(node);
            if (t == this.T0) {
                switch (type) {
                    case In: {
                        directions.add((Double)d);
                        break;
                    }
                    case Out: {
                        directions.add((Double)Math.IEEEremainder(d + 180.0, 360.0));
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public Shape getTerminalShape(IElement node, Topology.Terminal t) {
            return ElementUtils.getElementShapeOrBounds(node);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.T0 == null ? 0 : this.T0.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlagTerminalTopology other = (FlagTerminalTopology)obj;
            return !(this.T0 == null ? other.T0 != null : !this.T0.equals(other.T0));
        }
    }

    static class Initializer
    implements LifeCycle {
        private static final long serialVersionUID = 4404942036933073584L;
        private final Type type;
        private final Mode mode;

        Initializer(Type type, Mode mode) {
            assert (type != null);
            assert (mode != null);
            this.type = type;
            this.mode = mode;
        }

        @Override
        public void onElementActivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementCreated(IElement e) {
            e.setHint(KEY_FLAG_TYPE, (Object)this.type);
            e.setHint(KEY_FLAG_MODE, this.mode);
        }

        @Override
        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementDestroyed(IElement e) {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.mode.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Initializer other = (Initializer)obj;
            if (!this.mode.equals(other.mode)) {
                return false;
            }
            return this.type.equals((Object)other.type);
        }
    }

    public static class Mode {
        public static final Mode External = new External(1);
        public static final Mode Internal = new Mode(){

            public String toString() {
                return "Internal";
            }
        };
    }

    static class TerminalPoint
    implements Topology.Terminal {
        TerminalPoint() {
        }
    }

    public static enum Type {
        In,
        Out;


        public Type other() {
            return this == Out ? In : Out;
        }
    }
}

