/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementSceneGraphException;
import org.simantics.g2d.element.HideState;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.Adapter;
import org.simantics.g2d.element.handler.AdditionalColor;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.BorderColor;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.ElementAdapter;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.Hover;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Parent;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.TextColor;
import org.simantics.g2d.element.handler.TextEditor;
import org.simantics.g2d.element.handler.TextFont;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ElementUtils {
    public static <T> T getObject(IElement e) {
        return (T)e.getHint(ElementHints.KEY_OBJECT);
    }

    public static void disable(IElement e) {
        Stateful enabled = e.getElementClass().getSingleItem(Stateful.class);
        enabled.setEnabled(e, false);
    }

    public static void enable(IElement e) {
        Stateful enabled = e.getElementClass().getSingleItem(Stateful.class);
        enabled.setEnabled(e, true);
    }

    public static boolean isHidden(IElement e) {
        return e.containsHint(ElementHints.KEY_HIDDEN);
    }

    public static void setHidden(IElement e, boolean hidden) {
        if (hidden) {
            e.setHint(ElementHints.KEY_HIDDEN, (Object)HideState.COMPLETELY_HIDDEN);
        } else {
            e.removeHint(ElementHints.KEY_HIDDEN);
        }
    }

    public static void setText(IElement e, String text) {
        Text t = e.getElementClass().getSingleItem(Text.class);
        t.setText(e, text);
    }

    public static String getText(IElement e) {
        Text t = e.getElementClass().getSingleItem(Text.class);
        return t.getText(e);
    }

    public static void fitToRectangle(IElement e, Rectangle2D rect) {
        Double requiredAspectRatio;
        ElementClass ec = e.getElementClass();
        Move m = ec.getSingleItem(Move.class);
        InternalSize b = ec.getSingleItem(InternalSize.class);
        Rectangle2D internalSize = b.getBounds(e, null);
        if (internalSize == null) {
            return;
        }
        Resize rs = ec.getAtMostOneItemOfClass(Resize.class);
        Scale s = ec.getAtMostOneItemOfClass(Scale.class);
        Point2D scale = s == null ? new Point2D.Double(1.0, 1.0) : s.getScale(e);
        double width = rect.getWidth();
        double height = rect.getHeight();
        double aspectRatio = width / height;
        Double d = requiredAspectRatio = rs == null ? null : rs.getFixedAspectRatio(e);
        if (requiredAspectRatio != null) {
            if (aspectRatio > requiredAspectRatio) {
                width = height * requiredAspectRatio;
            } else {
                height = width / requiredAspectRatio;
            }
        }
        if (rs != null) {
            m.moveTo(e, rect.getX(), rect.getY());
            if (scale != null) {
                width /= scale.getX();
                height /= scale.getY();
            }
            Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, width, height);
            rs.resize(e, r);
        } else if (s != null) {
            double sx = rect.getWidth() / internalSize.getWidth();
            double sy = rect.getHeight() / internalSize.getHeight();
            double px = rect.getX() - internalSize.getX() * sx;
            double py = rect.getY() - internalSize.getY() * sy;
            m.moveTo(e, px, py);
            scale.setLocation(sx, sy);
            s.setScale(e, scale);
        }
    }

    public static void addClickListener(IElement e, ICanvasContext ctx, Clickable.ClickListener listener) {
        Clickable clickable = e.getElementClass().getAtMostOneItemOfClass(Clickable.class);
        clickable.addListener(e, ctx, ctx.getThreadAccess(), listener);
    }

    public static Point2D getPos(IElement e) {
        Move m = e.getElementClass().getSingleItem(Move.class);
        return m.getPosition(e);
    }

    public static Point2D getPos(IElement e, Point2D result) {
        Move m = e.getElementClass().getSingleItem(Move.class);
        if (result == null) {
            result = new Point2D.Double();
        }
        Point2D p = m.getPosition(e);
        result.setLocation(p);
        return result;
    }

    public static Point2D getAbsolutePos(IElement e) {
        Transform tr = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform at = tr.getTransform(e);
        return new Point2D.Double(at.getTranslateX(), at.getTranslateY());
    }

    public static Point2D getAbsolutePos(IElement e, Point2D result) {
        Transform tr = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform at = tr.getTransform(e);
        if (result == null) {
            result = new Point2D.Double();
        }
        result.setLocation(at.getTranslateX(), at.getTranslateY());
        return result;
    }

    public static void setPos(IElement e, Point2D newPosition) {
        Move m = e.getElementClass().getSingleItem(Move.class);
        m.moveTo(e, newPosition.getX(), newPosition.getY());
    }

    public static void setPos(IElement e, double x, double y) {
        Move m = e.getElementClass().getSingleItem(Move.class);
        m.moveTo(e, x, y);
    }

    public static IElement getByData(IDiagram d, Object data) {
        DataElementMap map = d.getDiagramClass().getSingleItem(DataElementMap.class);
        return map.getElement(d, data);
    }

    public static Object getData(IDiagram d, IElement element) {
        DataElementMap map = d.getDiagramClass().getSingleItem(DataElementMap.class);
        return map.getData(d, element);
    }

    public static Collection<Topology.Terminal> getTerminals(IElement e, Collection<Topology.Terminal> result, boolean clearResult) {
        if (clearResult) {
            result.clear();
        }
        TerminalTopology tt = e.getElementClass().getSingleItem(TerminalTopology.class);
        tt.getTerminals(e, result);
        return result;
    }

    public static Topology.Terminal getSingleTerminal(IElement e) {
        ArrayList<Topology.Terminal> ts = new ArrayList<Topology.Terminal>(4);
        TerminalTopology tt = e.getElementClass().getSingleItem(TerminalTopology.class);
        tt.getTerminals(e, ts);
        if (ts.size() != 1) {
            throw new IllegalArgumentException("expected 1 terminal, element e has " + ts.size() + " terminals: " + ts);
        }
        return ts.get(0);
    }

    public static Topology.Terminal peekSingleTerminal(IElement e) {
        ArrayList<Topology.Terminal> ts = new ArrayList<Topology.Terminal>(4);
        TerminalTopology tt = e.getElementClass().getSingleItem(TerminalTopology.class);
        tt.getTerminals(e, ts);
        if (ts.size() != 1) {
            return null;
        }
        return ts.get(0);
    }

    public static DirectionSet getTerminalDirection(IElement e, Topology.Terminal t) {
        List<TerminalLayout> tls = e.getElementClass().getItemsByClass(TerminalLayout.class);
        DirectionSet result = new DirectionSet(new double[0]);
        for (TerminalLayout tl : tls) {
            tl.getTerminalDirection(e, t, result);
        }
        return result;
    }

    public static AffineTransform getTransform(IElement e) {
        return e.getElementClass().getSingleItem(Transform.class).getTransform(e);
    }

    public static AffineTransform getTransform(IElement e, AffineTransform result) {
        if (e == null) {
            return result;
        }
        AffineTransform tr = e.getElementClass().getSingleItem(Transform.class).getTransform(e);
        result.setTransform(tr);
        return result;
    }

    public static AffineTransform getLocalTransform(IElement e, AffineTransform result) {
        AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        if (result == null) {
            result = new AffineTransform();
        }
        if (at != null) {
            result.setTransform(at);
        }
        return result;
    }

    public static void setTransform(IElement e, AffineTransform at) {
        e.getElementClass().getSingleItem(Transform.class).setTransform(e, at);
    }

    public static AffineTransform getInvTransform(IElement e) {
        try {
            return e.getElementClass().getSingleItem(Transform.class).getTransform(e).createInverse();
        }
        catch (NoninvertibleTransformException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static Point2D elementToCanvasCoordinate(IElement e, Point2D elementPoint, Point2D canvasPoint) {
        Transform t = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform at = t.getTransform(e);
        return at.transform(elementPoint, canvasPoint);
    }

    public static Point2D elementToControlCoordinate(IElement e, ICanvasContext ctx, Point2D elementPoint, Point2D controlPoint) {
        Transform t = e.getElementClass().getSingleItem(Transform.class);
        TransformUtil util = (TransformUtil)ctx.getSingleItem(TransformUtil.class);
        Point2D canvasPoint = t.getTransform(e).transform(elementPoint, null);
        return util.getTransform().transform(elementPoint, canvasPoint);
    }

    public static Point2D controlToElementCoordinate(IElement e, ICanvasContext ctx, Point2D controlPoint, Point2D elementPoint) {
        Transform t = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform at = t.getTransform(e);
        TransformUtil util = (TransformUtil)ctx.getSingleItem(TransformUtil.class);
        Point2D canvasPoint = util.controlToCanvas(controlPoint, new Point2D.Double());
        if (elementPoint == null) {
            elementPoint = new Point2D.Double();
        }
        try {
            at.inverseTransform(canvasPoint, elementPoint);
            return elementPoint;
        }
        catch (NoninvertibleTransformException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static Point2D controlToCanvasCoordinate(ICanvasContext ctx, Point2D controlPoint, Point2D canvasPoint) {
        TransformUtil tu = (TransformUtil)ctx.getSingleItem(TransformUtil.class);
        return tu.controlToCanvas(controlPoint, canvasPoint);
    }

    public static Clickable.PressStatus getPressStatus(IElement e, ICanvasContext ctx) {
        Clickable c = e.getElementClass().getAtMostOneItemOfClass(Clickable.class);
        if (c == null) {
            return null;
        }
        return c.getPressStatus(e, ctx);
    }

    public static Color getBorderColor(IElement e) {
        return ElementUtils.getBorderColor(e, null);
    }

    public static Color getFillColor(IElement e) {
        return ElementUtils.getFillColor(e, null);
    }

    public static Color getAdditionalColor(IElement e) {
        return ElementUtils.getAdditionalColor(e, null);
    }

    public static Color getTextColor(IElement e) {
        return ElementUtils.getTextColor(e, null);
    }

    public static Color getBorderColor(IElement e, Color defaultValue) {
        BorderColor bc = e.getElementClass().getAtMostOneItemOfClass(BorderColor.class);
        if (bc == null) {
            return defaultValue;
        }
        Color c = bc.getBorderColor(e);
        return c != null ? c : defaultValue;
    }

    public static Color getFillColor(IElement e, Color defaultValue) {
        FillColor fc = e.getElementClass().getAtMostOneItemOfClass(FillColor.class);
        if (fc == null) {
            return defaultValue;
        }
        Color c = fc.getFillColor(e);
        return c != null ? c : defaultValue;
    }

    public static Color getAdditionalColor(IElement e, Color defaultValue) {
        AdditionalColor ac = e.getElementClass().getAtMostOneItemOfClass(AdditionalColor.class);
        if (ac == null) {
            return null;
        }
        Color c = ac.getAdditionalColor(e);
        return c != null ? c : defaultValue;
    }

    public static Color getTextColor(IElement e, Color defaultValue) {
        TextColor tc = e.getElementClass().getAtMostOneItemOfClass(TextColor.class);
        if (tc == null) {
            return defaultValue;
        }
        Color c = tc.getTextColor(e);
        return c != null ? c : defaultValue;
    }

    public static TextEditor getTextEditor(IElement e) {
        TextEditor ed = e.getElementClass().getAtMostOneItemOfClass(TextEditor.class);
        return ed;
    }

    public static void setBorderColor(IElement e, Color color) {
        BorderColor bc = e.getElementClass().getAtMostOneItemOfClass(BorderColor.class);
        if (bc == null) {
            return;
        }
        bc.setBorderColor(e, color);
    }

    public static void setFillColor(IElement e, Color color) {
        FillColor bc = e.getElementClass().getAtMostOneItemOfClass(FillColor.class);
        if (bc == null) {
            return;
        }
        bc.setFillColor(e, color);
    }

    public static void setAdditionalColor(IElement e, Color color) {
        AdditionalColor bc = e.getElementClass().getAtMostOneItemOfClass(AdditionalColor.class);
        if (bc == null) {
            return;
        }
        bc.setAdditionalColor(e, color);
    }

    public static void setTextColor(IElement e, Color color) {
        TextColor bc = e.getElementClass().getAtMostOneItemOfClass(TextColor.class);
        if (bc == null) {
            return;
        }
        bc.setTextColor(e, color);
    }

    public static void setEdgeStroke(IElement e, Stroke s) {
        EdgeVisuals ev = e.getElementClass().getSingleItem(EdgeVisuals.class);
        ev.setStroke(e, s);
    }

    public static Map<IElement, Rectangle2D> getElementBoundsOnDiagram(Collection<IElement> elements, Map<IElement, Rectangle2D> rects) {
        if (rects == null) {
            rects = new HashMap<IElement, Rectangle2D>();
        }
        for (IElement e : elements) {
            Shape shape = ElementUtils.getElementBoundsOnDiagram(e);
            rects.put(e, shape.getBounds2D());
        }
        return rects;
    }

    public static Rectangle2D getElementBounds(IElement e) {
        InternalSize b = e.getElementClass().getSingleItem(InternalSize.class);
        return b.getBounds(e, new Rectangle2D.Double());
    }

    public static Rectangle2D getElementBounds(IElement e, Rectangle2D result) {
        InternalSize b = e.getElementClass().getSingleItem(InternalSize.class);
        return b.getBounds(e, result);
    }

    public static Shape getElementBoundsOnDiagram(IElement e) {
        Rectangle2D elementBounds = ElementUtils.getElementBounds(e);
        Transform t = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform canvasToElement = t.getTransform(e);
        return GeometryUtils.transformShape(elementBounds, canvasToElement);
    }

    public static Rectangle2D getElementBoundsOnDiagram(IElement e, Rectangle2D result) {
        result = ElementUtils.getElementBounds(e, result);
        Transform t = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform canvasToElement = t.getTransform(e);
        Shape shp = GeometryUtils.transformShape(result, canvasToElement);
        result.setFrame(shp.getBounds2D());
        return result;
    }

    public static Shape getElementBoundsOnDiagram(Collection<IElement> elements) {
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return ElementUtils.getElementBoundsOnDiagram(elements.iterator().next());
        }
        Area a = new Area();
        for (IElement e : elements) {
            Shape bounds = ElementUtils.getElementBoundsOnDiagram(e);
            Area ae = bounds instanceof Area ? (Area)bounds : new Area(bounds);
            a.add(ae);
        }
        return a;
    }

    public static Rectangle2D getSurroundingElementBoundsOnDiagram(Collection<IElement> elements) {
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return ElementUtils.getElementBoundsOnDiagram(elements.iterator().next()).getBounds2D();
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (IElement e : elements) {
            Rectangle2D bounds = ElementUtils.getElementBoundsOnDiagram(e).getBounds2D();
            if (bounds.getMinX() < minX) {
                minX = bounds.getMinX();
            }
            if (bounds.getMinY() < minY) {
                minY = bounds.getMinY();
            }
            if (bounds.getMaxX() > maxX) {
                maxX = bounds.getMaxX();
            }
            if (!(bounds.getMaxY() > maxY)) continue;
            maxY = bounds.getMaxY();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static Shape getElementShape(IElement e) {
        List<Outline> shapeProviders = e.getElementClass().getItemsByClass(Outline.class);
        if (shapeProviders.isEmpty()) {
            return null;
        }
        if (shapeProviders.size() == 1) {
            return shapeProviders.iterator().next().getElementShape(e);
        }
        Area a = new Area();
        for (Outline es : shapeProviders) {
            Shape shape = es.getElementShape(e);
            Area ae = shape instanceof Area ? (Area)shape : new Area(shape);
            a.add(ae);
        }
        return a;
    }

    public static Shape getElementShapeOnDiagram(IElement e) {
        Shape shape = ElementUtils.getElementShape(e);
        if (shape == null) {
            return null;
        }
        Transform t = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform canvasToElement = t.getTransform(e);
        return GeometryUtils.transformShape(shape, canvasToElement);
    }

    public static Shape getElementShapeOrBounds(IElement e) {
        Shape shape = ElementUtils.getElementShape(e);
        if (shape != null) {
            return shape;
        }
        return ElementUtils.getElementBounds(e);
    }

    public static Shape getElementShapeOrBoundsOnDiagram(IElement e) {
        Shape shape = ElementUtils.getElementShapeOnDiagram(e);
        if (shape != null) {
            return shape;
        }
        return ElementUtils.getElementBoundsOnDiagram(e);
    }

    public static Shape getElementShapesOnDiagram(Collection<IElement> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            Shape shp = ElementUtils.getElementShapeOrBoundsOnDiagram(elements.iterator().next());
            return shp;
        }
        Area a = new Area();
        for (IElement e : elements) {
            Shape shape = ElementUtils.getElementShapeOrBoundsOnDiagram(e);
            Area aa = null;
            aa = shape instanceof Area ? (Area)shape : new Area(shape);
            a.add(aa);
        }
        return a;
    }

    public static Shape mergeShapes(Collection<Shape> shapes) {
        if (shapes.isEmpty()) {
            return null;
        }
        if (shapes.size() == 1) {
            return shapes.iterator().next();
        }
        Area a = new Area();
        for (Shape s : shapes) {
            a.add(new Area(s));
        }
        return a;
    }

    public static boolean pickInElement(IElement e, ICanvasContext ctx, PickRequest req) {
        Rectangle2D elementBounds = ElementUtils.getElementBounds(e);
        List<Pick> pickHandlers = e.getElementClass().getItemsByClass(Pick.class);
        if (!pickHandlers.isEmpty()) {
            if (!GeometryUtils.intersects(req.pickArea, elementBounds)) {
                return false;
            }
            for (Pick p : pickHandlers) {
                if (!p.pickTest(e, req.pickArea, req.pickPolicy)) continue;
                return true;
            }
            return false;
        }
        List<Outline> shapeHandlers = e.getElementClass().getItemsByClass(Outline.class);
        if (!shapeHandlers.isEmpty()) {
            if (!GeometryUtils.intersects(req.pickArea, elementBounds)) {
                return false;
            }
            if (req.pickPolicy == PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS) {
                for (Outline es : shapeHandlers) {
                    Shape elementShape = es.getElementShape(e);
                    if (!GeometryUtils.intersects(req.pickArea, elementShape)) continue;
                    return true;
                }
                return false;
            }
            if (req.pickPolicy == PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS) {
                for (Outline es : shapeHandlers) {
                    Shape elementShape = es.getElementShape(e);
                    if (GeometryUtils.contains(req.pickArea, elementShape)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return req.pickPolicy == PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS ? GeometryUtils.intersects(req.pickArea, elementBounds) : req.pickPolicy == PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS && GeometryUtils.contains(req.pickArea, (Shape)elementBounds);
    }

    public static void getBends(IElement e, List<BendsHandler.Bend> bends, List<Point2D> points) {
        BendsHandler bh = e.getElementClass().getSingleItem(BendsHandler.class);
        bh.getBends(e, bends);
        for (BendsHandler.Bend b : bends) {
            Point2D.Double pos = new Point2D.Double();
            bh.getBendPosition(e, b, pos);
            points.add(pos);
        }
    }

    public static void getBends(IElement e, List<Point2D> points) {
        BendsHandler bh = e.getElementClass().getSingleItem(BendsHandler.class);
        int bendCount = bh.getBendsCount(e);
        ArrayList<BendsHandler.Bend> bends = new ArrayList<BendsHandler.Bend>(bendCount);
        ElementUtils.getBends(e, bends, points);
    }

    public static void resizeElement(IElement e, double x, double y, double w, double h) {
        Move m = e.getElementClass().getSingleItem(Move.class);
        m.moveTo(e, x, y);
        Resize s = e.getElementClass().getSingleItem(Resize.class);
        s.resize(e, new Rectangle2D.Double(0.0, 0.0, w, h));
    }

    public static <T> T getHintOrDefault(IHintContext e, IHintContext.Key key, T defaultValue) {
        Object t = e.getHint(key);
        assert (key.isValueAccepted(defaultValue));
        return (T)(t == null ? defaultValue : t);
    }

    public static void setOrRemoveHint(IHintContext e, IHintContext.Key key, Object value) {
        if (value == null) {
            e.removeHint(key);
        } else {
            assert (key.isValueAccepted(value));
            e.setHint(key, value);
        }
    }

    public static boolean elementEquals(IElement e1, IElement e2) {
        Object o1 = ElementUtils.getObject(e1);
        Object o2 = ElementUtils.getObject(e2);
        if (o1 == null && o2 == null) {
            return ObjectUtils.objectEquals((Object)e1, (Object)e2);
        }
        return ObjectUtils.objectEquals(o1, o2);
    }

    public static IElement getDiagramMappedElement(IElement e) {
        IDiagram d = e.peekDiagram();
        if (d == null) {
            return e;
        }
        DataElementMap map = d.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        if (map == null) {
            return e;
        }
        Object o = map.getData(d, e);
        if (o == null) {
            return e;
        }
        IElement mapped = map.getElement(d, o);
        return mapped != null ? mapped : e;
    }

    public static Point2D getElementBoundsCenter(Collection<IElement> elements, Point2D result) {
        Shape b = ElementUtils.getElementBoundsOnDiagram(elements);
        if (b == null) {
            return null;
        }
        Rectangle2D bounds = b.getBounds2D();
        if (result == null) {
            result = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        } else {
            result.setLocation(bounds.getCenterX(), bounds.getCenterY());
        }
        return result;
    }

    public static IDiagram getDiagram(IElement e) {
        if (e == null) {
            throw new IllegalArgumentException("null element");
        }
        IDiagram d = ElementUtils.peekDiagram(e);
        if (d == null) {
            throw new IllegalStateException("element " + e + " is not part of a diagram");
        }
        return d;
    }

    public static IDiagram peekDiagram(IElement e) {
        while (e != null) {
            IDiagram d = e.peekDiagram();
            if (d != null) {
                return d;
            }
            e = ElementUtils.getParent(e);
        }
        return null;
    }

    public static IElement getParent(IElement e) {
        Parent p = e.getElementClass().getAtMostOneItemOfClass(Parent.class);
        if (p == null) {
            return null;
        }
        return p.getParent(e);
    }

    public static Collection<IElement> getParents(IElement e) {
        ArrayList<IElement> result = new ArrayList<IElement>(3);
        return ElementUtils.getParents(e, result);
    }

    public static Collection<IElement> getParents(IElement e, Collection<IElement> result) {
        IElement p = e;
        Parent ph;
        while ((ph = p.getElementClass().getAtMostOneItemOfClass(Parent.class)) != null) {
            if ((p = ph.getParent(p)) == null) {
                return result;
            }
            result.add(p);
        }
        return result;
    }

    public static String generateNodeId(IElement e) {
        Object object;
        String prefix = "";
        String sgName = (String)e.getHint(ElementHints.KEY_SG_NAME);
        if (sgName != null) {
            prefix = String.valueOf(sgName) + " ";
        }
        if ((object = e.getHint(ElementHints.KEY_OBJECT)) != null) {
            return String.valueOf(prefix) + object.toString();
        }
        return String.valueOf(e.hashCode());
    }

    public static <T> T adaptElement(IElement e, Class<T> toClass) {
        for (ElementAdapter adapter : e.getElementClass().getItemsByClass(ElementAdapter.class)) {
            T t = adapter.adapt(e, toClass);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> T adapt(ElementClass ec, Class<T> toClass) {
        if (ec == null) {
            throw new IllegalArgumentException("null element class");
        }
        if (toClass == null) {
            throw new IllegalArgumentException("null target class");
        }
        for (Adapter adapter : ec.getItemsByClass(Adapter.class)) {
            T t = adapter.adapt(toClass);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> T checkedAdapt(ElementClass ec, Class<T> toClass) {
        T t = ElementUtils.adapt(ec, toClass);
        if (t != null) {
            return t;
        }
        throw new UnsupportedOperationException("cannot adapt " + ec + " to " + toClass);
    }

    public static <T extends INode> T getOrCreateNode(IElement forElement, ParentNode<?> withParentNode, IHintContext.Key withNodeKey, Class<T> nodeClass) {
        return ElementUtils.getOrCreateNode(forElement, withParentNode, withNodeKey, null, nodeClass);
    }

    public static <T extends INode> T getOrCreateNode(IElement forElement, ParentNode<?> withParentNode, IHintContext.Key withNodeKey, String nodeId, Class<T> nodeClass) {
        return ElementUtils.getOrCreateNode(forElement, withParentNode, withNodeKey, nodeId, nodeClass, null);
    }

    public static <T extends INode> T getOrCreateNode(IElement forElement, ParentNode<?> withParentNode, IHintContext.Key withNodeKey, String nodeId, Class<T> nodeClass, Consumer<T> nodeCreationCallback) {
        INode node;
        if (!(withNodeKey instanceof SceneGraphNodeKey)) {
            System.out.println("ElementUtils.getOrCreateNode: WARNING: removing scene graph node with that does not extend SceneGraphNodeKey: " + withNodeKey);
        }
        if ((node = (INode)forElement.getHint(withNodeKey)) == null) {
            node = nodeId != null ? (INode)withParentNode.getOrCreateNode(nodeId, nodeClass) : (INode)withParentNode.addNode(nodeClass);
            forElement.setHint(withNodeKey, node);
            if (nodeCreationCallback != null) {
                nodeCreationCallback.accept(node);
            }
        } else {
            if (!nodeClass.isAssignableFrom(node.getClass())) {
                throw new ElementSceneGraphException("ElementUtils.getOrCreateNode: WARNING: existing node class (" + node.getClass() + ") does not match requested node class (" + nodeClass + ") for element " + forElement + " with parent node " + withParentNode + " and node key " + withNodeKey);
            }
            if (!withParentNode.equals((Object)node.getParent())) {
                node = nodeId != null ? (INode)withParentNode.getOrCreateNode(nodeId, nodeClass) : (INode)withParentNode.addNode(nodeClass);
                forElement.setHint(withNodeKey, node);
                if (nodeCreationCallback != null) {
                    nodeCreationCallback.accept(node);
                }
            }
        }
        return (T)node;
    }

    public static INode removePossibleNode(IElement element, IHintContext.Key nodeKey) {
        INode node;
        if (!(nodeKey instanceof SceneGraphNodeKey)) {
            System.out.println("ElementUtils.removePossibleNode: WARNING: removing scene graph node with that does not extend SceneGraphNodeKey: " + nodeKey);
        }
        if ((node = (INode)element.getHint(nodeKey)) != null) {
            node.remove();
        }
        return node;
    }

    public static Font getTextFont(IElement element) {
        TextFont tf = element.getElementClass().getSingleItem(TextFont.class);
        return tf.getFont(element);
    }

    public static void setTextFont(IElement element, Font font) {
        TextFont tf = element.getElementClass().getSingleItem(TextFont.class);
        tf.setFont(element, font);
    }

    public static <T> void addToCollectionHint(IElement element, IHintContext.Key key, T item) {
        ArrayList<T> collection = (ArrayList<T>)element.getHint(key);
        if (collection == null) {
            collection = new ArrayList<T>();
            element.setHint(key, collection);
        }
        collection.add(item);
    }

    public static <T> void removeFromCollectionHint(IElement element, IHintContext.Key key, T item) {
        ArrayList collection = (ArrayList)element.getHint(key);
        if (collection != null) {
            collection = new ArrayList();
            collection.remove(item);
            if (collection.isEmpty()) {
                element.removeHint(key);
            }
        }
    }

    public static void setHover(IElement e, boolean hover) {
        Hover h = e.getElementClass().getSingleItem(Hover.class);
        h.setHover(e, hover);
    }

    public static boolean isHovering(IElement e) {
        Hover h = e.getElementClass().getSingleItem(Hover.class);
        return h.isHovering(e);
    }
}

