/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.tests;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.simantics.scl.runtime.chr.Fact;
import org.simantics.scl.runtime.chr.FactActivationQueue;

public class TestFactActivationQueue {
    public static Random RANDOM = new Random();

    private void testRandomly(int priorities, int size) {
        FactActivationQueue queue = new FactActivationQueue(priorities);
        TIntArrayList list = new TIntArrayList(size);
        int i = 0;
        while (i < size) {
            int val = RANDOM.nextInt(priorities);
            queue.add(val, new MyFact(list, val));
            ++i;
        }
        queue.activate(null, priorities);
        Assert.assertEquals((long)size, (long)list.size());
        i = 1;
        while (i < list.size()) {
            int b;
            int a = list.get(i - 1);
            Assert.assertTrue((a <= (b = list.get(i)) ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testRandomly() {
        int i = 0;
        while (i < 10000) {
            this.testRandomly(10, 10000);
            ++i;
        }
    }

    private static class MyFact
    implements Fact {
        TIntArrayList list;
        int priority;

        public MyFact(TIntArrayList list, int priority) {
            this.list = list;
            this.priority = priority;
        }

        @Override
        public int activate(Object context, int priority) {
            Assert.assertEquals((long)this.priority, (long)priority);
            this.list.add(priority);
            return -1;
        }

        @Override
        public boolean isAlive() {
            return true;
        }
    }
}

