/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.chr;

import java.util.Arrays;
import org.simantics.scl.runtime.chr.Fact;

class PriorityContainer {
    private static final boolean CLEANUP_ENABLED = true;
    final int priority;
    Fact[] facts = new Fact[4];
    int size;

    public PriorityContainer(int priority) {
        this.priority = priority;
    }

    public void push(Fact item) {
        if (this.size == this.facts.length) {
            this.increaseCapacity();
        }
        this.facts[this.size++] = item;
    }

    private void increaseCapacity() {
        int j = 0;
        int i = 0;
        while (i < this.size) {
            Fact fact = this.facts[i];
            if (fact.isAlive()) {
                this.facts[j++] = fact;
            }
            ++i;
        }
        this.size = j;
        if (this.size >= this.facts.length * 3 / 4) {
            this.facts = Arrays.copyOf(this.facts, this.size * 2);
        }
    }

    public Fact pop() {
        return this.facts[--this.size];
    }
}

