/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.chr;

import java.util.Arrays;
import org.simantics.scl.runtime.chr.Fact;
import org.simantics.scl.runtime.chr.PriorityContainer;

public class FactActivationQueue {
    public static final boolean TRACE = false;
    private final PriorityContainer[] containers;
    private PriorityContainer[] activeContainers = new PriorityContainer[8];
    private int activeContainerCount;

    public FactActivationQueue(int priorityCount) {
        this.containers = new PriorityContainer[priorityCount];
        int i = 0;
        while (i < priorityCount) {
            this.containers[i] = new PriorityContainer(i);
            ++i;
        }
    }

    public void add(int priority, Fact item) {
        PriorityContainer container = this.containers[priority];
        if (container.size == 0) {
            this.activateContainer(container);
        }
        container.push(item);
    }

    private void activateContainer(PriorityContainer container) {
        if (this.activeContainers.length == this.activeContainerCount) {
            this.activeContainers = Arrays.copyOf(this.activeContainers, this.activeContainerCount * 2);
        }
        this.adjustUpwards(this.activeContainerCount, container);
        ++this.activeContainerCount;
    }

    private void deactivateContainer() {
        --this.activeContainerCount;
        this.adjustDownwards(0, this.activeContainers[this.activeContainerCount]);
        this.activeContainers[this.activeContainerCount] = null;
    }

    private void adjustDownwards(int pos, PriorityContainer item) {
        int priority = item.priority;
        while (true) {
            PriorityContainer item1;
            int npos;
            if ((npos = 2 * pos + 1) + 1 >= this.activeContainerCount) {
                if (npos >= this.activeContainerCount) break;
                item1 = this.activeContainers[npos];
                if (priority <= item1.priority) break;
                this.activeContainers[pos] = item1;
                this.activeContainers[npos] = item;
                return;
            }
            item1 = this.activeContainers[npos];
            PriorityContainer item2 = this.activeContainers[npos + 1];
            if (priority < item1.priority) {
                if (priority < item2.priority) {
                    break;
                }
            } else if (item1.priority < item2.priority) {
                this.activeContainers[pos] = item1;
                pos = npos;
                continue;
            }
            this.activeContainers[pos] = item2;
            pos = npos + 1;
        }
        this.activeContainers[pos] = item;
    }

    private void adjustUpwards(int pos, PriorityContainer item) {
        int priority = item.priority;
        while (pos > 0) {
            int npos = (pos - 1) / 2;
            PriorityContainer item1 = this.activeContainers[npos];
            if (item1.priority <= priority) break;
            this.activeContainers[pos] = item1;
            pos = npos;
        }
        this.activeContainers[pos] = item;
    }

    public void activate(Object context, int currentPriority) {
        while (this.activeContainerCount > 0) {
            int newPriority;
            PriorityContainer topContainer = this.activeContainers[0];
            int priority = topContainer.priority;
            if (priority >= currentPriority) {
                return;
            }
            Fact fact = topContainer.pop();
            if (topContainer.size == 0) {
                this.deactivateContainer();
            }
            if ((newPriority = fact.activate(context, priority)) < 0) continue;
            this.add(newPriority, fact);
        }
    }
}

