/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.graph.impl.ResourceProperty;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.utils.datastructures.slice.ValueRange;

public class ResourceArrayProperty
extends ResourceProperty
implements IArrayProperty {
    protected final ValueRange range;

    public ResourceArrayProperty(IProperty.Type type, ValueRange range, Resource subject, Resource predicate, Resource value, ResourceArray path) {
        super(type, subject, predicate, value, path);
        if (range == null) {
            throw new IllegalArgumentException("null value range");
        }
        this.range = range;
    }

    public ValueRange getRange() {
        return this.range;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "[range=" + this.range + "]";
    }

    @Override
    public int propertyHashCode() {
        return super.propertyHashCode() * 31 + this.range.hashCode();
    }

    @Override
    public boolean propertyEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.propertyEquals(obj)) {
            return false;
        }
        ResourceArrayProperty other = (ResourceArrayProperty)obj;
        return this.range.equals((Object)other.range);
    }

    @Override
    public int hashCode() {
        return this.range.hashCode() + 31 * super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ResourceArrayProperty other = (ResourceArrayProperty)obj;
        return this.range.equals((Object)other.range);
    }

    public IArrayProperty slice(ValueRange range) {
        return new SlicedResourceArrayProperty(this.type, range, this.subject, this.predicate, this.value, this.path);
    }

    public boolean isSlice() {
        return false;
    }

    private static class SlicedResourceArrayProperty
    extends ResourceArrayProperty {
        public SlicedResourceArrayProperty(IProperty.Type type, ValueRange range, Resource subject, Resource predicate, Resource value, ResourceArray path) {
            super(type, range, subject, predicate, value, path);
        }

        @Override
        public boolean isSlice() {
            return true;
        }
    }
}

