/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TEffectAst;
import org.simantics.scl.compiler.internal.types.ast.TFunctionAst;
import org.simantics.scl.compiler.internal.types.ast.TPredAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TUnion;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class TFun
extends Type {
    public Type domain;
    public Type effect;
    public Type range;

    TFun(Type domain, Type effect, Type range) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (effect == null) {
            throw new NullPointerException();
        }
        if (range == null) {
            throw new NullPointerException();
        }
        this.domain = domain;
        this.effect = effect;
        this.range = range;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        Type newDomain = this.domain.replace(var, replacement);
        Type newEffect = this.effect.replace(var, replacement);
        Type newRange = this.range.replace(var, replacement);
        if (newDomain == this.domain && newEffect == this.effect && newRange == this.range) {
            return this;
        }
        return new TFun(newDomain, newEffect, newRange);
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        Type dom;
        TypeAst domainAst = this.domain.toTypeAst(context);
        TypeAst rangeAst = this.range.toTypeAst(context);
        if (Types.canonical(this.effect) != Types.NO_EFFECTS) {
            rangeAst = new TEffectAst(this.effect.toTypeAst(context), rangeAst);
        }
        if ((dom = Types.canonical(this.domain)) instanceof TPred) {
            return new TPredAst(domainAst, rangeAst);
        }
        if (dom == Types.PUNIT) {
            return rangeAst;
        }
        return new TFunctionAst(domainAst, rangeAst);
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        b.append("FUNC_");
        this.domain.toName(context, b);
        b.append('_');
        this.effect.toName(context, b);
        b.append('_');
        this.range.toName(context, b);
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(-14073069);
        this.domain.updateHashCode(context);
        this.effect.updateHashCode(context);
        this.range.updateHashCode(context);
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        this.domain.collectFreeVars(vars);
        this.effect.collectFreeVars(vars);
        this.range.collectFreeVars(vars);
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        this.domain.collectMetaVars(vars);
        this.effect.collectMetaVars(vars);
        this.range.collectMetaVars(vars);
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        this.domain.collectMetaVars(vars);
        this.effect.collectMetaVars(vars);
        this.range.collectMetaVars(vars);
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        this.domain.collectEffectMetaVars(vars);
        this.effect.collectMetaVars(vars);
        this.range.collectEffectMetaVars(vars);
    }

    @Override
    public boolean isGround() {
        return this.domain.isGround() && this.effect.isGround() && this.range.isGround();
    }

    @Override
    public boolean containsMetaVars() {
        return this.domain.containsMetaVars() || this.effect.containsMetaVars() || this.range.containsMetaVars();
    }

    @Override
    public boolean contains(TMetaVar other) {
        return this.domain.contains(other) || this.effect.contains(other) || this.range.contains(other);
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public Kind inferKind(Environment context) throws KindUnificationException {
        this.domain.checkKind(context, Kinds.STAR);
        this.range.checkKind(context, Kinds.STAR);
        return Kinds.STAR;
    }

    @Override
    public Type convertMetaVarsToVars() {
        Type newDomain = this.domain.convertMetaVarsToVars();
        Type newEffect = this.effect.convertMetaVarsToVars();
        Type newRange = this.range.convertMetaVarsToVars();
        if (newDomain == this.domain && newEffect == this.effect && newRange == this.range) {
            return this;
        }
        return new TFun(newDomain, newEffect, newRange);
    }

    @Override
    public boolean isMinimal() {
        return Types.canonical(this.effect) == Types.NO_EFFECTS && this.range.isMinimal() && this.domain.isMaximal();
    }

    @Override
    public boolean isMaximal() {
        return false;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        this.domain.addPolarity(polarity.flip());
        this.effect.addPolarity(polarity);
        this.range.addPolarity(polarity);
    }

    @Override
    public Type head() {
        return Types.ARROW;
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        Type newDomain = this.domain.copySkeleton(metaVarMap);
        TUnion newEffect = Types.NO_EFFECTS;
        Type newRange = this.range.copySkeleton(metaVarMap);
        return new TFun(newDomain, newEffect, newRange);
    }

    @Override
    public int hashCode(int hash) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, FUN_HASH);
        hash = this.domain.hashCode(hash);
        hash = this.effect.hashCode(hash);
        hash = this.range.hashCode(hash);
        return hash;
    }

    @Override
    public int hashCode(int hash, TVar[] boundVars) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, FUN_HASH);
        hash = this.domain.hashCode(hash, boundVars);
        hash = this.effect.hashCode(hash, boundVars);
        hash = this.range.hashCode(hash, boundVars);
        return hash;
    }

    @Override
    public int skeletonHashCode(int hash) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, FUN_HASH);
        hash = this.domain.skeletonHashCode(hash);
        hash = this.range.skeletonHashCode(hash);
        return hash;
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] boundVars) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, FUN_HASH);
        hash = this.domain.skeletonHashCode(hash, boundVars);
        hash = this.range.skeletonHashCode(hash, boundVars);
        return hash;
    }

    public Type getCanonicalDomain() {
        if (this.domain instanceof TMetaVar) {
            this.domain = this.domain.canonical();
        }
        return this.domain;
    }

    public Type getCanonicalEffect() {
        if (this.effect instanceof TMetaVar) {
            this.effect = this.effect.canonical();
        }
        return this.effect;
    }

    public Type getCanonicalRange() {
        if (this.range instanceof TMetaVar) {
            this.range = this.range.canonical();
        }
        return this.range;
    }

    @Override
    public boolean equalsCanonical(Type other) {
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(TFun.class)) {
            return false;
        }
        TFun fun = (TFun)other;
        return this.getCanonicalDomain().equalsCanonical(fun.getCanonicalDomain()) && this.getCanonicalEffect().equalsCanonical(fun.getCanonicalEffect()) && this.getCanonicalRange().equalsCanonical(fun.getCanonicalRange());
    }

    @Override
    public Kind getKind(Environment context) {
        return Kinds.STAR;
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        return new Type[]{Skeletons.canonicalSkeleton(this.domain), Skeletons.canonicalSkeleton(this.range)};
    }
}

