/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source.repository;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.Collection;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.PrecompiledModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

public class MapModuleSourceRepository
implements ModuleSourceRepository {
    THashMap<String, ModuleSource> modules = new THashMap();
    THashMap<String, String> documentations = new THashMap();

    public MapModuleSourceRepository() {
    }

    public MapModuleSourceRepository(ModuleSource ... descriptors) {
        ModuleSource[] moduleSourceArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleSource descriptor = moduleSourceArray[n2];
            this.addModuleDescriptor(descriptor);
            ++n2;
        }
    }

    public MapModuleSourceRepository(Module ... modules) {
        Module[] moduleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            this.addModule(module);
            ++n2;
        }
    }

    public void addModuleDescriptor(ModuleSource descriptor) {
        this.modules.put((Object)descriptor.getModuleName(), (Object)descriptor);
    }

    public void addModule(Module module) {
        this.addModuleDescriptor(new PrecompiledModuleSource(module));
    }

    public void addDocumentation(String documentationName, String documentation) {
        this.documentations.put((Object)documentationName, (Object)documentation);
    }

    @Override
    public ModuleSource getModuleSource(String moduleName, UpdateListener listener) {
        return (ModuleSource)this.modules.get((Object)moduleName);
    }

    @Override
    public Collection<String> getModuleNames() {
        return this.modules.keySet();
    }

    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
        this.modules.forEachKey(procedure);
    }

    @Override
    public String getDocumentation(String documentationName) {
        return (String)this.documentations.get((Object)documentationName);
    }

    @Override
    public Collection<String> getDocumentationNames() {
        return this.documentations.keySet();
    }
}

