/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.table;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;
import org.simantics.scl.compiler.parser.generator.grammar.Prod;
import org.simantics.scl.compiler.parser.generator.table.Item;
import org.simantics.scl.compiler.parser.generator.table.ItemSet;
import org.simantics.scl.compiler.parser.generator.table.ParseTable;

public class ParseTableBuilder {
    public static final int MAX_STACK_ID = 10;
    private static final int STATE_MASK = 4095;
    private static final int REDUCE_MASK = 32768;
    private static final int POP_MASK = 16384;
    private static final int PUSH_MASK = 8192;
    public static final int ERROR_ACTION = 65535;
    private static final int ACCEPT_ACTION = 65534;
    final AnaGrammar grammar;
    private TObjectIntHashMap<ItemSet> states = new TObjectIntHashMap();
    private ArrayList<ItemSet> itemSets = new ArrayList();
    private ArrayList<TIntIntHashMap> transitions = new ArrayList();
    private ArrayList<TIntIntHashMap> stackOps = new ArrayList();
    private TIntArrayList backTransSymbols = new TIntArrayList();
    private ArrayList<TIntArrayList> backLinks = new ArrayList();
    int[] initialStates;
    TIntHashSet finalStates = new TIntHashSet();
    TLongArrayList sMap = new TLongArrayList();
    TLongIntHashMap sMapInv = new TLongIntHashMap();
    TIntHashSet[] follow;

    private ParseTableBuilder(AnaGrammar grammar) {
        this.grammar = grammar;
    }

    private static boolean isNonterminal(int symbol) {
        return symbol < 0;
    }

    private void close(ArrayList<Item> items) {
        THashSet itemSet = new THashSet(items);
        int i = 0;
        while (i < items.size()) {
            Item item = items.get(i);
            int[] nArray = item.nextSymbols(this.grammar);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int nextSymbol = nArray[n2];
                if (ParseTableBuilder.isNonterminal(nextSymbol)) {
                    int pEnd = this.grammar.nonterminalPos[(nextSymbol ^= 0xFFFFFFFF) + 1];
                    int pId = this.grammar.nonterminalPos[nextSymbol];
                    while (pId < pEnd) {
                        Item newItem = new Item(pId, this.grammar.prods.get((int)pId).rhs.getInitialState(), -1);
                        if (itemSet.add((Object)newItem)) {
                            items.add(newItem);
                        }
                        ++pId;
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private int getState(int backTransSymbol, ArrayList<Item> items) {
        this.close(items);
        final ItemSet itemSet = new ItemSet(items);
        if (this.states.contains((Object)itemSet)) {
            return this.states.get((Object)itemSet);
        }
        final int newState = this.states.size();
        this.states.put((Object)itemSet, newState);
        this.itemSets.add(itemSet);
        this.backTransSymbols.add(backTransSymbol);
        this.backLinks.add(new TIntArrayList(2));
        TIntObjectHashMap transitionMap = new TIntObjectHashMap();
        for (Item item : items) {
            int[] nArray = item.nextSymbols(this.grammar);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int s = nArray[n2];
                ArrayList<Item> l = (ArrayList<Item>)transitionMap.get(s);
                if (l == null) {
                    l = new ArrayList<Item>();
                    transitionMap.put(s, l);
                }
                l.add(new Item(item.production, item.nextPosition(this.grammar, s), item.stackPos));
                ++n2;
            }
        }
        final TIntIntHashMap trans = new TIntIntHashMap();
        final TIntIntHashMap stackOpMap = new TIntIntHashMap();
        this.transitions.add(trans);
        this.stackOps.add(stackOpMap);
        if (transitionMap.remove(this.grammar.terminalNames.length - 1) != null) {
            this.finalStates.add(newState);
        }
        transitionMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<ArrayList<Item>>(){

            public boolean execute(int a, ArrayList<Item> b) {
                boolean stackShift = false;
                int minStackPos = Integer.MAX_VALUE;
                for (Item item : b) {
                    if (item.stackPos == -1) {
                        stackShift = true;
                        continue;
                    }
                    minStackPos = Math.min(minStackPos, item.stackPos);
                }
                int stackOp = 0;
                if (minStackPos > 0 && minStackPos != Integer.MAX_VALUE) {
                    stackOp |= 0x4000;
                    for (Item item : b) {
                        if (item.stackPos < 0) continue;
                        --item.stackPos;
                    }
                }
                boolean stackOverflow = false;
                if (stackShift) {
                    stackOp |= 0x2000;
                    for (Item item : b) {
                        ++item.stackPos;
                        if (item.stackPos <= 10) continue;
                        stackOverflow = true;
                    }
                }
                stackOpMap.put(a, stackOp);
                System.out.println(String.valueOf(newState) + " " + ParseTableBuilder.this.grammar.getName(a) + " " + stackOp);
                if (stackOverflow) {
                    System.err.println("Stack overflow when following " + ParseTableBuilder.this.grammar.getName(a) + " at");
                    System.err.println(itemSet.toString(ParseTableBuilder.this.grammar));
                } else {
                    int state = ParseTableBuilder.this.getState(a, b);
                    trans.put(a, state);
                    ((TIntArrayList)ParseTableBuilder.this.backLinks.get(state)).add(newState);
                }
                return true;
            }
        });
        return newState;
    }

    private static int getState(long s) {
        return (int)(s >> 32);
    }

    private static int getSymbol(long s) {
        return (int)s;
    }

    private static long getS(int state, int symbol) {
        return (long)state << 32 | (long)symbol;
    }

    private void computeFollow() {
        int i = 0;
        while (i < this.itemSets.size()) {
            final int source = i;
            this.transitions.get(i).forEachEntry(new TIntIntProcedure(){

                public boolean execute(int symbol, int target) {
                    if (symbol < 0) {
                        long s = ParseTableBuilder.getS(source, ~symbol);
                        int id = ParseTableBuilder.this.sMap.size();
                        ParseTableBuilder.this.sMap.add(s);
                        ParseTableBuilder.this.sMapInv.put(s, id);
                    }
                    return true;
                }
            });
            ++i;
        }
        this.follow = new TIntHashSet[this.sMap.size()];
        final TIntHashSet[] gread = new TIntHashSet[this.follow.length];
        TIntHashSet[] gla = new TIntHashSet[this.sMap.size()];
        int i2 = 0;
        while (i2 < this.follow.length) {
            gread[i2] = new TIntHashSet();
            gla[i2] = new TIntHashSet();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.follow.length) {
            final int id = i2;
            long s = this.sMap.get(i2);
            int source = ParseTableBuilder.getState(s);
            int symbol = ParseTableBuilder.getSymbol(s);
            final int target = this.transitions.get(source).get(~symbol);
            final TIntHashSet drSet = new TIntHashSet();
            this.transitions.get(target).forEachEntry(new TIntIntProcedure(){

                public boolean execute(int symbol2, int target2) {
                    if (symbol2 >= 0) {
                        drSet.add(symbol2);
                    } else if (ParseTableBuilder.this.grammar.nullable[~symbol2]) {
                        gread[ParseTableBuilder.this.sMapInv.get(ParseTableBuilder.getS(target, ~symbol2))].add(id);
                    }
                    return true;
                }
            });
            if (this.finalStates.contains(target)) {
                drSet.add(this.grammar.terminalNames.length - 1);
            }
            this.follow[i2] = drSet;
            ItemSet set = this.itemSets.get(target);
            Item[] itemArray = set.items;
            int n = set.items.length;
            int n2 = 0;
            while (n2 < n) {
                Item targetItem = itemArray[n2];
                Prod prod = this.grammar.prods.get(targetItem.production);
                if (this.grammar.almostAccepts(prod.rhs, targetItem.position)) {
                    Item[] itemArray2 = this.itemSets.get((int)source).items;
                    int n3 = this.itemSets.get((int)source).items.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Item sourceItem = itemArray2[n4];
                        if (sourceItem.production == targetItem.production && prod.rhs.getTransition(sourceItem.position, ~symbol) == targetItem.position) {
                            TLongHashSet visited = new TLongHashSet();
                            this.traceBack(gla, id, visited, source, sourceItem);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            ++i2;
        }
        AnaGrammar.gclose(this.follow, gread);
        AnaGrammar.gclose(this.follow, gla);
    }

    private void traceBack(TIntHashSet[] gla, int initialId, TLongHashSet visited, int state, Item item) {
        if (visited.add((long)state << 32 | (long)item.position)) {
            Prod prod = this.grammar.prods.get(item.production);
            if (item.stackPos == -1) {
                int id = this.sMapInv.get(ParseTableBuilder.getS(state, prod.lhs));
                gla[id].add(initialId);
            }
            int backTransSymbol = this.backTransSymbols.get(state);
            int[] nArray = this.backLinks.get(state).toArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int prevState = nArray[n2];
                Item[] itemArray = this.itemSets.get((int)prevState).items;
                int n3 = this.itemSets.get((int)prevState).items.length;
                int n4 = 0;
                while (n4 < n3) {
                    Item prevItem = itemArray[n4];
                    if (prevItem.production == item.production && prod.rhs.getTransition(prevItem.position, backTransSymbol) == item.position) {
                        this.traceBack(gla, initialId, visited, prevState, prevItem);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void lookback(TLongHashSet visited, TIntHashSet la, int production, int state, int position) {
        if (visited.add((long)state << 32 | (long)position)) {
            int backTransSymbol = this.backTransSymbols.get(state);
            Prod prod = this.grammar.prods.get(production);
            boolean mightBeInitial = prod.rhs.getTransition(prod.rhs.getInitialState(), backTransSymbol) == position;
            int[] nArray = this.backLinks.get(state).toArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int prevState = nArray[n2];
                Item[] itemArray = this.itemSets.get((int)prevState).items;
                int n3 = this.itemSets.get((int)prevState).items.length;
                int n4 = 0;
                while (n4 < n3) {
                    Item item = itemArray[n4];
                    if (item.production == production && prod.rhs.getTransition(item.position, backTransSymbol) == position) {
                        this.lookback(visited, la, production, prevState, item.position);
                    }
                    if (mightBeInitial && this.grammar.prods.get((int)item.production).rhs.getTransition(item.position, ~prod.lhs) >= 0) {
                        int id = this.sMapInv.get(ParseTableBuilder.getS(prevState, prod.lhs));
                        la.addAll((TIntCollection)this.follow[id]);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void createReduceActions() {
        this.computeFollow();
        int i = 0;
        while (i < this.itemSets.size()) {
            TIntHashSet la;
            TIntIntHashMap trans = this.transitions.get(i);
            if (this.finalStates.contains(i)) {
                trans.put(this.grammar.terminalNames.length - 1, 65534);
            }
            TIntObjectHashMap laMap = new TIntObjectHashMap();
            TIntIntHashMap stackPosMap = new TIntIntHashMap();
            Object[] objectArray = this.itemSets.get((int)i).items;
            int n = this.itemSets.get((int)i).items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = objectArray[n2];
                Prod prod = this.grammar.prods.get(item.production);
                if (prod.rhs.getAccepts(item.position)) {
                    la = (TIntHashSet)laMap.get(item.production);
                    if (la == null) {
                        la = new TIntHashSet();
                        laMap.put(item.production, (Object)la);
                    }
                    TLongHashSet visited = new TLongHashSet();
                    this.lookback(visited, la, item.production, i, item.position);
                    if (stackPosMap.containsKey(item.production)) {
                        stackPosMap.put(item.production, Math.max(item.stackPos, stackPosMap.get(item.production)));
                    } else {
                        stackPosMap.put(item.production, item.stackPos);
                    }
                }
                ++n2;
            }
            int[] nArray = laMap.keys();
            objectArray = nArray;
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                Item production = objectArray[n2];
                int stackPos = 0;
                la = (TIntHashSet)laMap.get((int)production);
                int[] nArray2 = la.toArray();
                int n3 = nArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    int symbol = nArray2[n4];
                    if (trans.contains(symbol)) {
                        int oldAction = trans.get(symbol);
                        if (oldAction >= 0) {
                            Prod prod = this.grammar.prods.get((int)production);
                            if (prod.annotations.containsKey(symbol)) {
                                byte v = prod.annotations.get(symbol);
                                if (v == 1) {
                                    trans.put(symbol, 0x8000 | production | stackPos << 13);
                                }
                            } else {
                                System.err.println("Shift/reduce conflict when encountering " + this.grammar.terminalNames[symbol] + " in context");
                                System.err.println(this.itemSets.get(i).toString(this.grammar));
                            }
                        } else {
                            System.err.println("Reduce/reduce conflict when encountering " + this.grammar.terminalNames[symbol] + " in context");
                            System.err.println(this.itemSets.get(i).toString(this.grammar));
                        }
                    } else {
                        trans.put(symbol, 0x8000 | production | stackPos << 13);
                    }
                    ++n4;
                }
                ++n2;
            }
            ++i;
        }
    }

    public static ParseTable build(AnaGrammar grammar) {
        ParseTableBuilder builder = new ParseTableBuilder(grammar);
        builder.initialStates = new int[grammar.initialNonterminals.length];
        int i = 0;
        while (i < grammar.initialNonterminals.length) {
            ArrayList<Item> seed = new ArrayList<Item>();
            int prodId = grammar.prods.size() - i - 1;
            seed.add(new Item(prodId, grammar.prods.get((int)prodId).rhs.getInitialState(), 0));
            builder.initialStates[i] = builder.getState(32768, seed);
            ++i;
        }
        builder.createReduceActions();
        System.out.println("States: " + builder.itemSets.size());
        builder.printParseTable();
        return builder.getParseTable();
    }

    private ParseTable getParseTable() {
        int[] productionInfo = new int[this.grammar.prods.size()];
        int i = 0;
        while (i < productionInfo.length) {
            Prod prod = this.grammar.prods.get(i);
            productionInfo[i] = prod.lhs;
            ++i;
        }
        int[][] actionTable = new int[this.transitions.size()][];
        int[][] gotoTable = new int[this.transitions.size()][];
        int i2 = 0;
        while (i2 < this.transitions.size()) {
            final int[] actions = new int[this.grammar.terminalNames.length];
            Arrays.fill(actions, 65535);
            actionTable[i2] = actions;
            final int[] gotos = new int[this.grammar.nonterminalNames.length];
            Arrays.fill(gotos, 65535);
            gotoTable[i2] = gotos;
            final TIntIntHashMap stackOpMap = this.stackOps.get(i2);
            this.transitions.get(i2).forEachEntry(new TIntIntProcedure(){

                public boolean execute(int a, int b) {
                    int action = b | stackOpMap.get(a);
                    if (a >= 0) {
                        actions[a] = action;
                    } else {
                        gotos[a ^ 0xFFFFFFFF] = action;
                    }
                    return true;
                }
            });
            ++i2;
        }
        String[] stateDescriptions = new String[this.itemSets.size()];
        int i3 = 0;
        while (i3 < stateDescriptions.length) {
            final StringBuilder b = new StringBuilder();
            b.append(this.itemSets.get(i3).toString(this.grammar));
            this.transitions.get(i3).forEachEntry(new TIntIntProcedure(){

                public boolean execute(int symbol, int action) {
                    if (symbol >= 0) {
                        b.append("\n    ").append(ParseTableBuilder.this.grammar.terminalNames[symbol]).append(" ->");
                        if ((action & 0x8000) == 0) {
                            if ((action & 0x4000) != 0) {
                                b.append(" POP");
                            }
                            if ((action & 0x2000) != 0) {
                                b.append(" PUSH");
                            }
                            b.append(" SHIFT(").append(action & 0xFFF).append(")");
                        } else if (action == -2) {
                            b.append(" ACCEPT");
                        } else {
                            b.append(" REDUCE(").append(action & 0xFFF).append(")");
                        }
                    } else {
                        b.append("\n    ").append(ParseTableBuilder.this.grammar.nonterminalNames[~symbol]).append(" ->").append(" GOTO(").append(action).append(")");
                    }
                    return true;
                }
            });
            stateDescriptions[i3] = b.toString();
            ++i3;
        }
        return new ParseTable(this.itemSets.size(), actionTable, gotoTable, productionInfo, this.initialStates, stateDescriptions);
    }

    private void printParseTable() {
        final ItemSet[] stateSets = new ItemSet[this.states.size()];
        this.states.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<ItemSet>(){

            public boolean execute(ItemSet a, int b) {
                stateSets[b] = a;
                return true;
            }
        });
        int i = 0;
        while (i < stateSets.length) {
            System.out.println("--- State " + i + " ---");
            System.out.println(stateSets[i].toString(this.grammar));
            final TIntIntHashMap stackOp = this.stackOps.get(i);
            this.transitions.get(i).forEachEntry(new TIntIntProcedure(){

                public boolean execute(int a, int b) {
                    int sOp = stackOp.get(a);
                    System.out.print(String.valueOf(ParseTableBuilder.this.grammar.getName(a)) + " -> ");
                    if (sOp != 0) {
                        System.out.print("[");
                        if ((sOp & 0x2000) != 0) {
                            sOp ^= 0x2000;
                            System.out.print("PUSH ");
                        }
                        if ((sOp & 0x4000) != 0) {
                            sOp ^= 0x4000;
                            System.out.print("POP ");
                        }
                        if (sOp != 0) {
                            System.out.print(sOp);
                        }
                        System.out.print("] ");
                    }
                    if ((b & 0x8000) != 0) {
                        System.out.println("reduce " + (b ^= 0x8000));
                    } else {
                        System.out.println("shift " + b);
                    }
                    return true;
                }
            });
            ++i;
        }
    }
}

