/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.nodes.Node;
import org.simantics.scl.compiler.markdown.nodes.ParagraphNode;

public class ItemNode
extends Node {
    public int indentation;

    public ItemNode(int indentation) {
        this.indentation = indentation;
    }

    @Override
    public boolean canContain(Node node) {
        return true;
    }

    @Override
    public void toHtml(StringBuilder b) {
        this.toHtml(b, true);
    }

    public void toHtml(StringBuilder b, boolean tight) {
        if (this.firstChild == null) {
            b.append("<li></li>\n");
            return;
        }
        if (tight) {
            b.append("<li>");
            boolean noNewline = true;
            Node child = this.firstChild;
            while (child != null) {
                if (child instanceof ParagraphNode) {
                    Node n = child.firstChild;
                    while (n != null) {
                        n.toHtml(b);
                        n = n.next;
                    }
                    noNewline = true;
                } else {
                    if (noNewline) {
                        b.append('\n');
                        noNewline = false;
                    }
                    child.toHtml(b);
                }
                child = child.next;
            }
            b.append("</li>\n");
        } else {
            b.append("<li>\n");
            super.toHtml(b);
            b.append("</li>\n");
        }
    }
}

