/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.internal.HtmlEscape;
import org.simantics.scl.compiler.markdown.nodes.Node;

public class CodeBlockNode
extends Node {
    public boolean fenced;
    public char fenceChar;
    public int fenceLength;
    public int fenceOffset;
    public String infoString;

    public CodeBlockNode() {
    }

    public CodeBlockNode(char fenceChar, int fenceLength, int fenceOffset) {
        this.fenced = true;
        this.fenceChar = fenceChar;
        this.fenceLength = fenceLength;
        this.fenceOffset = fenceOffset;
    }

    public CodeBlockNode(StringBuilder stringContent) {
        this.stringContent = stringContent;
    }

    @Override
    public boolean acceptLines() {
        return true;
    }

    @Override
    public void toHtml(StringBuilder b) {
        if (this.infoString == null || this.infoString.isEmpty()) {
            b.append("<pre><code>");
        } else {
            String[] parts = this.infoString.split(" ");
            b.append("<pre><code class=\"language-").append(parts[0]).append("\">");
        }
        if (this.stringContent.length() > 0) {
            b.append(HtmlEscape.escape(this.stringContent)).append('\n');
        }
        b.append("</code></pre>\n");
    }
}

