/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.markdown.html.SCLDocumentationExtensionNodeHandler;
import org.simantics.scl.compiler.markdown.internal.MarkdownParser;
import org.simantics.scl.compiler.markdown.nodes.DocumentNode;
import org.simantics.scl.compiler.markdown.nodes.HeaderNode;
import org.simantics.scl.compiler.markdown.nodes.Node;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;

public class HtmlDocumentationGeneration {
    private static String STYLESHEET;

    static {
        try (InputStream stream = HtmlDocumentationGeneration.class.getResourceAsStream("SclDoc.css");){
            int count;
            byte[] buffer = new byte[2048];
            int pos = 0;
            while ((count = stream.read(buffer, pos, buffer.length - pos)) > 0) {
                if ((pos += count) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, 2 * buffer.length);
            }
            STYLESHEET = new String(buffer, Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String generate(ModuleRepository moduleRepository, String documentationName, String navigation) {
        String documentation = moduleRepository.getDocumentation(documentationName);
        if (documentation == null || documentation.isEmpty()) {
            Failable<Module> module = moduleRepository.getModule(documentationName);
            if (!module.didSucceed()) {
                return "Didn't find documentation or module for " + documentationName + ".";
            }
            documentation = "# Module " + documentationName + "\n\nThis module is undocumented. This is a list of its definitions.\n\n::undocumented[]";
        }
        MarkdownParser parser = new MarkdownParser();
        try {
            DocumentNode result = parser.parseDocument(new StringReader(documentation));
            result.processExtensionNodes(new SCLDocumentationExtensionNodeHandler(moduleRepository, documentationName));
            StringBuilder b = new StringBuilder();
            HtmlDocumentationGeneration.addHTMLHeader(b);
            if (navigation != null) {
                b.append("<table class=\"pagestructure\"><tr><td class=\"navi\">\n");
                b.append(navigation);
                b.append("</td><td class=\"content\">\n");
            }
            HtmlDocumentationGeneration.addContentsTree(b, result);
            result.toHtml(b);
            if (navigation != null) {
                b.append("</td></tr></table>\n");
            }
            HtmlDocumentationGeneration.addHTMLFooter(b);
            return b.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void addContentsTree(StringBuilder b, Node node) {
        block7: {
            headers = node.extractHeaders();
            if (headers.size() <= 1) break block7;
            minLevel = 0x7FFFFFFF;
            minLevelCount = 0;
            for (HeaderNode header : headers) {
                if (header.level == minLevel) {
                    ++minLevelCount;
                    continue;
                }
                if (header.level >= minLevel) continue;
                minLevel = header.level;
                minLevelCount = 1;
            }
            if (minLevelCount == 1) {
                ++minLevel;
            }
            b.append("<div id=\"contentspanel\">");
            b.append("<h2>Contents</h2>\n");
            level = minLevel - 1;
            for (HeaderNode header : headers) {
                if (header.level >= minLevel) ** GOTO lbl31
                continue;
lbl-1000:
                // 1 sources

                {
                    if (header.level > level) {
                        b.append("<ul>\n");
                        ++level;
                        continue;
                    }
                    b.append("</ul>\n");
                    --level;
lbl31:
                    // 3 sources

                    ** while (header.level != level)
                }
lbl32:
                // 1 sources

                b.append("<li><a href=\"#");
                header.toPlainText(b);
                b.append("\">");
                header.toPlainText(b);
                b.append("</a></li>\n");
            }
            while (level >= minLevel) {
                b.append("</ul>\n");
                --level;
            }
            b.append("</div>");
        }
    }

    private static void addHTMLHeader(StringBuilder b) {
        b.append("<!DOCTYPE html>\n");
        b.append("<html>\n");
        b.append("<head>\n");
        b.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
        b.append("<meta http-equiv=\"x-ua-compatible\" content=\"IE=Edge\" />\n");
        b.append("<style type=\"text/css\">\n");
        b.append(STYLESHEET);
        b.append("</style>\n");
        b.append("</head>\n");
        b.append("<body>\n");
    }

    private static void addHTMLFooter(StringBuilder b) {
        b.append("</body>\n");
        b.append("</html>\n");
    }
}

